/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.StringTokenizer;

public class Initializer {
    GlobalData gl;
    String buffer = "";
    String CRLF = System.getProperty("line.separator", "\r\n");

    public Initializer(GlobalData gl) {
        this.gl = gl;
    }

    public boolean setParameterInitialisation(String[] all_param) {
        boolean rc = false;
        try {
            String param = "";
            String value = "";
            for (int i = 0; i < all_param.length; ++i) {
                if (!all_param[i].startsWith("-")) continue;
                param = all_param[i].substring(1);
                if ((value = all_param[++i]).startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                this.setParam(param, value);
            }
            rc = true;
        }
        catch (Exception ex) {
            this.gl.appendLine("ERROR: " + ex);
        }
        return rc;
    }

    public boolean readInitialisation() {
        boolean rc = false;
        BufferedReader fin = null;
        this.gl.srcdir.clear();
        try {
            String line;
            fin = new BufferedReader(new FileReader(this.gl.inifn));
            while ((line = fin.readLine()) != null) {
                if (line.startsWith("#")) {
                    this.buffer = this.buffer + line + this.CRLF;
                    continue;
                }
                int p = line.indexOf("=");
                if (p == -1) continue;
                String param = line.substring(0, p);
                String value = line.substring(p + 1);
                this.setParam(param, value);
            }
            fin.close();
            rc = true;
        }
        catch (Exception ex) {
            this.gl.appendLine("ERROR: " + ex);
            try {
                fin.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        return rc;
    }

    private void setParam(String param, String value) {
        if (param.equalsIgnoreCase("DOS_COPY")) {
            this.gl.doscopy = value.equalsIgnoreCase("1");
        } else if (param.equalsIgnoreCase("DOS_DELETE")) {
            this.gl.dosdelete = value.equalsIgnoreCase("1");
        } else if (param.equalsIgnoreCase("M3U_DOUBLE")) {
            this.gl.m3udouble = value.equalsIgnoreCase("1");
        } else if (param.equalsIgnoreCase("EXTERN_APPL_M3U")) {
            if (value.length() > 0) {
                this.gl.extapplm3u = value.trim();
            }
        } else if (param.equalsIgnoreCase("EXTERN_APPL_BAT")) {
            if (value.length() > 0) {
                this.gl.extapplbat = value.trim();
            }
        } else if (param.equalsIgnoreCase("EXTERN_APPL_LOG")) {
            if (value.length() > 0) {
                this.gl.extappllog = value.trim();
            }
        } else if (param.equalsIgnoreCase("ENCODE_TAG_TYP")) {
            if (value.length() > 0) {
                this.gl.enctagtyp = value.trim();
            }
        } else if (param.equalsIgnoreCase("ENCODE_FILE_TYP")) {
            if (value.length() > 0) {
                this.gl.encfiletyp = value.trim();
            }
        } else if (param.equalsIgnoreCase("OUTPUT_TYP")) {
            if (value.length() > 0) {
                this.gl.outfmt = value.trim();
            }
        } else if (param.equalsIgnoreCase("OUTPUT_FILE")) {
            if (value.length() > 0) {
                this.gl.outfn = value.trim();
            }
        } else if (param.equalsIgnoreCase("DOUBLE_DIR")) {
            if (value.length() > 0) {
                this.gl.doubledir = value.trim();
            }
        } else if (param.equalsIgnoreCase("NO_TAG_DIR")) {
            if (value.length() > 0) {
                this.gl.notagdir = value.trim();
            }
        } else if (param.equalsIgnoreCase("DIFF_TAG_DIR")) {
            if (value.length() > 0) {
                this.gl.difftagdir = value.trim();
            }
        } else if (param.equalsIgnoreCase("SRC_DIR")) {
            if (value.length() > 0) {
                String[] sa = this.Split(value);
                SrcDir dir = new SrcDir(sa[0], sa[1]);
                this.gl.srcdir.addElement(dir);
            }
        } else if (param.equalsIgnoreCase("MATCH_TITLE")) {
            if (value.length() > 0) {
                String[] sa = this.Split(value);
                this.gl.match_title = sa[0].equalsIgnoreCase("1");
                this.gl.match_title_perc = Integer.parseInt(sa[1]);
                this.gl.match_title_numb = sa[2].equalsIgnoreCase("NUMBERS");
                this.gl.match_title_bracket = sa[3].equalsIgnoreCase("BRACKETS");
            }
        } else if (param.equalsIgnoreCase("MATCH_ARTIST")) {
            if (value.length() > 0) {
                String[] sa = this.Split(value);
                this.gl.match_artist = sa[0].equalsIgnoreCase("1");
                this.gl.match_artist_perc = Integer.parseInt(sa[1]);
                this.gl.match_artist_numb = sa[2].equalsIgnoreCase("NUMBERS");
                this.gl.match_artist_bracket = sa[3].equalsIgnoreCase("BRACKETS");
            }
        } else if (param.equalsIgnoreCase("MATCH_ALBUM")) {
            if (value.length() > 0) {
                String[] sa = this.Split(value);
                this.gl.match_album = sa[0].equalsIgnoreCase("1");
                this.gl.match_album_perc = Integer.parseInt(sa[1]);
                this.gl.match_album_numb = sa[2].equalsIgnoreCase("NUMBERS");
                this.gl.match_album_bracket = sa[3].equalsIgnoreCase("BRACKETS");
            }
        } else if (param.equalsIgnoreCase("MATCH_FILENAME")) {
            if (value.length() > 0) {
                String[] sa = this.Split(value);
                this.gl.match_fn = sa[0].equalsIgnoreCase("1");
                this.gl.match_fn_perc = Integer.parseInt(sa[1]);
                this.gl.match_fn_numb = sa[2].equalsIgnoreCase("NUMBERS");
                this.gl.match_fn_bracket = sa[3].equalsIgnoreCase("BRACKETS");
            }
        } else if (param.equalsIgnoreCase("MATCH_DIFF_TAG")) {
            if (value.length() > 0) {
                String[] sa = this.Split(value);
                this.gl.match_difftag_perc = Integer.parseInt(sa[0]);
                this.gl.match_difftag_numb = sa[1].equalsIgnoreCase("NUMBERS");
                this.gl.match_difftag_bracket = sa[2].equalsIgnoreCase("BRACKETS");
            }
        } else if (param.equalsIgnoreCase("FILTER_DIFF_TAG")) {
            this.gl.filter_difftag = value.equalsIgnoreCase("1");
        } else if (param.equalsIgnoreCase("FILTER_NO_TAG")) {
            this.gl.filter_notag = value.equalsIgnoreCase("1");
        } else if (param.equalsIgnoreCase("FILTER_DOUBLE")) {
            this.gl.filter_double = value.equalsIgnoreCase("1");
        } else if (param.equalsIgnoreCase("MATCH_FILENAME_FORMAT")) {
            if (value.length() > 0) {
                this.gl.match_fn_fmt = value.trim();
            }
        } else if (param.equalsIgnoreCase("MATCH_CROSS")) {
            this.gl.match_cross = value.equalsIgnoreCase("1");
        }
    }

    public boolean writeInitialisation() {
        boolean rc = false;
        BufferedWriter fou = null;
        try {
            fou = new BufferedWriter(new FileWriter(this.gl.inifn));
            fou.write(this.buffer + this.CRLF);
            fou.write("DOS_COPY=" + this.decode(this.gl.doscopy) + this.CRLF);
            fou.write("DOS_DELETE=" + this.decode(this.gl.dosdelete) + this.CRLF);
            fou.write("M3U_DOUBLE=" + this.decode(this.gl.m3udouble) + this.CRLF);
            fou.write("EXTERN_APPL_M3U=" + this.gl.extapplm3u + this.CRLF);
            fou.write("EXTERN_APPL_BAT=" + this.gl.extapplbat + this.CRLF);
            fou.write("EXTERN_APPL_LOG=" + this.gl.extappllog + this.CRLF);
            fou.write("ENCODE_TAG_TYP=" + this.gl.enctagtyp + this.CRLF);
            fou.write("ENCODE_FILE_TYP=" + this.gl.encfiletyp + this.CRLF);
            fou.write("OUTPUT_TYP=" + this.gl.outfmt + this.CRLF);
            fou.write("OUTPUT_FILE=" + this.gl.outfn + this.CRLF);
            fou.write("DOUBLE_DIR=" + this.gl.doubledir + this.CRLF);
            fou.write("NO_TAG_DIR=" + this.gl.notagdir + this.CRLF);
            fou.write("DIFF_TAG_DIR=" + this.gl.difftagdir + this.CRLF);
            for (int i = 0; i < this.gl.srcdir.size(); ++i) {
                SrcDir dir = (SrcDir)this.gl.srcdir.elementAt(i);
                fou.write("SRC_DIR=" + dir.Dir + ";" + this.decode(dir.Subdir) + this.CRLF);
            }
            fou.write("MATCH_TITLE=" + this.decode(this.gl.match_title) + ";" + this.gl.match_title_perc + ";" + this.decode_number(this.gl.match_title_numb) + ";" + this.decode_bracket(this.gl.match_title_bracket) + this.CRLF);
            fou.write("MATCH_ARTIST=" + this.decode(this.gl.match_artist) + ";" + this.gl.match_artist_perc + ";" + this.decode_number(this.gl.match_artist_numb) + ";" + this.decode_bracket(this.gl.match_artist_bracket) + this.CRLF);
            fou.write("MATCH_ALBUM=" + this.decode(this.gl.match_album) + ";" + this.gl.match_album_perc + ";" + this.decode_number(this.gl.match_album_numb) + ";" + this.decode_bracket(this.gl.match_album_bracket) + this.CRLF);
            fou.write("MATCH_FILENAME=" + this.decode(this.gl.match_fn) + ";" + this.gl.match_fn_perc + ";" + this.decode_number(this.gl.match_fn_numb) + ";" + this.decode_bracket(this.gl.match_fn_bracket) + this.CRLF);
            fou.write("MATCH_DIFF_TAG=" + this.gl.match_difftag_perc + ";" + this.decode_number(this.gl.match_difftag_numb) + ";" + this.decode_bracket(this.gl.match_difftag_bracket) + this.CRLF);
            fou.write("FILTER_DIFF_TAG=" + this.decode(this.gl.filter_difftag) + this.CRLF);
            fou.write("FILTER_NO_TAG=" + this.decode(this.gl.filter_notag) + this.CRLF);
            fou.write("FILTER_DOUBLE=" + this.decode(this.gl.filter_double) + this.CRLF);
            fou.write("MATCH_FILENAME_FORMAT=" + this.gl.match_fn_fmt + this.CRLF);
            fou.write("MATCH_CROSS=" + this.decode(this.gl.match_cross) + this.CRLF);
            fou.close();
            rc = true;
        }
        catch (Exception ex) {
            this.gl.appendLine("ERROR: " + ex);
            try {
                fou.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        return rc;
    }

    private String[] Split(String s) {
        int i = 0;
        String[] rs = new String[5];
        StringTokenizer tok = new StringTokenizer(s, ";");
        while (tok.hasMoreElements()) {
            rs[i] = ((String)tok.nextElement()).trim();
            ++i;
        }
        return rs;
    }

    private String decode(boolean b) {
        if (b) {
            return "1";
        }
        return "0";
    }

    private String decode_number(boolean b) {
        if (b) {
            return "NUMBERS";
        }
        return "IGNORE_NUBMERS";
    }

    private String decode_bracket(boolean b) {
        if (b) {
            return "BRACKETS";
        }
        return "IGNORE_BRACKETS";
    }
}

