/*
 * Decompiled with CFR 0.152.
 */
import de.ueberdosis.mp3info.facades.Wamp;
import de.ueberdosis.mp3info.id3v2.ID3V2Reader;
import de.ueberdosis.mp3info.id3v2.ID3V2Tag;
import de.ueberdosis.util.OutputCtr;
import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Date;
import java.util.Vector;

public class MP3List
implements Runnable {
    Vector list = new Vector(500);
    GlobalData gl = null;
    MP3ListProcessor out = null;
    Thread thread = null;

    public MP3List(GlobalData gl) {
        this.gl = gl;
        this.out = new MP3ListProcessor(gl, this.list);
    }

    public void Start() {
        if (!this.gl.is_running) {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.destroy();
                this.thread = null;
            }
            this.thread = new Thread(this);
            this.thread.setPriority(5);
            this.thread.start();
        } else {
            this.gl.is_stopping = true;
        }
    }

    public void run() {
        boolean success = false;
        this.gl.is_running = true;
        this.gl.is_stopping = false;
        this.gl.toggleSearchButton();
        this.gl.c_all_files = 0;
        this.gl.c_difftag_files = 0;
        this.gl.c_equal_files = 0;
        this.gl.c_equal_files_size = 0L;
        this.gl.c_notag_files = 0;
        this.gl.putLine("Dateiliste erstellen...");
        if (this.createList()) {
            this.gl.appendLine("MP3-Dateien Scannen...");
            if (this.scannFiles()) {
                success = true;
                if (this.gl.filter_double) {
                    this.gl.appendLine("doppelte MP3-Dateien suchen...");
                    if (!this.findDoubles()) {
                        success = false;
                        this.gl.appendLine("Fehler bei der Suche nach Doppelten MP3-Dateien !");
                    }
                }
                if (this.gl.outfmt.equalsIgnoreCase("EXE")) {
                    this.gl.appendLine("Dateien bearbeiten (Copy/Delete)...");
                } else {
                    this.gl.appendLine("Datei generieren...");
                }
                if (success && this.out.processList()) {
                    this.gl.appendLine("Fertig !");
                    this.gl.appendLine("Anzahl aller Dateien:      " + this.gl.c_all_files);
                    this.gl.appendLine("Anzahl Dateien ohne TAG:   " + this.gl.c_notag_files);
                    this.gl.appendLine("Anzahl Dateien diff TAG:   " + this.gl.c_difftag_files);
                    this.gl.appendLine("Anzahl doppelter Dateien:  " + this.gl.c_equal_files + " ( " + this.gl.c_equal_files_size / 1024L / 1024L + " MB)");
                }
            } else {
                this.gl.appendLine("Fehler beim Scannen der MP3-Dateien !");
            }
        } else {
            this.gl.appendLine("Fehler beim Lesen eines Verzeichnisses !");
        }
        this.gl.is_running = false;
        this.gl.toggleSearchButton();
        try {
            URL url = null;
            url = success ? this.getClass().getResource("success.wav") : this.getClass().getResource("error.wav");
            AudioClip audio = Applet.newAudioClip(url);
            audio.play();
            Object var3_4 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.list.clear();
    }

    public Vector getDirecotyList() {
        return this.list;
    }

    public boolean createList() {
        this.list.clear();
        OutputCtr.setLevel(0);
        for (int i = 0; i < this.gl.srcdir.size(); ++i) {
            if (this.gl.is_stopping) {
                return false;
            }
            SrcDir dir = (SrcDir)this.gl.srcdir.elementAt(i);
            if (dir.Dir == null || dir.Dir.length() <= 0 || this.createDirectoryList(dir.Dir, dir.Subdir)) continue;
            return false;
        }
        return true;
    }

    private boolean createDirectoryList(String dir, boolean subdir) {
        boolean rc = true;
        File root = new File(dir);
        File[] f_list = root.listFiles();
        if (f_list != null) {
            for (int i = 0; i < f_list.length; ++i) {
                if (this.gl.is_stopping) {
                    return false;
                }
                if (f_list[i].isDirectory() && subdir) {
                    rc = this.createDirectoryList(f_list[i].getAbsolutePath(), subdir);
                    if (rc) continue;
                    this.gl.appendLine("DIR-ERROR: bei Erstellung der Dateiliste: ( " + dir + " )");
                    rc = false;
                    continue;
                }
                if (!f_list[i].isFile() || f_list[i].getAbsolutePath().toLowerCase().indexOf(".mp3") == -1) continue;
                MP3Element el = new MP3Element(f_list[i].getAbsolutePath());
                this.list.addElement(el);
            }
        } else {
            this.gl.appendLine("DIR-ERROR: kein g\u00fcltiges Directory " + dir);
            rc = false;
        }
        return rc;
    }

    public boolean scannFiles() {
        Date start = new Date();
        this.gl.setProgressMax(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.gl.is_stopping) {
                return false;
            }
            MP3Element el = (MP3Element)this.list.elementAt(i);
            try {
                this.readFile(el);
            }
            catch (Exception ex) {
                this.gl.appendLine("READ-ERROR: " + el.absFileName);
            }
            long running_time = new Date().getTime() - start.getTime();
            this.gl.setProgress(i + 1, running_time);
        }
        this.gl.setProgress(0, 0L);
        return true;
    }

    private void readFile(MP3Element el) throws Exception {
        File file = new File(el.absFileName);
        if (file.isFile()) {
            el.FileName = file.getName();
            el.Size = file.length();
            RandomAccessFile rd_file = new RandomAccessFile(el.absFileName, "r");
            ID3V2Reader x = new ID3V2Reader(rd_file, 0L);
            ID3V1Reader y = new ID3V1Reader();
            ID3V2Tag v2tag = x.getV2Tag();
            if (v2tag != null) {
                Wamp w = new Wamp(v2tag);
                el.Title = w.getTitle().trim();
                el.Artist = w.getArtist().trim();
                el.Album = w.getAlbum().trim();
                el.Version = 2;
                w = null;
                v2tag = null;
            }
            if (this.isEmptyTag(el.Title, el.Artist, el.Album)) {
                if (y.readID3V1Tag(rd_file, this.gl.enctagtyp)) {
                    el.Title = y.getTitle().trim();
                    el.Artist = y.getArtist().trim();
                    el.Album = y.getAlbum().trim();
                    el.Version = 1;
                }
                if (this.isEmptyTag(el.Title, el.Artist, el.Album)) {
                    el.Status = 1;
                    ++this.gl.c_notag_files;
                }
            }
            rd_file.close();
            x = null;
            y = null;
            if (this.gl.filter_difftag && el.Status == 0) {
                String fn_cmp = this.gl.match_fn_fmt;
                fn_cmp = MP3List.Replace(fn_cmp, "%TITLE%", el.Title);
                fn_cmp = MP3List.Replace(fn_cmp, "%ARTIST%", el.Artist);
                if (!this.isEqualString(el.FileName, fn_cmp = MP3List.Replace(fn_cmp, "%ALBUM%", el.Album) + ".mp3", this.gl.match_difftag_perc, this.gl.match_difftag_numb, this.gl.match_difftag_bracket)) {
                    el.Status = 2;
                    ++this.gl.c_difftag_files;
                }
            }
            ++this.gl.c_all_files;
        } else {
            this.list.remove(el);
        }
    }

    private boolean findDoubles() {
        Date start = new Date();
        Vector cmp_list = (Vector)this.list.clone();
        this.gl.setProgressMax(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            MP3Element e_top = (MP3Element)this.list.elementAt(i);
            if (e_top.Status == 0 || this.gl.match_fn && e_top.Status == 1) {
                for (int k = 0; k < cmp_list.size(); ++k) {
                    if (this.gl.is_stopping) {
                        return false;
                    }
                    MP3Element e_cmp = (MP3Element)cmp_list.elementAt(k);
                    if (e_top == e_cmp || (e_cmp.Status != 0 && (e_cmp.Status != 1 || !this.gl.match_cross) || !this.isEqualTAG(e_top, e_cmp)) && (e_cmp.Status != 0 && e_cmp.Status != 1 || !this.isEqualFileName(e_top.FileName, e_cmp.FileName))) continue;
                    ++this.gl.c_equal_files;
                    if (e_top.Size >= e_cmp.Size) {
                        this.gl.c_equal_files_size += e_cmp.Size;
                        e_top.Status = 4;
                        e_cmp.Status = 3;
                        e_top.addChildElement(e_cmp);
                        continue;
                    }
                    this.gl.c_equal_files_size += e_top.Size;
                    e_cmp.Status = 4;
                    e_top.Status = 3;
                    e_top.transmitChildElements(e_cmp);
                    e_cmp.addChildElement(e_top);
                    e_top = e_cmp;
                }
            }
            long running_time = new Date().getTime() - start.getTime();
            this.gl.setProgress(i + 1, running_time);
        }
        this.gl.setProgress(0, 0L);
        return true;
    }

    private boolean isEqualTAG(MP3Element e1, MP3Element e2) {
        boolean isequaltag = true;
        boolean compare = false;
        if (this.gl.match_title && isequaltag) {
            isequaltag = this.isEqualString(e1.Title, e2.Title, this.gl.match_title_perc, this.gl.match_title_numb, this.gl.match_title_bracket);
            compare = true;
        }
        if (this.gl.match_artist && isequaltag) {
            isequaltag = this.isEqualString(e1.Artist, e2.Artist, this.gl.match_artist_perc, this.gl.match_artist_numb, this.gl.match_artist_bracket);
            compare = true;
        }
        if (this.gl.match_album && isequaltag) {
            isequaltag = this.isEqualString(e1.Album, e2.Album, this.gl.match_album_perc, this.gl.match_album_numb, this.gl.match_album_bracket);
            compare = true;
        }
        if (compare && isequaltag) {
            return true;
        }
        boolean isequalcross1 = true;
        boolean isequalcross2 = true;
        boolean crosscompare = false;
        if (this.gl.match_cross) {
            String fn1 = e1.FileName;
            String fn2 = e2.FileName;
            if (this.gl.match_title) {
                isequalcross1 = isequalcross1 && this.existsInFilename(e2.Title, fn1, this.gl.match_title_numb, this.gl.match_title_bracket);
                isequalcross2 = isequalcross2 && this.existsInFilename(e1.Title, fn2, this.gl.match_title_numb, this.gl.match_title_bracket);
                crosscompare = true;
            }
            if (this.gl.match_artist && (isequalcross1 || isequalcross2)) {
                isequalcross1 = isequalcross1 && this.existsInFilename(e2.Artist, fn1, this.gl.match_artist_numb, this.gl.match_artist_bracket);
                isequalcross2 = isequalcross2 && this.existsInFilename(e1.Artist, fn2, this.gl.match_artist_numb, this.gl.match_artist_bracket);
                crosscompare = true;
            }
            if (this.gl.match_album && (isequalcross1 || isequalcross2)) {
                isequalcross1 = isequalcross1 && this.existsInFilename(e2.Album, fn1, this.gl.match_album_numb, this.gl.match_album_bracket);
                isequalcross2 = isequalcross2 && this.existsInFilename(e1.Album, fn2, this.gl.match_album_numb, this.gl.match_album_bracket);
                crosscompare = true;
            }
        }
        return crosscompare && (isequalcross1 || isequalcross2);
    }

    private boolean isEqualFileName(String s1, String s2) {
        return this.gl.match_fn && this.isEqualString(s1, s2, this.gl.match_fn_perc, this.gl.match_fn_numb, this.gl.match_fn_bracket);
    }

    private boolean isEqualString(String s1, String s2, int percent, boolean number, boolean bracket) {
        String s_min = this.removeWrongChars(s1.trim().toLowerCase(), number, bracket);
        String s_max = this.removeWrongChars(s2.trim().toLowerCase(), number, bracket);
        if (s_min.length() == 0 && s_max.length() == 0) {
            return false;
        }
        if (s_min.length() > s_max.length()) {
            String s_tmp = s_min;
            s_min = s_max;
            s_max = s_tmp;
        }
        int len_ness = (int)Math.round((double)(s_max.length() * percent) / 100.0);
        if (s_min.length() == 30) {
            len_ness = 30;
        }
        return len_ness > 0 && len_ness <= s_min.length() && s_max.indexOf(s_min = s_min.substring(0, len_ness)) != -1;
    }

    private boolean existsInFilename(String s, String fn, boolean number, boolean bracket) {
        int p;
        s = this.removeWrongChars2(s.trim().toLowerCase(), number, bracket);
        fn = fn.trim().toLowerCase();
        if (s.length() > 0 && (p = fn.indexOf(s)) > -1) {
            char c;
            if (fn.length() > s.length() + p && ((c = fn.charAt(p + s.length())) >= 'a' && c <= 'z' || c >= '0' && c <= '9')) {
                return false;
            }
            return p - 1 < 0 || ((c = fn.charAt(p - 1)) < 'a' || c > 'z') && (c < '0' || c > '9');
        }
        return false;
    }

    private String removeWrongChars(String s, boolean numbers, boolean bracket) {
        String sr = "";
        boolean open_bracket = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '(' && !bracket) {
                open_bracket = true;
                continue;
            }
            if (c == ')' && !bracket) {
                open_bracket = false;
                continue;
            }
            if (open_bracket || !(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && (c < '0' || c > '9' || !numbers)) continue;
            sr = sr + "" + c;
        }
        return sr;
    }

    private String removeWrongChars2(String s, boolean numbers, boolean bracket) {
        String sr = "";
        boolean open_bracket = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '(' && !bracket) {
                open_bracket = true;
                continue;
            }
            if (c == ')' && !bracket) {
                open_bracket = false;
                continue;
            }
            if (open_bracket || !(c == ' ' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && (c < '0' || c > '9' || !numbers)) continue;
            sr = sr + "" + c;
        }
        return sr;
    }

    private boolean isEmptyTag(String title, String artist, String album) {
        boolean rc = false;
        if (this.gl.match_title && title.length() == 0) {
            rc = true;
        }
        if (this.gl.match_artist && artist.length() == 0) {
            rc = true;
        }
        if (this.gl.match_album && album.length() == 0) {
            rc = true;
        }
        return rc;
    }

    private static String Replace(String s, String from, String to) {
        int i = -1;
        while ((i = s.indexOf(from, i + 1)) != -1) {
            s = s.substring(0, i) + to + s.substring(i + from.length());
        }
        return s;
    }

    public void displayFileList(int status) {
        for (int i = 0; i < this.list.size(); ++i) {
            MP3Element el = (MP3Element)this.list.elementAt(i);
            if ((status <= 0 || status != el.Status) && status != 0) continue;
            this.gl.appendLine("- STATUS: " + el.Status + " / ID " + el.ID + " SIZE: " + el.Size + " FILE: " + el.absFileName + " - TITLE: " + el.Title + " - ARTIST: " + el.Artist);
        }
    }
}

