/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class MP3ListProcessor {
    GlobalData gl;
    Vector list;
    OutputStreamWriter fou;
    String PATH_SEP = System.getProperty("file.separator", "\\");
    String CRLF = System.getProperty("line.separator", "\r\n");

    MP3ListProcessor(GlobalData gl, Vector list) {
        this.gl = gl;
        this.list = list;
    }

    public boolean processList() {
        try {
            this.fou = new OutputStreamWriter((OutputStream)new FileOutputStream(this.gl.outfn), this.gl.encfiletyp);
            if (this.gl.outfmt.equalsIgnoreCase("BAT")) {
                this.writeBatchHeader();
                this.writeParams("rem");
                for (int i = 0; i < this.list.size(); ++i) {
                    if (this.gl.is_stopping) {
                        return false;
                    }
                    MP3Element el = (MP3Element)this.list.elementAt(i);
                    if (el.Status == 1) {
                        if (!this.gl.filter_notag) continue;
                        this.writeBatchNoTAG(el);
                        continue;
                    }
                    if (el.Status == 2) {
                        if (!this.gl.filter_difftag) continue;
                        this.writeBatchDifferentTAG(el);
                        continue;
                    }
                    if (el.Status != 4 || !this.gl.filter_double) continue;
                    this.writeBatchDoubleFile(el);
                }
                this.writeBatchFooter();
            } else if (this.gl.outfmt.equalsIgnoreCase("M3U")) {
                this.writeM3UHeader();
                for (int i = 0; i < this.list.size(); ++i) {
                    if (this.gl.is_stopping) {
                        return false;
                    }
                    MP3Element el = (MP3Element)this.list.elementAt(i);
                    if (el.Status == 1) {
                        if (!this.gl.filter_notag) continue;
                        this.writeM3UNoTAG(el);
                        continue;
                    }
                    if (el.Status == 2) {
                        if (!this.gl.filter_difftag) continue;
                        this.writeM3UDifferentTAG(el);
                        continue;
                    }
                    if (el.Status != 4 || !this.gl.filter_double) continue;
                    this.writeM3UDoubleFile(el);
                }
            } else if (this.gl.outfmt.equalsIgnoreCase("EXE")) {
                this.writeLogHeader();
                this.writeParams("#");
                for (int i = 0; i < this.list.size(); ++i) {
                    if (this.gl.is_stopping) {
                        return false;
                    }
                    MP3Element el = (MP3Element)this.list.elementAt(i);
                    if (el.Status == 1) {
                        if (!this.gl.filter_notag) continue;
                        this.executeM3UNoTAG(el);
                        continue;
                    }
                    if (el.Status == 2) {
                        if (!this.gl.filter_difftag) continue;
                        this.executeM3UDifferentTAG(el);
                        continue;
                    }
                    if (el.Status != 4 || !this.gl.filter_double) continue;
                    this.executeM3UDoubleFile(el);
                }
                this.writeLogFooter();
            }
            this.fou.close();
            return true;
        }
        catch (Exception e) {
            this.gl.appendLine("OUTPUT-ERROR: " + e);
            try {
                this.fou.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    private void writeParams(String comment) throws Exception {
        try {
            this.fou.write(comment + " params DOS_COPY              = " + this.gl.doscopy + this.CRLF);
            this.fou.write(comment + " params DOS_DELETE            = " + this.gl.dosdelete + this.CRLF);
            this.fou.write(comment + " params ENCODE_TAG_TYP        = " + this.gl.enctagtyp + this.CRLF);
            this.fou.write(comment + " params ENCODE_FILE_TYP       = " + this.gl.encfiletyp + this.CRLF);
            this.fou.write(comment + " params OUTPUT_TYP            = " + this.gl.outfmt + this.CRLF);
            this.fou.write(comment + " params OUTPUT_FILE           = " + this.gl.outfn + this.CRLF);
            this.fou.write(comment + " params DOUBLE_DIR            = " + this.gl.doubledir + this.CRLF);
            this.fou.write(comment + " params NO_TAG_DIR            = " + this.gl.notagdir + this.CRLF);
            this.fou.write(comment + " params DIFF_TAG_DIR          = " + this.gl.difftagdir + this.CRLF);
            this.fou.write(comment + " params FILTER_DIFF_TAG       = " + this.gl.filter_difftag + this.CRLF);
            this.fou.write(comment + " params FILTER_NO_TAG         = " + this.gl.filter_notag + this.CRLF);
            this.fou.write(comment + " params FILTER_DOUBLE         = " + this.gl.filter_double + this.CRLF);
            this.fou.write(comment + " params MATCH_TITLE           = " + this.gl.match_title + ", " + this.gl.match_title_perc + "%, Numbers " + this.gl.match_title_numb + ", Brackets " + this.gl.match_title_bracket + this.CRLF);
            this.fou.write(comment + " params MATCH_ARTIST          = " + this.gl.match_artist + ", " + this.gl.match_artist_perc + "%, Numbers " + this.gl.match_artist_numb + ", Brackets " + this.gl.match_artist_bracket + this.CRLF);
            this.fou.write(comment + " params MATCH_ALBUM           = " + this.gl.match_album + ", " + this.gl.match_album_perc + "%, Numbers " + this.gl.match_album_numb + ", Brackets " + this.gl.match_album_bracket + this.CRLF);
            this.fou.write(comment + " params MATCH_FILENAME        = " + this.gl.match_fn + ", " + this.gl.match_fn_perc + "%, Numbers " + this.gl.match_fn_numb + ", Brackets " + this.gl.match_fn_bracket + this.CRLF);
            this.fou.write(comment + " params MATCH_DIFF_TAG        = " + this.gl.filter_difftag + ", " + this.gl.match_difftag_perc + "%, Numbers " + this.gl.match_difftag_numb + ", Brackets " + this.gl.match_difftag_bracket + this.CRLF);
            this.fou.write(comment + " params MATCH_FILENAME_FORMAT = " + this.gl.match_fn_fmt + this.CRLF);
            this.fou.write(comment + " params MATCH_CROSS           = " + this.gl.match_cross + this.CRLF);
            String dir_param = "";
            for (int i = 0; i < this.gl.srcdir.size(); ++i) {
                SrcDir dir = (SrcDir)this.gl.srcdir.elementAt(i);
                if (i > 0) {
                    dir_param = dir_param + ", ";
                }
                dir_param = dir_param + dir.Dir + " / SUB: " + dir.Subdir;
            }
            this.fou.write(comment + " params SRC_DIR               = " + dir_param + this.CRLF + this.CRLF);
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeBatchHeader() {
        try {
            this.fou.write("@echo off" + this.CRLF);
            this.fou.write("echo -------------------------------------------------------------------------------" + this.CRLF);
            this.fou.write("echo  DoupleMP3Finder - Service by www.kadiba.de                                    " + this.CRLF);
            this.fou.write("echo -------------------------------------------------------------------------------" + this.CRLF);
            String sys_path = this.getSystemPath();
            if (sys_path != null && sys_path.length() > 0) {
                this.fou.write("set path=%path%;" + sys_path + "" + this.CRLF);
            }
            if (this.gl.filter_double) {
                this.fou.write("echo doppelte MP3 Dateien werden kopiert bzw. gel\u00f6scht..." + this.CRLF);
                this.fou.write("set doubletagdir=\"" + this.gl.doubledir + "\"" + this.CRLF);
                this.fou.write("if not exist \"%doubletagdir%\" md \"%doubletagdir%\"" + this.CRLF);
                this.fou.write("rem attrib \"%doubledir%\\*.*\" -r -h -s /s" + this.CRLF);
            }
            if (this.gl.filter_notag) {
                this.fou.write("set notagdir=\"" + this.gl.notagdir + "\"" + this.CRLF);
                this.fou.write("if not exist \"%notagdir%\" md \"%notagdir%\"" + this.CRLF);
                this.fou.write("rem attrib \"%notagdir%\\*.*\" -r -h -s /s" + this.CRLF);
            }
            if (this.gl.filter_difftag) {
                this.fou.write("set difftagdir=\"" + this.gl.difftagdir + "\"" + this.CRLF);
                this.fou.write("if not exist \"%difftagdir%\" md \"%difftagdir%\"" + this.CRLF);
                this.fou.write("rem attrib \"%difftagdir%\\*.*\" -r -h -s /s" + this.CRLF);
            }
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeBatchNoTAG(MP3Element e) {
        try {
            this.fou.write("rem *** NOTAG *** Kein ID3-TAG vorhanden ! Datei : " + e.absFileName + this.CRLF);
            if (this.gl.match_title) {
                this.fou.write("rem *** NOTAG *** Title  " + e.Title + this.CRLF);
            }
            if (this.gl.match_artist) {
                this.fou.write("rem *** NOTAG *** Artist " + e.Artist + this.CRLF);
            }
            if (this.gl.match_album) {
                this.fou.write("rem *** NOTAG *** Album  " + e.Album + this.CRLF);
            }
            this.fou.write("attrib \"" + e.absFileName + "\" -H -R" + this.CRLF);
            if (this.gl.doscopy && this.gl.dosdelete) {
                this.fou.write("move \"" + e.absFileName + "\" \"" + this.gl.notagdir + "\" > nul" + this.CRLF);
            } else {
                if (this.gl.doscopy) {
                    this.fou.write("copy \"" + e.absFileName + "\" \"" + this.gl.notagdir + "\" > nul" + this.CRLF);
                }
                if (this.gl.dosdelete) {
                    this.fou.write("del \"" + e.absFileName + "\" > nul" + this.CRLF);
                }
            }
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeBatchDoubleFile(MP3Element e1) {
        try {
            this.fou.write("rem *** BEST *** Datei  1 " + e1.absFileName + " [" + e1.Size / 1024L + " KByte]" + this.CRLF);
            if (this.gl.match_title) {
                this.fou.write("rem *** BEST *** Title  1 " + e1.Title + this.CRLF);
            }
            if (this.gl.match_artist) {
                this.fou.write("rem *** BEST *** Artist 1 " + e1.Artist + this.CRLF);
            }
            if (this.gl.match_album) {
                this.fou.write("rem *** BEST *** Album  1 " + e1.Album + this.CRLF);
            }
            if (this.gl.m3udouble) {
                this.fou.write("attrib \"" + e1.absFileName + "\" -H -R" + this.CRLF);
                if (this.gl.doscopy && this.gl.dosdelete) {
                    this.fou.write("move \"" + e1.absFileName + "\" \"" + this.gl.doubledir + "\" > nul" + this.CRLF);
                } else {
                    if (this.gl.doscopy) {
                        this.fou.write("copy \"" + e1.absFileName + "\" \"" + this.gl.doubledir + "\" > nul" + this.CRLF);
                    }
                    if (this.gl.dosdelete) {
                        this.fou.write("del \"" + e1.absFileName + "\" > nul" + this.CRLF);
                    }
                }
            }
            Vector list = e1.getChilds();
            for (int i = 0; i < list.size(); ++i) {
                MP3Element e2 = (MP3Element)list.elementAt(i);
                this.fou.write("rem *** BAD ***  Datei " + (i + 2) + " " + e2.absFileName + " [" + e2.Size / 1024L + " KByte]" + this.CRLF);
                if (this.gl.match_title) {
                    this.fou.write("rem *** BAD ***  Title  " + (i + 2) + " " + e2.Title + this.CRLF);
                }
                if (this.gl.match_artist) {
                    this.fou.write("rem *** BAD ***  Artist " + (i + 2) + " " + e2.Artist + this.CRLF);
                }
                if (this.gl.match_album) {
                    this.fou.write("rem *** BAD ***  Album  " + (i + 2) + " " + e2.Album + this.CRLF);
                }
                this.fou.write("attrib \"" + e2.absFileName + "\" -H -R" + this.CRLF);
                if (this.gl.doscopy && this.gl.dosdelete) {
                    this.fou.write("move \"" + e2.absFileName + "\" \"" + this.gl.doubledir + "\" > nul" + this.CRLF);
                    continue;
                }
                if (this.gl.doscopy) {
                    this.fou.write("copy \"" + e2.absFileName + "\" \"" + this.gl.doubledir + "\" > nul" + this.CRLF);
                }
                if (!this.gl.dosdelete) continue;
                this.fou.write("del \"" + e2.absFileName + "\" > nul" + this.CRLF);
            }
            this.fou.write("" + this.CRLF);
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeBatchDifferentTAG(MP3Element e) {
        try {
            this.fou.write("rem *** DIFF *** TAG-Info weicht vom Dateinamen ab! Datei : '" + e.absFileName + this.CRLF);
            this.fou.write("rem *** DIFF *** Title  " + e.Title + this.CRLF);
            this.fou.write("rem *** DIFF *** Artist " + e.Artist + this.CRLF);
            this.fou.write("rem *** DIFF *** Album  " + e.Album + this.CRLF);
            this.fou.write("attrib \"" + e.absFileName + "\" -H -R" + this.CRLF);
            if (this.gl.doscopy && this.gl.dosdelete) {
                this.fou.write("move \"" + e.absFileName + "\" \"" + this.gl.difftagdir + "\" > nul" + this.CRLF);
            } else {
                if (this.gl.doscopy) {
                    this.fou.write("copy \"" + e.absFileName + "\" \"" + this.gl.difftagdir + "\" > nul" + this.CRLF);
                }
                if (this.gl.dosdelete) {
                    this.fou.write("del \"" + e.absFileName + "\" > nul" + this.CRLF);
                }
            }
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeBatchFooter() {
        try {
            this.fou.write("" + this.CRLF);
            this.fou.write("echo Anzahl aller Dateien:    " + this.gl.c_all_files + this.CRLF);
            this.fou.write("echo Anzahl Dateien ohne TAG: " + this.gl.c_notag_files + this.CRLF);
            this.fou.write("echo Anzahl Dateien diff TAG: " + this.gl.c_difftag_files + this.CRLF);
            this.fou.write("echo Anzahl gleicher Dateien: " + this.gl.c_equal_files + this.CRLF);
            this.fou.write("echo Speicherplatz:           " + this.gl.c_equal_files_size / 1024L / 1024L + " MB" + this.CRLF);
            this.fou.write("" + this.CRLF);
            if (this.gl.filter_double) {
                this.fou.write("set doubletagdir=" + this.CRLF);
            }
            if (this.gl.filter_notag) {
                this.fou.write("set notagdir=" + this.CRLF);
            }
            if (this.gl.filter_difftag) {
                this.fou.write("set difftagdir=" + this.CRLF);
            }
            this.fou.write("echo kopieren beendet!" + this.CRLF);
            this.fou.write("echo on" + this.CRLF);
            this.fou.write("@pause" + this.CRLF);
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeM3UHeader() {
        try {
            this.fou.write("#EXTM3U" + this.CRLF);
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeM3UNoTAG(MP3Element e) {
        try {
            this.fou.write("#EXTINF:  *** NOTAG *** " + this.CRLF + e.absFileName + this.CRLF);
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeM3UDoubleFile(MP3Element e1) {
        try {
            if (this.gl.m3udouble) {
                this.fou.write("#EXTINF: " + e1.Artist + " - " + e1.Title + " *** BEST *** " + this.CRLF + e1.absFileName + this.CRLF);
            }
            Vector list = e1.getChilds();
            for (int i = 0; i < list.size(); ++i) {
                MP3Element e2 = (MP3Element)list.elementAt(i);
                this.fou.write("#EXTINF: " + e2.Artist + " - " + e2.Title + " *** BAD *** " + this.CRLF + e2.absFileName + this.CRLF);
            }
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeM3UDifferentTAG(MP3Element e) {
        try {
            this.fou.write("#EXTINF: " + e.Artist + " - " + e.Title + " *** DIFF *** " + this.CRLF + e.absFileName + this.CRLF);
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    public void writeLogHeader() {
        try {
            this.fou.write("" + this.CRLF);
            this.fou.write("# -------------------------------------------------------------------------------" + this.CRLF);
            this.fou.write("#  DoupleMP3Finder - Logdatei - Service by www.kadiba.de                         " + this.CRLF);
            this.fou.write("# -------------------------------------------------------------------------------" + this.CRLF);
            this.fou.write("#" + this.CRLF);
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void executeM3UNoTAG(MP3Element e) {
        try {
            File dir = new File(this.gl.notagdir);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (this.gl.doscopy && this.gl.dosdelete) {
                this.fou.write("# NO-TAG-MOVE   : " + e.absFileName + "  >> NACH >>  " + this.gl.notagdir + this.PATH_SEP + e.FileName + this.CRLF);
                this.moveFile(e.absFileName, this.gl.notagdir + this.PATH_SEP + e.FileName);
            } else {
                if (this.gl.doscopy) {
                    this.fou.write("# NO-TAG-COPY   : " + e.absFileName + "  >> NACH >>  " + this.gl.notagdir + this.PATH_SEP + e.FileName + this.CRLF);
                    this.copyFile(e.absFileName, this.gl.notagdir + this.PATH_SEP + e.FileName);
                }
                if (this.gl.dosdelete) {
                    this.fou.write("# NO-TAG-DELETE : " + e.absFileName + this.CRLF);
                    this.deleteFile(e.absFileName);
                }
            }
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void executeM3UDoubleFile(MP3Element e) {
        try {
            File dir = new File(this.gl.doubledir);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (this.gl.m3udouble) {
                if (this.gl.doscopy && this.gl.dosdelete) {
                    this.fou.write("# DOUBLE-MOVE   : " + e.absFileName + "  >> NACH >>  " + this.gl.doubledir + this.PATH_SEP + e.FileName + this.CRLF);
                    this.moveFile(e.absFileName, this.gl.doubledir + this.PATH_SEP + e.FileName);
                } else {
                    if (this.gl.doscopy) {
                        this.fou.write("# DOUBLE-COPY   : " + e.absFileName + "  >> NACH >>  " + this.gl.doubledir + this.PATH_SEP + e.FileName + this.CRLF);
                        this.copyFile(e.absFileName, this.gl.doubledir + this.PATH_SEP + e.FileName);
                    }
                    if (this.gl.dosdelete) {
                        this.fou.write("# DOUBLE-DELETE : " + e.absFileName + this.CRLF);
                        this.deleteFile(e.absFileName);
                    }
                }
            }
            Vector list = e.getChilds();
            for (int i = 0; i < list.size(); ++i) {
                MP3Element e2 = (MP3Element)list.elementAt(i);
                if (this.gl.doscopy && this.gl.dosdelete) {
                    this.fou.write("# DOUBLE-MOVE   : " + e2.absFileName + "  >> NACH >>  " + this.gl.doubledir + this.PATH_SEP + e2.FileName + this.CRLF);
                    this.moveFile(e2.absFileName, this.gl.doubledir + this.PATH_SEP + e2.FileName);
                    continue;
                }
                if (this.gl.doscopy) {
                    this.fou.write("# DOUBLE-COPY   : " + e2.absFileName + "  >> NACH >>  " + this.gl.doubledir + this.PATH_SEP + e2.FileName + this.CRLF);
                    this.copyFile(e2.absFileName, this.gl.doubledir + this.PATH_SEP + e2.FileName);
                }
                if (!this.gl.dosdelete) continue;
                this.fou.write("# DOUBLE-DELETE : " + e2.absFileName + this.CRLF);
                this.deleteFile(e2.absFileName);
            }
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void executeM3UDifferentTAG(MP3Element e) {
        try {
            File dir = new File(this.gl.difftagdir);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (this.gl.doscopy && this.gl.dosdelete) {
                this.fou.write("# DIFF-MOVE   : " + e.absFileName + "  >> NACH >>  " + this.gl.doubledir + this.PATH_SEP + e.FileName + this.CRLF);
                this.moveFile(e.absFileName, this.gl.difftagdir + this.PATH_SEP + e.FileName);
            } else {
                if (this.gl.doscopy) {
                    this.fou.write("# DIFF-COPY   : " + e.absFileName + "  >> NACH >>  " + this.gl.doubledir + this.PATH_SEP + e.FileName + this.CRLF);
                    this.copyFile(e.absFileName, this.gl.difftagdir + this.PATH_SEP + e.FileName);
                }
                if (this.gl.dosdelete) {
                    this.fou.write("# DIFF-DELETE : " + e.absFileName + this.CRLF);
                    this.deleteFile(e.absFileName);
                }
            }
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private void writeLogFooter() {
        try {
            this.fou.write("" + this.CRLF);
            this.fou.write("# Anzahl aller Dateien:    " + this.gl.c_all_files + this.CRLF);
            this.fou.write("# Anzahl Dateien ohne TAG: " + this.gl.c_notag_files + this.CRLF);
            this.fou.write("# Anzahl Dateien diff TAG: " + this.gl.c_difftag_files + this.CRLF);
            this.fou.write("# Anzahl gleicher Dateien: " + this.gl.c_equal_files + this.CRLF);
            this.fou.write("# Speicherplatz:           " + this.gl.c_equal_files_size / 1024L / 1024L + " MB" + this.CRLF);
        }
        catch (Exception ex) {
            this.gl.appendLine("OUTPUT-ERROR: " + ex);
        }
    }

    private String getSystemPath() {
        String sys_name = System.getProperty("os.name").toLowerCase();
        String dir = null;
        if (!(sys_name.indexOf("windows") == -1 || this.gl.existDir(dir = "c:\\windows\\system32") || this.gl.existDir(dir = "d:\\windows\\system32") || this.gl.existDir(dir = "e:\\windows\\system32") || this.gl.existDir(dir = "f:\\windows\\system32"))) {
            dir = null;
        }
        return dir;
    }

    private void copyFile(String fn_src, String fn_des) throws Exception {
        int len;
        File f = new File(fn_des);
        FileInputStream in = new FileInputStream(fn_src);
        FileOutputStream out = new FileOutputStream(f.getAbsoluteFile());
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
        in.close();
    }

    private void moveFile(String fn_src, String fn_des) throws Exception {
        File f = new File(fn_src);
        File f2 = new File(fn_des);
        f.renameTo(f2);
    }

    private void deleteFile(String fn) throws Exception {
        File f = new File(fn);
        f.delete();
    }
}

