/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info;

import de.ueberdosis.mp3info.Defines;
import de.ueberdosis.mp3info.ExtendedID3Tag;
import de.ueberdosis.mp3info.ID3Tag;
import de.ueberdosis.mp3info.ID3TagException;
import de.ueberdosis.mp3info.ID3V2Exception;
import de.ueberdosis.mp3info.UndersizedException;
import de.ueberdosis.mp3info.facades.Wamp;
import de.ueberdosis.mp3info.id3v2.ID3V2Reader;
import de.ueberdosis.mp3info.id3v2.ID3V2Tag;
import de.ueberdosis.util.OutputCtr;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3Reader
implements Defines {
    protected ExtendedID3Tag xtag;
    protected static ID3V2Tag v2tag = null;

    public static ID3Tag readTag(RandomAccessFile randomAccessFile) throws IOException {
        ID3Tag iD3Tag = null;
        if (randomAccessFile.length() > 128L) {
            randomAccessFile.seek(randomAccessFile.length() - 128L);
            byte[] byArray = new byte[128];
            randomAccessFile.read(byArray);
            iD3Tag = new ID3Tag(byArray);
            return iD3Tag;
        }
        return null;
    }

    public static ExtendedID3Tag readExtendedTag(RandomAccessFile randomAccessFile) throws IOException {
        v2tag = null;
        if (randomAccessFile.length() < 128L) {
            return null;
        }
        ExtendedID3Tag extendedID3Tag = new ExtendedID3Tag(ID3Reader.readTag(randomAccessFile));
        ExtendedID3Tag extendedID3Tag2 = new ExtendedID3Tag(extendedID3Tag);
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        for (long i = 0L; !bl && i < randomAccessFile.length() - 10L; ++i) {
            try {
                i = ID3Reader.findNextHeader(randomAccessFile, i);
                byte[] byArray = ID3Reader.getFrameHeader(i, randomAccessFile);
                bl = ID3Reader.parseExtendedInto(byArray, extendedID3Tag, i);
                extendedID3Tag.setSize(randomAccessFile.length());
                extendedID3Tag.setPosition(i);
                continue;
            }
            catch (ID3V2Exception iD3V2Exception) {
                OutputCtr.println(6, iD3V2Exception);
                ID3V2Reader iD3V2Reader = new ID3V2Reader(randomAccessFile, iD3V2Exception.getPosition());
                v2tag = iD3V2Reader.getV2Tag();
                l2 = l = v2tag.getSize();
                OutputCtr.println(3, v2tag);
                OutputCtr.println(2, "Skipping " + l + " bytes.");
                i = iD3V2Exception.getPosition() + l;
                continue;
            }
            catch (ID3TagException iD3TagException) {
                OutputCtr.println(6, iD3TagException);
                i = iD3TagException.getPosition() + 128L;
                continue;
            }
            catch (UndersizedException undersizedException) {
                OutputCtr.println(0, undersizedException);
            }
        }
        if (bl) {
            extendedID3Tag.setID3v2Size(l2);
            return extendedID3Tag;
        }
        return extendedID3Tag2;
    }

    private static byte[] getFrameHeader(long l, RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[10];
        randomAccessFile.seek(l);
        randomAccessFile.read(byArray);
        return byArray;
    }

    private static int getFramesize(ExtendedID3Tag extendedID3Tag) {
        int n = 0;
        if (extendedID3Tag.getFrequencyI() > 1) {
            int n2 = extendedID3Tag.getPadding() ? 1 : 0;
            switch (extendedID3Tag.getLayer()) {
                case 3: {
                    n = (12 * extendedID3Tag.getBitrateI() * 1000 / extendedID3Tag.getFrequencyI() + n2) * 4;
                }
            }
            n = 144 * extendedID3Tag.getBitrateI() * 1000 / extendedID3Tag.getFrequencyI() + n2;
        }
        return n;
    }

    private static boolean checkFrameHeader(byte[] byArray, long l) throws UndersizedException, ID3TagException, ID3V2Exception {
        if (byArray.length < 4) {
            throw new UndersizedException(byArray.length, 4);
        }
        if (new String(byArray, 0, 3).equals("ID3")) {
            ID3V2Exception iD3V2Exception = new ID3V2Exception("Encountered an ID3v2Tag.");
            iD3V2Exception.setPosition(l);
            throw iD3V2Exception;
        }
        if (new String(byArray, 0, 3).equals("TAG")) {
            ID3TagException iD3TagException = new ID3TagException("Encountered an ID3Tag.");
            iD3TagException.setPosition(l);
            throw iD3TagException;
        }
        byte by = byArray[0];
        byte by2 = byArray[1];
        return by == -1 && by2 >>> 4 >= 14;
    }

    private static boolean parseExtendedInto(byte[] byArray, ExtendedID3Tag extendedID3Tag, long l) throws ID3V2Exception, ID3TagException, UndersizedException {
        if (ID3Reader.checkFrameHeader(byArray, l)) {
            byte by = byArray[1];
            byte by2 = byArray[2];
            byte by3 = byArray[3];
            extendedID3Tag.setMpegID((by & 0x30) >>> 4);
            extendedID3Tag.setLayer((by & 6) >>> 1);
            extendedID3Tag.setCrc((by & 1) == 0);
            extendedID3Tag.setBitrate((by2 & 0xF0) >>> 4);
            extendedID3Tag.setFrequency((by2 & 0xC) >>> 2);
            extendedID3Tag.setPadding((by2 & 2) >>> 1 == 1);
            extendedID3Tag.setChannelMode((by3 & 0xC0) >>> 6);
            extendedID3Tag.setCopyright((by3 & 8) != 0);
            extendedID3Tag.setOriginal((by3 & 4) != 0);
            extendedID3Tag.setEmphasis(by3 & 3);
            return ID3Reader.checkTag(extendedID3Tag);
        }
        return false;
    }

    public ExtendedID3Tag getExtendedID3Tag() {
        return this.xtag;
    }

    public static ID3V2Tag getV2Tag() {
        return v2tag;
    }

    public ID3Reader(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        if (randomAccessFile.length() > 128L) {
            this.xtag = ID3Reader.readExtendedTag(randomAccessFile);
            if (this.checkVBR(randomAccessFile)) {
                this.checkAllFrames(randomAccessFile);
            }
        }
        randomAccessFile.close();
    }

    public boolean checkVBR(RandomAccessFile randomAccessFile) throws IOException {
        long l = this.xtag.getPosition();
        long l2 = 0L;
        int n = 0;
        boolean bl = false;
        OutputCtr.println(2, "Entering checkVBR. Don't worry about all those 'gibberish' messages!\n");
        for (int i = 0; i < Defines.testPositions.length && l + Defines.testPositions[i] < randomAccessFile.length(); ++i) {
            try {
                l2 = ID3Reader.findNextHeader(randomAccessFile, l + Defines.testPositions[i]);
                byte[] byArray = ID3Reader.getFrameHeader(l2, randomAccessFile);
                ExtendedID3Tag extendedID3Tag = new ExtendedID3Tag();
                ID3Reader.parseExtendedInto(byArray, extendedID3Tag, l2);
                if (extendedID3Tag.getBitrateI() <= 0 || extendedID3Tag.getFrequencyI() <= 0) continue;
                if (n <= 0) {
                    n = extendedID3Tag.getBitrateI();
                }
                if (!ID3Reader.checkTag(extendedID3Tag) || n == extendedID3Tag.getBitrateI()) continue;
                OutputCtr.println(2, "Got different bitrates! at " + l2 + "|" + Long.toHexString(l2) + " (" + n + ", " + extendedID3Tag.getBitrateI() + ")");
                OutputCtr.println(2, "The Tag at this point is:");
                OutputCtr.println(2, extendedID3Tag);
                bl = true;
                break;
            }
            catch (ID3V2Exception iD3V2Exception) {
                OutputCtr.println(6, iD3V2Exception);
                ID3V2Reader iD3V2Reader = new ID3V2Reader(randomAccessFile, iD3V2Exception.getPosition());
                v2tag = iD3V2Reader.getV2Tag();
                OutputCtr.println(3, v2tag);
                l = v2tag.getSize();
                OutputCtr.println(2, "skipping " + l + " bytest.");
                l += this.xtag.getPosition();
                --i;
                continue;
            }
            catch (ID3TagException iD3TagException) {
                OutputCtr.println(2, iD3TagException);
                continue;
            }
            catch (UndersizedException undersizedException) {
                OutputCtr.println(0, undersizedException);
            }
        }
        OutputCtr.println(2, "Leaving checkVBR.");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllFrames(RandomAccessFile randomAccessFile) throws IOException {
        long l;
        int n = 0;
        long l2 = 0L;
        long l3 = l = this.xtag.getPosition();
        ExtendedID3Tag extendedID3Tag = this.xtag;
        byte[] byArray = null;
        int n2 = 0;
        long l4 = randomAccessFile.length() - 11L;
        boolean bl = false;
        boolean bl2 = false;
        OutputCtr.println(2, "Entering checkAllFrames.");
        while (!bl && !bl2) {
            if (l3 >= l4) {
                bl = true;
            } else {
                int n3 = ID3Reader.getFramesize(extendedID3Tag);
                if (n3 > 1) {
                    ++n;
                    n2 = extendedID3Tag.getBitrateI();
                    if (n2 != 0) {
                        l2 += (long)(n3 * 8 / n2);
                        this.xtag.updateBitrates(extendedID3Tag);
                    } else {
                        OutputCtr.println(2, "bitrate was 0 at position " + l + " !");
                    }
                    l3 = l + (long)n3;
                } else {
                    ++l3;
                }
            }
            if (l3 >= l4) {
                bl = true;
                continue;
            }
            try {
                l3 = ID3Reader.findNextHeader(randomAccessFile, l3);
                byArray = ID3Reader.getFrameHeader(l3, randomAccessFile);
                extendedID3Tag = new ExtendedID3Tag(extendedID3Tag);
                ID3Reader.parseExtendedInto(byArray, extendedID3Tag, l3);
            }
            catch (ID3V2Exception iD3V2Exception) {
                OutputCtr.println(6, iD3V2Exception);
                ID3V2Reader iD3V2Reader = new ID3V2Reader(randomAccessFile, iD3V2Exception.getPosition());
                ID3V2Tag iD3V2Tag = iD3V2Reader.getV2Tag();
                OutputCtr.println(2, iD3V2Tag);
                long l5 = iD3V2Tag.getSize();
                OutputCtr.println(2, "skipping " + l5 + " bytes at " + iD3V2Exception.getPosition() + ".");
                l3 = iD3V2Exception.getPosition() + l5;
                OutputCtr.println(4, "newPosition = " + l3);
            }
            catch (ID3TagException iD3TagException) {
                OutputCtr.println(2, iD3TagException);
                OutputCtr.println(3, "Still in while...");
                bl = true;
            }
            catch (UndersizedException undersizedException) {
                OutputCtr.println(0, undersizedException);
            }
            finally {
                l = l3;
            }
        }
        if (bl) {
            this.xtag.setKRuntime(l2);
            this.xtag.setFramecount(n);
        } else {
            OutputCtr.println(3, "Did not find a header at " + l3);
            OutputCtr.println(3, "Size is " + l4 + ".\nDifference therefore:" + (l4 - l3));
            if (l3 > l4 - 129L) {
                this.xtag.setKRuntime(l2);
                this.xtag.setFramecount(n);
            }
            OutputCtr.println(3, "");
        }
        OutputCtr.println(1, "FrameCount: " + n);
        OutputCtr.println(1, "PlayTime: " + l2);
    }

    private static long findNextHeader(RandomAccessFile randomAccessFile, long l) throws IOException, ID3V2Exception, ID3TagException, UndersizedException {
        long l2 = l;
        byte[] byArray = new byte[10];
        boolean bl = false;
        int n = 65536;
        byte[] byArray2 = new byte[n];
        long l3 = -n;
        long l4 = randomAccessFile.length();
        while (l2 < l4 - 10L && !bl) {
            if (l3 + (long)n <= l2 + 10L) {
                try {
                    l3 = l2;
                    randomAccessFile.seek(l3);
                    randomAccessFile.read(byArray2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            System.arraycopy(byArray2, (int)(l2 - l3), byArray, 0, 10);
            bl = ID3Reader.checkFrameHeader(byArray, l2);
            if (bl) continue;
            ++l2;
        }
        if (l2 > l) {
            OutputCtr.println(3, "Skipped " + (l2 - l) + " bytes of gibberish (" + l + " - " + l2 + " | " + Long.toHexString(l) + " - " + Long.toHexString(l2) + ")");
        }
        return l2;
    }

    public static void main(String[] stringArray) {
        OutputCtr.println(0, "Mp3 Id (mp3info V1.6.0d9) and bitrate reader.\nMilon Krejca <milon@iname.com>, Florian Heer <heer@ueberdosis.de>(c) 2001-2002");
        if (stringArray.length != 1) {
            OutputCtr.println(0, "Usage: ID3Reader <filename>");
        } else {
            OutputCtr.setLevel(0);
            try {
                ID3Reader iD3Reader = new ID3Reader(stringArray[0]);
                if (ID3Reader.getV2Tag() != null) {
                    OutputCtr.println(0, "\nV2 tag:");
                    OutputCtr.println(0, new Wamp(ID3Reader.getV2Tag()));
                }
                OutputCtr.println(0, iD3Reader.getExtendedID3Tag());
            }
            catch (IOException iOException) {
                OutputCtr.println(0, iOException);
            }
        }
    }

    private static boolean checkTag(ExtendedID3Tag extendedID3Tag) {
        if (extendedID3Tag.getMpegID() < 0 || extendedID3Tag.getMpegID() > 3 || extendedID3Tag.getMpegID() == 1) {
            OutputCtr.println(2, "MpegID was the illegal " + extendedID3Tag.getMpegID() + "!");
            return false;
        }
        if (extendedID3Tag.getLayer() < 1 || extendedID3Tag.getLayer() > 3) {
            OutputCtr.println(2, "Layer was the illegal " + extendedID3Tag.getLayer() + "!");
            return false;
        }
        if (extendedID3Tag.getBitrateI() < 8 || extendedID3Tag.getBitrateI() > 448) {
            OutputCtr.println(2, "Bitrate was the illegal " + extendedID3Tag.getBitrateI() + "!");
            return false;
        }
        if (extendedID3Tag.getFrequencyI() < 8000 || extendedID3Tag.getFrequencyI() > 48000) {
            OutputCtr.println(2, "Frequency was the illegal " + extendedID3Tag.getFrequencyI() + "!");
            return false;
        }
        if (extendedID3Tag.getChannelMode() < 0 || extendedID3Tag.getChannelMode() > 3) {
            OutputCtr.println(2, "Channelmode was the illegal " + extendedID3Tag.getChannelMode() + "!");
            return false;
        }
        if (extendedID3Tag.getEmphasis() < 0 || extendedID3Tag.getEmphasis() > 3) {
            OutputCtr.println(2, "Emphasis was the illegal " + extendedID3Tag.getEmphasis() + "!");
            return false;
        }
        return true;
    }
}

