/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.facades;

import de.ueberdosis.mp3info.ID3Tag;
import de.ueberdosis.mp3info.id3v2.FrameCOMM;
import de.ueberdosis.mp3info.id3v2.FrameTALB;
import de.ueberdosis.mp3info.id3v2.FrameTCOM;
import de.ueberdosis.mp3info.id3v2.FrameTCON;
import de.ueberdosis.mp3info.id3v2.FrameTCOP;
import de.ueberdosis.mp3info.id3v2.FrameTENC;
import de.ueberdosis.mp3info.id3v2.FrameTIT2;
import de.ueberdosis.mp3info.id3v2.FrameTOPE;
import de.ueberdosis.mp3info.id3v2.FrameTPE1;
import de.ueberdosis.mp3info.id3v2.FrameTRCK;
import de.ueberdosis.mp3info.id3v2.FrameTYER;
import de.ueberdosis.mp3info.id3v2.FrameWXXX;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.ID3V2Tag;
import java.util.Enumeration;

public class Wamp {
    private ID3V2Tag tag = null;
    private FrameTRCK trck = null;
    private FrameTENC tenc = null;
    private FrameWXXX wxxx = null;
    private FrameTCOP tcop = null;
    private FrameTOPE tope = null;
    private FrameTCOM tcom = null;
    private FrameCOMM comm = null;
    private FrameTYER tyer = null;
    private FrameTCON tcon = null;
    private FrameTALB talb = null;
    private FrameTPE1 tpe1 = null;
    private FrameTIT2 tit2 = null;

    public Wamp() {
        this.tag = new ID3V2Tag();
        this.trck = new FrameTRCK();
        this.tenc = new FrameTENC();
        this.wxxx = new FrameWXXX();
        this.tcop = new FrameTCOP();
        this.tope = new FrameTOPE();
        this.tcom = new FrameTCOM();
        this.comm = new FrameCOMM();
        this.tyer = new FrameTYER();
        this.tcon = new FrameTCON();
        this.talb = new FrameTALB();
        this.tpe1 = new FrameTPE1();
        this.tit2 = new FrameTIT2();
        this.tag.addFrame(this.trck);
        this.tag.addFrame(this.tenc);
        this.tag.addFrame(this.wxxx);
        this.tag.addFrame(this.tcop);
        this.tag.addFrame(this.tope);
        this.tag.addFrame(this.tcom);
        this.tag.addFrame(this.comm);
        this.tag.addFrame(this.tyer);
        this.tag.addFrame(this.tcon);
        this.tag.addFrame(this.talb);
        this.tag.addFrame(this.tpe1);
        this.tag.addFrame(this.tit2);
    }

    public Wamp(ID3Tag iD3Tag) {
        this();
        this.trck.setText("" + iD3Tag.getTrack());
        this.tyer.setText(iD3Tag.getYear());
        this.tcon.setText("(" + iD3Tag.getGenre() + ")" + iD3Tag.getGenreS());
        this.talb.setText(iD3Tag.getAlbum());
        this.tpe1.setText(iD3Tag.getArtist());
        this.tit2.setText(iD3Tag.getTitle());
        this.comm.setText(iD3Tag.getComment());
    }

    public Wamp(ID3V2Tag iD3V2Tag) {
        this.tag = new ID3V2Tag(iD3V2Tag);
        Enumeration enumeration = this.tag.getFrames().elements();
        while (enumeration.hasMoreElements()) {
            ID3V2Frame iD3V2Frame = (ID3V2Frame)enumeration.nextElement();
            if (iD3V2Frame.getFrameID().equals("TRCK")) {
                this.trck = (FrameTRCK)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("TENC")) {
                this.tenc = (FrameTENC)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("WXXX")) {
                this.wxxx = (FrameWXXX)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("TCOP")) {
                this.tcop = (FrameTCOP)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("TOPE")) {
                this.tope = (FrameTOPE)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("TCOM")) {
                this.tcom = (FrameTCOM)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("COMM")) {
                this.comm = (FrameCOMM)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("TYER")) {
                this.tyer = (FrameTYER)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("TCON")) {
                this.tcon = (FrameTCON)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("TALB")) {
                this.talb = (FrameTALB)iD3V2Frame;
                continue;
            }
            if (iD3V2Frame.getFrameID().equals("TPE1")) {
                this.tpe1 = (FrameTPE1)iD3V2Frame;
                continue;
            }
            if (!iD3V2Frame.getFrameID().equals("TIT2")) continue;
            this.tit2 = (FrameTIT2)iD3V2Frame;
        }
    }

    public ID3V2Tag getV2Tag() {
        return this.tag;
    }

    public ID3Tag getV1Tag() {
        ID3Tag iD3Tag = new ID3Tag();
        iD3Tag.setTrack(this.getTrack());
        iD3Tag.setYear(this.getYear());
        iD3Tag.setGenre(this.getGenre());
        iD3Tag.setAlbum(this.getAlbum());
        iD3Tag.setArtist(this.getArtist());
        iD3Tag.setTitle(this.getTitle());
        iD3Tag.setComment(this.getComment());
        return iD3Tag;
    }

    public String getTitle() {
        if (this.tit2 != null) {
            return this.tit2.getText();
        }
        return "";
    }

    public void setTitle(String string) {
        if (this.tit2 == null) {
            this.tit2 = new FrameTIT2();
            this.tag.addFrame(this.tit2);
        }
        this.tit2.setText(string);
    }

    public String getArtist() {
        if (this.tpe1 != null) {
            return this.tpe1.getText();
        }
        return "";
    }

    public void setArtist(String string) {
        if (this.tpe1 == null) {
            this.tpe1 = new FrameTPE1();
            this.tag.addFrame(this.tpe1);
        }
        this.tpe1.setText(string);
    }

    public String getAlbum() {
        if (this.talb != null) {
            return this.talb.getText();
        }
        return "";
    }

    public void setAlbum(String string) {
        if (this.talb == null) {
            this.talb = new FrameTALB();
            this.tag.addFrame(this.talb);
        }
        this.talb.setText(string);
    }

    public String getYear() {
        if (this.tyer != null) {
            return this.tyer.getText();
        }
        return "";
    }

    public void setYear(String string) {
        if (this.tyer == null) {
            this.tyer = new FrameTYER();
            this.tag.addFrame(this.tyer);
        }
        this.tyer.setText(string);
    }

    public String getComment() {
        if (this.comm != null) {
            return this.comm.getText();
        }
        return "";
    }

    public void setComment(String string) {
        if (this.comm == null) {
            this.comm = new FrameCOMM();
            this.tag.addFrame(this.comm);
        }
        this.comm.setText(string);
    }

    public byte getGenre() {
        String string = this.getGenreS();
        byte by = -1;
        if (!string.equals("")) {
            if (string.startsWith("(")) {
                by = Byte.parseByte(string.substring(1, string.indexOf(")")));
            } else {
                for (int i = 0; i < ID3Tag.genres.length; ++i) {
                    if (!ID3Tag.genres[i].equalsIgnoreCase(string)) continue;
                    by = (byte)i;
                    break;
                }
            }
        }
        return by;
    }

    public String getGenreS() {
        if (this.tcon != null) {
            return this.tcon.getText();
        }
        return "";
    }

    public void setGenre(byte by) {
        if (by >= 0 && by < 126) {
            this.setGenre("(" + by + ")" + ID3Tag.genres[by]);
        } else {
            this.setGenre("");
        }
    }

    public void setGenre(int n) {
        this.setGenre((byte)n);
    }

    public void setGenre(String string) {
        if (this.tcon == null) {
            this.tcon = new FrameTCON();
            this.tag.addFrame(this.tcon);
        }
        this.tcon.setText(string);
    }

    public byte getTrack() {
        if (this.trck != null) {
            return (byte)Integer.parseInt(this.trck.getText());
        }
        return 0;
    }

    public String getTrackS() {
        if (this.trck != null) {
            return this.trck.getText();
        }
        return "0";
    }

    public void setTrack(byte by) {
        this.setTrack((int)by);
    }

    public void setTrack(int n) {
        this.setTrack("" + n);
    }

    public void setTrack(String string) {
        if (this.trck == null) {
            this.trck = new FrameTRCK();
            this.tag.addFrame(this.trck);
        }
        this.trck.setText(string);
    }

    public void setComposer(String string) {
        if (this.tcom == null) {
            this.tcom = new FrameTCOM();
            this.tag.addFrame(this.tcom);
        }
        this.tcom.setText(string);
    }

    public String getComposer() {
        if (this.tcom != null) {
            return this.tcom.getText();
        }
        return "";
    }

    public void setOriginalArtist(String string) {
        if (this.tope == null) {
            this.tope = new FrameTOPE();
            this.tag.addFrame(this.tope);
        }
        this.tope.setText(string);
    }

    public String getOriginalArtist() {
        if (this.tope != null) {
            return this.tope.getText();
        }
        return "";
    }

    public void setCopyright(String string) {
        if (this.tcop == null) {
            this.tcop = new FrameTCOP();
            this.tag.addFrame(this.tcop);
        }
        this.tcop.setText(string);
    }

    public String getCopyright() {
        if (this.tcop != null) {
            return this.tcop.getText();
        }
        return "";
    }

    public void setURL(String string) {
        if (this.wxxx == null) {
            this.wxxx = new FrameWXXX();
            this.tag.addFrame(this.wxxx);
        }
        this.wxxx.setValue(string);
    }

    public String getURL() {
        if (this.wxxx != null) {
            return this.wxxx.getValue();
        }
        return "";
    }

    public void setEncodedBy(String string) {
        if (this.tenc == null) {
            this.tenc = new FrameTENC();
            this.tag.addFrame(this.tenc);
        }
        this.tenc.setText(string);
    }

    public String getEncodedBy() {
        if (this.tenc != null) {
            return this.tenc.getText();
        }
        return "";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Title:        ").append(this.getTitle()).append("\nArtist:       ").append(this.getArtist()).append("\nAlbum:        ").append(this.getAlbum()).append("\nYear:         ").append(this.getYear()).append("\nGenre:        ").append(this.getGenreS()).append("\nComment:      ").append(this.getComment()).append("\nComposer:     ").append(this.getComposer()).append("\nOrig. Artist: ").append(this.getOriginalArtist()).append("\nCopyright:    ").append(this.getCopyright()).append("\nURL:          ").append(this.getURL()).append("\nEncoded by:   ").append(this.getEncodedBy()).append("\n");
        return stringBuffer.toString();
    }
}

