/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Configuration;
import de.ueberdosis.mp3info.gui.Id3JPanel;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FrameAENC
extends ID3V2Frame {
    private String ownerIdentifier = "";
    private int previewStart = 0;
    private int previewLength = 0;
    private byte[] encryptionInfo = null;

    public String getLongName() {
        return "Audio Encryption frame";
    }

    public int legalSince() {
        return 3;
    }

    public FrameAENC(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameAENC) {
            FrameAENC frameAENC = (FrameAENC)iD3V2Frame;
            this.ownerIdentifier = new String(frameAENC.ownerIdentifier);
            this.previewStart = frameAENC.previewStart;
            this.previewLength = frameAENC.previewLength;
            this.encryptionInfo = new byte[frameAENC.encryptionInfo.length];
            System.arraycopy(frameAENC.encryptionInfo, 0, this.encryptionInfo, 0, frameAENC.encryptionInfo.length);
        }
    }

    public FrameAENC(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            byte[] byArray = dataSource.getBytesTo((byte)0);
            if (byArray != null) {
                this.ownerIdentifier = new String(byArray);
            }
            dataSource.getByte();
            this.previewStart = Helper.decodeBytesToInt(dataSource.getBytes(2L));
            this.previewLength = Helper.decodeBytesToInt(dataSource.getBytes(2L));
            this.encryptionInfo = dataSource.getBytes(dataSource.getBytesLeft());
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public String toString() {
        return this.getLongName() + "\nOnwer: " + this.ownerIdentifier + "\nPreviewStart: " + this.previewStart + "\nPreviewLength: " + this.previewLength + "\nEncryptionInfo: " + Helper.arrayToHexString(this.encryptionInfo);
    }

    public String getOwnerIdentifier() {
        return new String(this.ownerIdentifier);
    }

    public void setOwnerIdentifier(String string) {
        this.ownerIdentifier = new String(string);
    }

    public int getPreviewStart() {
        return this.previewStart;
    }

    public void setPreviewStart(int n) {
        if (n >= 0) {
            this.previewStart = n;
        }
    }

    public int getPreviewLength() {
        return this.previewLength;
    }

    public void setPreviewLength(int n) {
        if (n >= 0) {
            this.previewLength = n;
        }
    }

    public byte[] getEncryptionInfo() {
        if (this.encryptionInfo != null) {
            byte[] byArray = new byte[this.encryptionInfo.length];
            System.arraycopy(this.encryptionInfo, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    public void setEncryptionInfo(byte[] byArray) {
        if (byArray != null) {
            this.encryptionInfo = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.encryptionInfo, 0, byArray.length);
        } else {
            this.encryptionInfo = null;
        }
    }

    public byte[] getData() {
        byte[] byArray = this.getEncryptionInfo();
        byte[] byArray2 = this.ownerIdentifier.getBytes();
        byte[] byArray3 = new byte[byArray2.length + 5 + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byArray3[byArray2.length] = 0;
        byArray3[byArray2.length + 1] = (byte)((this.previewStart & 0xFF00) >> 16);
        byArray3[byArray2.length + 2] = (byte)(this.previewStart & 0xFF);
        byArray3[byArray2.length + 3] = (byte)((this.previewLength & 0xFF00) >> 16);
        byArray3[byArray2.length + 4] = (byte)(this.previewLength & 0xFF);
        System.arraycopy(byArray, 0, byArray3, byArray2.length + 5, byArray.length);
        return byArray3;
    }

    public boolean canDisplay() {
        return true;
    }

    public boolean canEdit() {
        return false;
    }

    public Id3JPanel createJPanel(boolean bl, boolean bl2) {
        int n = Configuration.labelWidth;
        int n2 = Configuration.labelHeight;
        Dimension dimension = new Dimension(n, n2);
        int n3 = Configuration.textWidth;
        int n4 = Configuration.textHeight;
        Dimension dimension2 = new Dimension(n3, n4);
        int n5 = Configuration.buttonWidth;
        int n6 = Configuration.buttonHeight;
        Dimension dimension3 = new Dimension(n5, n6);
        int n7 = Configuration.textAreaWidth;
        int n8 = Configuration.textAreaHeight;
        Dimension dimension4 = new Dimension(n7, n8);
        if (!this.canEdit()) {
            bl = false;
        }
        if (!bl) {
            bl2 = false;
        }
        JLabel jLabel = new JLabel("Owner:");
        JLabel jLabel2 = new JLabel("Preview start:");
        JLabel jLabel3 = new JLabel("Preview length:");
        JLabel jLabel4 = new JLabel("Encrypt info:");
        JTextField jTextField = new JTextField(this.ownerIdentifier);
        JTextField jTextField2 = new JTextField(this.previewStart);
        JTextField jTextField3 = new JTextField(this.previewLength);
        JTextArea jTextArea = new JTextArea(new String(this.encryptionInfo));
        Id3JPanel id3JPanel = new Id3JPanel(new FlowLayout(0), true){

            public void updateData() {
            }
        };
        int n9 = n + (n3 > n7 ? n3 : n7) + 20;
        int n10 = 3 * (n2 > n4 ? n2 : n4) + n8 + 6;
        jTextField.setEditable(bl);
        jTextField.setEnabled(bl);
        jTextField.setMinimumSize(dimension2);
        jTextField.setPreferredSize(dimension2);
        jTextField2.setEditable(bl);
        jTextField2.setEnabled(bl);
        jTextField2.setMinimumSize(dimension2);
        jTextField2.setPreferredSize(dimension2);
        jTextField3.setEditable(bl);
        jTextField3.setEnabled(bl);
        jTextField3.setMinimumSize(dimension2);
        jTextField3.setPreferredSize(dimension2);
        jTextArea.setEditable(bl);
        jTextArea.setEnabled(bl);
        jTextArea.setMinimumSize(dimension4);
        jTextArea.setPreferredSize(dimension4);
        jLabel.setMinimumSize(dimension);
        jLabel.setPreferredSize(dimension);
        jLabel2.setMinimumSize(dimension);
        jLabel2.setPreferredSize(dimension);
        jLabel3.setMinimumSize(dimension);
        jLabel3.setPreferredSize(dimension);
        jLabel4.setMinimumSize(dimension);
        jLabel4.setPreferredSize(dimension);
        id3JPanel.setMinimumSize(new Dimension(n9, n10));
        id3JPanel.setPreferredSize(new Dimension(n9, n10));
        id3JPanel.add(jLabel);
        id3JPanel.add(jTextField);
        id3JPanel.add(jLabel2);
        id3JPanel.add(jTextField2);
        id3JPanel.add(jLabel3);
        id3JPanel.add(jTextField3);
        id3JPanel.add(jLabel4);
        id3JPanel.add(jTextArea);
        return id3JPanel;
    }
}

