/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;
import java.util.Enumeration;
import java.util.Vector;

public class FrameEQUA
extends ID3V2Frame {
    private int adjustmentBits = 0;
    private byte[] data = null;
    private Vector adjustments = new Vector();

    public String getLongName() {
        return "Equalisation frame";
    }

    public FrameEQUA(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameEQUA) {
            FrameEQUA frameEQUA = (FrameEQUA)iD3V2Frame;
            this.adjustmentBits = frameEQUA.adjustmentBits;
            this.data = new byte[frameEQUA.data.length];
            System.arraycopy(frameEQUA.data, 0, this.data, 0, frameEQUA.data.length);
            Enumeration enumeration = frameEQUA.adjustments.elements();
            while (enumeration.hasMoreElements()) {
                this.adjustments.addElement(((Adjustment)enumeration.nextElement()).clone());
            }
        }
    }

    public FrameEQUA(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.adjustmentBits = dataSource.getByte() & 0xFF;
            this.data = dataSource.getBytes(dataSource.getBytesLeft());
            this.decodeData();
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, "Text frame can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    private void decodeData() {
        byte by = 0;
        byte[] byArray = null;
        for (int i = 0; i < this.data.length; i += this.adjustmentBits % 8 + 1) {
            Adjustment adjustment = new Adjustment();
            by = this.data[i];
            adjustment.increment = (by & 0x80) == 1;
            adjustment.frequency = by & 0x7F;
            ++i;
            byArray = new byte[this.adjustmentBits % 8 + 1];
            for (int j = 0; j <= this.adjustmentBits % 8; ++j) {
                byArray[j] = this.data[i + j];
            }
            adjustment.adjustment = Helper.decodeBytesToInt(byArray);
            this.adjustments.addElement(adjustment);
        }
    }

    public byte[] getData() {
        return null;
    }

    public String toString() {
        return this.getLongName() + "\nEtries: " + this.adjustments.size();
    }

    public class Adjustment {
        public boolean increment = false;
        public int frequency = 0;
        public int adjustment = 0;

        public Object clone() {
            Adjustment adjustment = new Adjustment();
            adjustment.increment = this.increment;
            adjustment.frequency = this.frequency;
            adjustment.adjustment = this.adjustment;
            return adjustment;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Adjustment)) {
                return false;
            }
            Adjustment adjustment = (Adjustment)object;
            return adjustment.increment == this.increment || adjustment.frequency == this.frequency || adjustment.adjustment == this.adjustment;
        }
    }
}

