/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;
import java.util.Vector;

public class FrameETCO
extends ID3V2Frame {
    private byte[] codes;
    private Vector timeCodes = new Vector();
    private int timeStampFormat = 0;
    public static final String[] timeFormats = new String[]{"N/A", "Absolute time, 32 bit sized, using MPEG frames as unit", "Absolute time, 32 bit sized, using milliseconds as unit", "N/A"};
    public static final String[] eventsFirstBlock = new String[]{"padding (has no meaning)", "end of initial silence", "intro start", "mainpart start", "outro start", "outro end", "verse start", "refrain start", "interlude start", "theme start", "variation start", "key change", "time change", "momentary unwanted noise (Snap, Crackle & Pop)", "sustained noise", "sustained noise end", "intro end", "mainpart end", "verse end", "refrain end", "theme end"};
    public static final String[] eventsSecondBlock = new String[]{"not predefined sync (0xe0)", "not predefined sync (0xe1)", "not predefined sync (0xe2)", "not predefined sync (0xe3)", "not predefined sync (0xe4)", "not predefined sync (0xe5)", "not predefined sync (0xe6)", "not predefined sync (0xe7)", "not predefined sync (0xe8)", "not predefined sync (0xe9)", "not predefined sync (0xea)", "not predefined sync (0xeb)", "not predefined sync (0xec)", "not predefined sync (0xed)", "not predefined sync (0xee)", "not predefined sync (0xef)", "reserved for future use (0xf0)", "reserved for future use (0xf1)", "reserved for future use (0xf2)", "reserved for future use (0xf3)", "reserved for future use (0xf4)", "reserved for future use (0xf5)", "reserved for future use (0xf6)", "reserved for future use (0xf7)", "reserved for future use (0xf8)", "reserved for future use (0xf9)", "reserved for future use (0xfa)", "reserved for future use (0xfb)", "reserved for future use (0xfc)", "audio end (start of silence)", "audio file ends", "one more byte of events follows (all the following bytes with the value $FF have the same function)"};

    public FrameETCO(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
    }

    public static String getEventName(int n) {
        if (n >= 0 && n < 21) {
            return eventsFirstBlock[n];
        }
        if (n >= 21 && n < 234) {
            return "reserved for future use (" + Helper.byteToHexString(n) + ")";
        }
        if (n < 256) {
            return eventsSecondBlock[n - 234];
        }
        return "Undefinable Event (" + n + " < 0 || " + n + " > 255)";
    }

    public String getLongName() {
        return "Event timing codes frame";
    }

    public FrameETCO(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.timeStampFormat = dataSource.getByte() & 0xFF;
            this.codes = dataSource.getBytes(dataSource.getBytesLeft());
            this.decodeEventData();
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    private void decodeEventData() {
        Object var3_2 = null;
        EventTime eventTime = null;
        for (int i = 0; i < this.codes.length; i += 5) {
            eventTime = new EventTime();
            byte[] byArray = new byte[]{this.codes[i], this.codes[i + 1], this.codes[i + 2], this.codes[i + 3]};
            eventTime.timeStamp = Helper.decodeBytesToInt(byArray);
            eventTime.event = this.codes[i + 4] & 0xFF;
            this.timeCodes.addElement(eventTime);
        }
    }

    public byte[] getData() {
        return null;
    }

    public String toString() {
        return this.getLongName() + "\nNumber of events : " + this.timeCodes.size();
    }

    public class EventTime {
        public int timeStamp = 0;
        public int event = 0;
    }
}

