/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.DatamismatchException;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameGEOB
extends ID3V2Frame {
    private byte encoding = 0;
    private String mimeType = "";
    private String fileName = "";
    private String contentDescription = "";
    private byte[] fileData = null;

    public String getLongName() {
        return "General encapsulated object frame";
    }

    public FrameGEOB(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameGEOB) {
            FrameGEOB frameGEOB = (FrameGEOB)iD3V2Frame;
            this.encoding = frameGEOB.encoding;
            this.mimeType = frameGEOB.mimeType;
            this.fileName = frameGEOB.fileName;
            this.contentDescription = frameGEOB.contentDescription;
            this.fileData = new byte[frameGEOB.fileData.length];
            System.arraycopy(frameGEOB.fileData, 0, this.fileData, 0, frameGEOB.fileData.length);
        }
    }

    public FrameGEOB(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            this.mimeType = dataSource.readString((byte)0);
            this.fileName = dataSource.readString(this.encoding);
            this.contentDescription = dataSource.readString(this.encoding);
            this.fileData = dataSource.getBytes(dataSource.getBytesLeft());
        }
        catch (DatamismatchException datamismatchException) {
            OutputCtr.println(0, this.getLongName() + "\n" + datamismatchException);
        }
    }

    public String toString() {
        return this.getLongName() + "\n";
    }

    public byte[] getData() {
        int n;
        int n2 = Helper.getStringDelimiterSize(this.encoding);
        byte[] byArray = Helper.getStringBytes(this.mimeType, (byte)0);
        byte[] byArray2 = Helper.getStringBytes(this.fileName, this.encoding);
        byte[] byArray3 = Helper.getStringBytes(this.contentDescription, this.encoding);
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length + this.fileData.length + 2 + 2 * n2];
        int n3 = 0;
        byArray4[n3++] = this.encoding;
        System.arraycopy(byArray, 0, byArray4, n3, byArray.length);
        n3 += byArray.length;
        byArray4[n3++] = 0;
        System.arraycopy(byArray2, 0, byArray4, n3, byArray2.length);
        for (n = 0; n < n2; ++n) {
            byArray4[n3++] = 0;
        }
        System.arraycopy(byArray3, 0, byArray4, n3, byArray3.length);
        n3 += byArray3.length;
        for (n = 0; n < n2; ++n) {
            byArray4[n3++] = 0;
        }
        System.arraycopy(this.fileData, 0, byArray4, n3, this.fileData.length);
        return byArray4;
    }
}

