/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Configuration;
import de.ueberdosis.mp3info.gui.Id3JPanel;
import de.ueberdosis.mp3info.gui.event.UpdateEvent;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FrameOWNE
extends ID3V2Frame {
    private byte encoding = 0;
    private String pricePayed = "";
    private String purchaseDate = "";
    private String seller = "";

    public FrameOWNE(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameOWNE) {
            FrameOWNE frameOWNE = (FrameOWNE)iD3V2Frame;
            this.encoding = frameOWNE.encoding;
            this.pricePayed = frameOWNE.pricePayed;
            this.purchaseDate = frameOWNE.purchaseDate;
            this.seller = frameOWNE.seller;
        }
    }

    public int legalSince() {
        return 3;
    }

    public int deprecatedSince() {
        return -1;
    }

    public String getLongName() {
        return "Ownership frame";
    }

    public FrameOWNE(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            byte[] byArray = dataSource.getBytesTo((byte)0);
            if (byArray != null) {
                this.pricePayed = new String(byArray);
            }
            dataSource.getByte();
            this.purchaseDate = new String(dataSource.getBytes(8L));
            byArray = dataSource.getBytes(dataSource.getBytesLeft());
            try {
                this.seller = new String(byArray, Configuration.defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.seller = new String(byArray);
            }
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public String toString() {
        return this.getLongName() + "\nEncoding: " + this.encoding + "\nPrice payed:  " + this.pricePayed + "\nDate of purchase: " + this.purchaseDate + "\nSeller: " + this.seller;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.pricePayed.length() + this.seller.length() + 10];
        byArray[0] = this.encoding;
        System.arraycopy(this.pricePayed.getBytes(), 0, byArray, 1, this.pricePayed.length());
        byArray[this.pricePayed.length() + 1] = 0;
        System.arraycopy(this.purchaseDate.getBytes(), 0, byArray, this.pricePayed.length() + 2, 8);
        System.arraycopy(this.seller.getBytes(), 0, byArray, this.pricePayed.length() + 10, this.seller.length());
        return byArray;
    }

    public boolean containsData() {
        return this.pricePayed.length() > 0 || this.purchaseDate.length() > 0 || this.seller.length() > 0;
    }

    public String getPricePayed() {
        return new String(this.pricePayed);
    }

    public void setPricePayed(String string) {
        this.pricePayed = new String(string);
    }

    public String getPurchaseDate() {
        return new String(this.purchaseDate);
    }

    public void setPurchaseDate(String string) {
        this.purchaseDate = new String(string);
    }

    public String getSeller() {
        return new String(this.seller);
    }

    public void setSeller(String string) {
        this.seller = new String(string);
    }

    public boolean canEdit() {
        return true;
    }

    public boolean canDisplay() {
        return true;
    }

    public Id3JPanel createJPanel(boolean bl, boolean bl2) {
        int n = Configuration.labelWidth;
        int n2 = Configuration.labelHeight;
        Dimension dimension = new Dimension(n, n2);
        int n3 = Configuration.textWidth;
        int n4 = Configuration.textHeight;
        Dimension dimension2 = new Dimension(n3, n4);
        int n5 = Configuration.buttonWidth;
        int n6 = Configuration.buttonHeight;
        Dimension dimension3 = new Dimension(n5, n6);
        if (!this.canEdit()) {
            bl = false;
        }
        if (!bl) {
            bl2 = false;
        }
        JLabel jLabel = new JLabel("Price payed:");
        JLabel jLabel2 = new JLabel("Purchase date:");
        JLabel jLabel3 = new JLabel("Seller:");
        final JTextField jTextField = new JTextField(this.pricePayed);
        final JTextField jTextField2 = new JTextField(this.purchaseDate);
        final JTextField jTextField3 = new JTextField(this.seller);
        final Id3JPanel id3JPanel = new Id3JPanel(new FlowLayout(0), true){

            public void updateData() {
                FrameOWNE.this.pricePayed = jTextField.getText();
                FrameOWNE.this.purchaseDate = jTextField2.getText();
                FrameOWNE.this.seller = jTextField3.getText();
                FrameOWNE.this.dataChanged = true;
                this.fireUpdateEvent(new UpdateEvent(this));
            }
        };
        int n7 = n + n3 + 20;
        int n8 = 3 * (n2 > n4 ? n2 : n4) + 6;
        if (bl2) {
            n7 += n5 + 5;
        }
        jTextField.setEditable(bl);
        jTextField.setEnabled(bl);
        jTextField.setMinimumSize(dimension2);
        jTextField.setPreferredSize(dimension2);
        jTextField2.setEditable(bl);
        jTextField2.setEnabled(bl);
        jTextField2.setMinimumSize(dimension2);
        jTextField2.setPreferredSize(dimension2);
        jTextField3.setEditable(bl);
        jTextField3.setEnabled(bl);
        jTextField3.setMinimumSize(dimension2);
        jTextField3.setPreferredSize(dimension2);
        jLabel.setMinimumSize(dimension);
        jLabel.setPreferredSize(dimension);
        jLabel2.setMinimumSize(dimension);
        jLabel2.setPreferredSize(dimension);
        jLabel3.setMinimumSize(dimension);
        jLabel3.setPreferredSize(dimension);
        id3JPanel.setMinimumSize(new Dimension(n7, n8));
        id3JPanel.setPreferredSize(new Dimension(n7, n8));
        id3JPanel.add(jLabel);
        id3JPanel.add(jTextField);
        if (bl2) {
            JButton jButton = new JButton("OK");
            jButton.setMinimumSize(dimension3);
            jButton.setPreferredSize(dimension3);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    id3JPanel.updateData();
                }
            });
            id3JPanel.add(jButton);
        }
        id3JPanel.add(jLabel2);
        id3JPanel.add(jTextField2);
        id3JPanel.add(jLabel3);
        id3JPanel.add(jTextField3);
        return id3JPanel;
    }
}

