/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FramePCNT
extends ID3V2Frame {
    private int playCounter = 0;

    public String getLongName() {
        return "Play counter frame";
    }

    public FramePCNT(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FramePCNT) {
            this.playCounter = ((FramePCNT)iD3V2Frame).playCounter;
        }
    }

    public FramePCNT(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            byte[] byArray = dataSource.getBytes(dataSource.getBytesLeft());
            if (byArray != null) {
                this.playCounter = Helper.decodeBytesToInt(byArray);
            }
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public byte[] getData() {
        return Helper.intToByteArray(this.playCounter);
    }

    public String toString() {
        return this.getLongName() + "\nPlayed: " + this.playCounter;
    }
}

