/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FramePOPM
extends ID3V2Frame {
    private String mailAdd = "";
    private int rating = 0;
    private int playCounter = 0;

    public String getLongName() {
        return "Popularimeter frame";
    }

    public FramePOPM(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FramePOPM) {
            FramePOPM framePOPM = (FramePOPM)iD3V2Frame;
            this.mailAdd = framePOPM.mailAdd;
            this.rating = framePOPM.rating;
            this.playCounter = framePOPM.playCounter;
        }
    }

    public FramePOPM(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            byte[] byArray = dataSource.getBytesTo((byte)0);
            if (byArray != null) {
                this.mailAdd = new String(byArray);
            }
            dataSource.getByte();
            this.rating = dataSource.getByte() & 0xFF;
            if (dataSource.hasMoreBytes() && (byArray = dataSource.getBytes(dataSource.getBytesLeft())) != null) {
                this.playCounter = Helper.decodeBytesToInt(byArray);
            }
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public byte[] getData() {
        byte[] byArray = this.mailAdd.getBytes();
        byte[] byArray2 = Helper.intToByteArray(this.playCounter);
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray3[byArray.length] = 0;
        byArray3[byArray.length + 1] = (byte)this.rating;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 2, byArray2.length);
        return byArray3;
    }

    public String toString() {
        return this.getLongName() + "\nUser: " + this.mailAdd + "\nRating: " + this.rating + "\nPlay counter: " + this.playCounter;
    }
}

