/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameRBUF
extends ID3V2Frame {
    private int buffer = 0;
    private boolean embeddedInfo = false;
    private int offsetToNextTag = 0;

    public String getLongName() {
        return "Recommended buffer frame";
    }

    public FrameRBUF(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameRBUF) {
            FrameRBUF frameRBUF = (FrameRBUF)iD3V2Frame;
            this.buffer = frameRBUF.buffer;
            this.embeddedInfo = frameRBUF.embeddedInfo;
            this.offsetToNextTag = frameRBUF.offsetToNextTag;
        }
    }

    public FrameRBUF(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.buffer = Helper.decodeBytesToInt(dataSource.getBytes(4L));
            this.embeddedInfo = dataSource.getByte() == 1;
            this.offsetToNextTag = Helper.decodeBytesToInt(dataSource.getBytes(4L));
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public byte[] getData() {
        byte[] byArray = new byte[8];
        byte[] byArray2 = Helper.intToByteArray(this.buffer, 3);
        byte[] byArray3 = Helper.intToByteArray(this.offsetToNextTag, 4);
        System.arraycopy(byArray2, 0, byArray, 0, 3);
        byArray[3] = (byte)(this.embeddedInfo ? 1 : 0);
        System.arraycopy(byArray3, 0, byArray, 4, 4);
        return byArray;
    }

    public String toString() {
        return this.getLongName() + "\nbuffer: " + this.buffer + "\nEmbedded Info: " + this.embeddedInfo + "\nOffset to next tag: " + this.offsetToNextTag;
    }
}

