/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameRVRB
extends ID3V2Frame {
    private int reverbLeft = 0;
    private int reverbRight = 0;
    private int bouncesLeft = 0;
    private int bouncesRight = 0;
    private int feedbackLeftLeft = 0;
    private int feedbackLeftRight = 0;
    private int feedbackRightRight = 0;
    private int feedbackRightLeft = 0;
    private int premixLeftRight = 0;
    private int premixRightLeft = 0;

    public String getLongName() {
        return "Reverb frame";
    }

    public FrameRVRB(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameRVRB) {
            FrameRVRB frameRVRB = (FrameRVRB)iD3V2Frame;
            this.reverbLeft = frameRVRB.reverbLeft;
            this.reverbRight = frameRVRB.reverbRight;
            this.bouncesLeft = frameRVRB.bouncesLeft;
            this.bouncesRight = frameRVRB.bouncesRight;
            this.feedbackLeftLeft = frameRVRB.feedbackLeftLeft;
            this.feedbackLeftRight = frameRVRB.feedbackLeftRight;
            this.feedbackRightRight = frameRVRB.feedbackRightRight;
            this.feedbackRightLeft = frameRVRB.feedbackRightLeft;
            this.premixLeftRight = frameRVRB.premixLeftRight;
            this.premixRightLeft = frameRVRB.premixRightLeft;
        }
    }

    public FrameRVRB(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            byte[] byArray = new byte[]{dataSource.getByte(), dataSource.getByte()};
            this.reverbLeft = Helper.decodeBytesToInt(byArray);
            byArray[0] = dataSource.getByte();
            byArray[1] = dataSource.getByte();
            this.reverbRight = Helper.decodeBytesToInt(byArray);
            this.bouncesLeft = dataSource.getByte() & 0xFF;
            this.bouncesRight = dataSource.getByte() & 0xFF;
            this.feedbackLeftLeft = dataSource.getByte() & 0xFF;
            this.feedbackLeftRight = dataSource.getByte() & 0xFF;
            this.feedbackRightRight = dataSource.getByte() & 0xFF;
            this.feedbackRightLeft = dataSource.getByte() & 0xFF;
            this.premixLeftRight = dataSource.getByte() & 0xFF;
            this.premixRightLeft = dataSource.getByte() & 0xFF;
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public byte[] getData() {
        byte[] byArray = new byte[12];
        byte[] byArray2 = Helper.intToByteArray(this.reverbLeft, 2);
        byArray[0] = byArray2[0];
        byArray[1] = byArray2[1];
        byArray2 = Helper.intToByteArray(this.reverbRight, 2);
        byArray[2] = byArray2[0];
        byArray[3] = byArray2[1];
        byArray[4] = (byte)this.bouncesLeft;
        byArray[5] = (byte)this.bouncesRight;
        byArray[6] = (byte)this.feedbackLeftLeft;
        byArray[7] = (byte)this.feedbackLeftRight;
        byArray[8] = (byte)this.feedbackRightRight;
        byArray[9] = (byte)this.feedbackRightLeft;
        byArray[10] = (byte)this.premixLeftRight;
        byArray[11] = (byte)this.premixRightLeft;
        return byArray;
    }

    public String toString() {
        return this.getLongName() + "\n";
    }
}

