/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Configuration;
import de.ueberdosis.mp3info.DatamismatchException;
import de.ueberdosis.mp3info.gui.Id3JPanel;
import de.ueberdosis.mp3info.gui.event.UpdateEvent;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FrameT
extends ID3V2Frame {
    byte encoding = 0;
    String text = "";

    public String getLongName() {
        return "Generic text frame";
    }

    public FrameT(String string) {
        super(string);
        this.encoding = Helper.getByteEncoding(Configuration.defaultEncoding);
    }

    public FrameT(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameT) {
            FrameT frameT = (FrameT)iD3V2Frame;
            this.encoding = frameT.encoding;
            this.text = frameT.text;
        } else {
            this.encoding = Helper.getByteEncoding(Configuration.defaultEncoding);
        }
    }

    public FrameT(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            if (this.encoding > 3) {
                dataSource.seekRelative(-1L);
                this.encoding = Helper.getByteEncoding(Configuration.defaultEncoding);
            }
            this.text = dataSource.readString(this.encoding);
        }
        catch (DatamismatchException datamismatchException) {
            OutputCtr.println(0, "Text frame can't be instantiated!");
            throw new SeekPastEndException(datamismatchException.getMessage());
        }
    }

    public String getText() {
        return new String(this.text);
    }

    public void setText(String string) {
        this.text = new String(string.trim());
    }

    public String toString() {
        return this.getLongName() + " Encoding: " + this.encoding + "\ntext: " + this.text;
    }

    public byte[] getData() {
        byte[] byArray = Helper.stringToByteArray(this.text, this.encoding);
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = this.encoding;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return byArray2;
    }

    public boolean containsData() {
        return this.text.trim().length() > 0;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public void setEncoding(byte by) throws DatamismatchException {
        if (!Helper.isValidEncoding(by)) {
            throw new DatamismatchException("Tried to set encoding to " + by + " which is out of range.");
        }
        this.encoding = by;
    }

    protected Id3JPanel createJPanel(boolean bl, boolean bl2, String string) {
        int n = Configuration.labelWidth;
        int n2 = Configuration.labelHeight;
        Dimension dimension = new Dimension(n, n2);
        int n3 = Configuration.textWidth;
        int n4 = Configuration.textHeight;
        Dimension dimension2 = new Dimension(n3, n4);
        int n5 = Configuration.buttonWidth;
        int n6 = Configuration.buttonHeight;
        Dimension dimension3 = new Dimension(n5, n6);
        if (!this.canEdit()) {
            bl = false;
        }
        if (!bl) {
            bl2 = false;
        }
        JLabel jLabel = new JLabel(string);
        final JTextField jTextField = new JTextField(this.text);
        final Id3JPanel id3JPanel = new Id3JPanel(new FlowLayout(0), true){

            public void updateData() {
                FrameT.this.text = jTextField.getText();
                FrameT.this.dataChanged = true;
                this.fireUpdateEvent(new UpdateEvent(this));
            }
        };
        int n7 = n + n3 + 20;
        int n8 = (n2 > n4 ? n2 : n4) + 6;
        if (bl2) {
            n7 += n5 + 5;
            n8 = n6 + 10;
        }
        jTextField.setEditable(bl);
        jTextField.setEnabled(bl);
        jTextField.setMinimumSize(dimension2);
        jTextField.setPreferredSize(dimension2);
        jLabel.setMinimumSize(dimension);
        jLabel.setPreferredSize(dimension);
        id3JPanel.setMinimumSize(new Dimension(n7, n8));
        id3JPanel.setPreferredSize(new Dimension(n7, n8));
        id3JPanel.add(jLabel);
        id3JPanel.add(jTextField);
        if (bl2) {
            JButton jButton = new JButton("OK");
            jButton.setMinimumSize(dimension3);
            jButton.setPreferredSize(dimension3);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    id3JPanel.updateData();
                }
            });
            id3JPanel.add(jButton);
        }
        return id3JPanel;
    }
}

