/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.DatamismatchException;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameTXXX
extends ID3V2Frame {
    private byte encoding = 0;
    private String description = "";
    private String value = "";

    public String getLongName() {
        return "User defined text frame";
    }

    public FrameTXXX(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameTXXX) {
            FrameTXXX frameTXXX = (FrameTXXX)iD3V2Frame;
            this.encoding = frameTXXX.encoding;
            this.description = frameTXXX.description;
            this.value = frameTXXX.value;
        }
    }

    public FrameTXXX(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            this.description = dataSource.readString(this.encoding);
            this.value = dataSource.readString(this.encoding);
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
        catch (DatamismatchException datamismatchException) {
            OutputCtr.println(4, datamismatchException);
        }
    }

    public String toString() {
        return this.getLongName() + "\nDescription: " + this.description + "\nValue      : " + this.value;
    }

    public byte getEncodingByte() {
        return this.encoding;
    }

    public void setEncodingByte(byte by) throws DatamismatchException {
        if (by < 0 || by > 3) {
            throw new DatamismatchException("Setting encoding to " + by + " is illegal. Legal values are " + "0 - 3.");
        }
        this.encoding = by;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public byte[] getData() {
        byte[] byArray = Helper.getStringBytes(this.description, this.encoding);
        byte[] byArray2 = Helper.getStringBytes(this.value, this.encoding);
        byte[] byArray3 = Helper.reallocateByteBuffer(byArray.length + byArray2.length + Helper.getStringDelimiterSize(this.encoding) + 1);
        byArray3[0] = this.encoding;
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        for (int i = 1; i < Helper.getStringDelimiterSize(this.encoding); ++i) {
            byArray3[byArray.length + i] = 0;
        }
        System.arraycopy(byArray2, 0, byArray3, byArray.length + Helper.getStringDelimiterSize(this.encoding) + 1, byArray2.length);
        return byArray3;
    }
}

