/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameUFID
extends ID3V2Frame {
    private String ownerIdentifier = "";
    private byte[] identifier = null;

    public String getLongName() {
        return "Unique file identifier";
    }

    public FrameUFID(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            StringBuffer stringBuffer = new StringBuffer();
            byte by = dataSource.getByte();
            while (by != 0) {
                stringBuffer.append((char)by);
                by = dataSource.getByte();
            }
            this.ownerIdentifier = stringBuffer.toString();
            this.identifier = dataSource.getBytes(dataSource.getBytesLeft());
            if (this.identifier.length > 64) {
                OutputCtr.println(1, "Something's strange. FrameUFIDs identifier is " + this.identifier.length + " bytes long...");
            }
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, "FrameUFID can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public byte[] getData() {
        byte[] byArray = this.ownerIdentifier.getBytes();
        byte[] byArray2 = Helper.reallocateByteBuffer(byArray.length + this.identifier.length + 1);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        System.arraycopy(this.identifier, 0, byArray2, byArray.length + 1, this.identifier.length);
        return byArray2;
    }

    public String toString() {
        return this.getLongName() + " OI: " + this.ownerIdentifier + "\nident: " + Helper.arrayToHexString(this.identifier);
    }
}

