/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.DatamismatchException;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameUSLT
extends ID3V2Frame {
    private byte encoding = 0;
    private String language = "";
    private String description = "";
    private String text = "";

    public String getLongName() {
        return "Unsychronised lyrics/text transcription frame";
    }

    public FrameUSLT(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameUSLT) {
            FrameUSLT frameUSLT = (FrameUSLT)iD3V2Frame;
            this.language = frameUSLT.language;
            this.description = frameUSLT.description;
            this.text = frameUSLT.text;
            this.encoding = frameUSLT.encoding;
        }
    }

    public FrameUSLT(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            this.language = new String(dataSource.getBytes(3L));
            this.description = dataSource.readString(this.encoding);
            this.text = new String(dataSource.getBytes(dataSource.getBytesLeft()));
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
        catch (DatamismatchException datamismatchException) {
            OutputCtr.println(4, datamismatchException);
        }
    }

    public String toString() {
        return this.getLongName() + " Encoding: " + this.encoding + "\nlanguage: " + this.language + "\ntext: " + this.text;
    }

    public byte[] getData() {
        byte[] byArray = Helper.getStringBytes(this.description, this.encoding);
        byte[] byArray2 = Helper.getStringBytes(this.text, this.encoding);
        byte[] byArray3 = this.language.getBytes();
        byte[] byArray4 = Helper.reallocateByteBuffer(4 + byArray.length + byArray2.length + Helper.getStringDelimiterSize(this.encoding), null);
        byArray4[0] = this.encoding;
        System.arraycopy(byArray3, 0, byArray4, 1, 3);
        System.arraycopy(byArray2, 0, byArray4, 4, byArray.length);
        for (int i = 1; i < Helper.getStringDelimiterSize(this.encoding); ++i) {
            byArray4[4 + byArray.length + i] = 0;
        }
        System.arraycopy(byArray2, 0, byArray4, 4 + byArray.length + Helper.getStringDelimiterSize(this.encoding), byArray2.length);
        return byArray4;
    }
}

