/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.DatamismatchException;
import de.ueberdosis.mp3info.gui.EncDescValJPanel;
import de.ueberdosis.mp3info.gui.Id3JPanel;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.EncDescValFrame;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameWXXX
extends ID3V2Frame
implements EncDescValFrame {
    private byte encoding = 0;
    private String description = "";
    private String value = "";
    private static final String caption1 = "URL description:";
    private static final String caption2 = "URL:";

    public String getLongName() {
        return "User defined url frame";
    }

    public FrameWXXX() {
        super("WXXX");
    }

    public FrameWXXX(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameWXXX) {
            FrameWXXX frameWXXX = (FrameWXXX)iD3V2Frame;
            this.encoding = frameWXXX.encoding;
            this.description = new String(frameWXXX.description);
            this.value = new String(frameWXXX.value);
        }
    }

    public FrameWXXX(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            this.description = dataSource.readString(this.encoding);
            this.value = dataSource.readString((byte)0);
        }
        catch (DatamismatchException datamismatchException) {
            OutputCtr.println(0, this.getLongName() + "\n" + datamismatchException);
        }
    }

    public String toString() {
        return this.getLongName() + "\nEncoding   : " + this.encoding + "\nDescription: " + this.description + "\nURL        : " + this.value;
    }

    public boolean containsData() {
        return this.description.length() > 0 || this.value.length() > 0;
    }

    public boolean canDisplay() {
        return true;
    }

    public boolean canEdit() {
        return true;
    }

    public Id3JPanel createJPanel(boolean bl, boolean bl2) {
        return new EncDescValJPanel(bl, bl2, caption1, this.description, caption2, this.value, this);
    }

    public void setDescription(String string) {
        if (!string.equals(this.description)) {
            this.dataChanged = true;
            this.description = new String(string);
        }
    }

    public String getDescription() {
        return new String(this.description);
    }

    public void setValue(String string) {
        if (!string.equals(this.value)) {
            this.dataChanged = true;
            this.value = new String(string);
        }
    }

    public byte[] getData() {
        byte[] byArray = Helper.getStringBytes(this.description, this.encoding);
        byte[] byArray2 = Helper.getStringBytes(this.value, (byte)0);
        int n = Helper.getStringDelimiterSize(this.encoding);
        byte[] byArray3 = new byte[byArray.length + byArray2.length + n + 1];
        byArray3[0] = this.encoding;
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        for (int i = 0; i < n; ++i) {
            byArray3[byArray.length + 1 + i] = 0;
        }
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 1 + n, byArray2.length);
        return byArray3;
    }

    public String getValue() {
        return new String(this.value);
    }
}

