/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Defines;
import de.ueberdosis.mp3info.UndersizedException;
import de.ueberdosis.mp3info.gui.Id3JPanel;
import de.ueberdosis.mp3info.gui.Id3Panel;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.NotAnID3V2FrameException;
import de.ueberdosis.util.OutputCtr;

public abstract class ID3V2Frame
implements Defines {
    private String frameID = "";
    private long size = 0L;
    private long position = 0L;
    private boolean tagAlterPreservation = false;
    private boolean fileAlterPreservation = false;
    private boolean readOnly = false;
    private boolean compression = false;
    private boolean encryption = false;
    private boolean groupingIdentity = false;
    private boolean unSynchronisation = false;
    private boolean dataLengthIndicator = false;
    protected boolean dataChanged;
    protected int legalSince = -1;
    protected int deprecatedSince = -1;

    public ID3V2Frame(String string) {
        this.frameID = new String(string);
    }

    public ID3V2Frame(ID3V2Frame iD3V2Frame) {
        this.frameID = iD3V2Frame.frameID;
        this.size = iD3V2Frame.size;
        this.position = iD3V2Frame.position;
        this.tagAlterPreservation = iD3V2Frame.tagAlterPreservation;
        this.fileAlterPreservation = iD3V2Frame.fileAlterPreservation;
        this.readOnly = iD3V2Frame.readOnly;
        this.compression = iD3V2Frame.compression;
        this.encryption = iD3V2Frame.encryption;
        this.groupingIdentity = iD3V2Frame.groupingIdentity;
    }

    public ID3V2Frame(byte[] byArray) throws UndersizedException, NotAnID3V2FrameException {
        this(byArray, 4, 0);
    }

    public ID3V2Frame(byte[] byArray, int n, int n2) throws UndersizedException, NotAnID3V2FrameException {
        if (byArray.length < 10) {
            throw new UndersizedException("Got only " + byArray.length + " bytes for a frame header!", byArray.length, 10);
        }
        if (byArray[0] == 0) {
            throw new NotAnID3V2FrameException("Padding encountered.");
        }
        this.frameID = new String(byArray, 0, 4);
        byte[] byArray2 = new byte[]{byArray[4], byArray[5], byArray[6], byArray[7]};
        OutputCtr.println(5, "SizeBytes: " + Helper.byteToHexString(byArray2[0]) + " " + Helper.byteToHexString(byArray2[1]) + " " + Helper.byteToHexString(byArray2[2]) + " " + Helper.byteToHexString(byArray2[3]));
        this.size = n >= 4 ? Helper.unsynchsafe(byArray2) : (long)((byArray2[0] & 0xFF) * 0x1000000 + (byArray2[1] & 0xFF) * 65536 + (byArray2[2] & 0xFF) * 256 + (byArray2[3] & 0xFF));
        OutputCtr.println(5, "And the size: " + this.size);
        OutputCtr.println(4, "Frame is " + this.size + " bytes long.");
        this.tagAlterPreservation = (byArray[8] & 0x40) != 0;
        this.fileAlterPreservation = (byArray[8] & 0x20) != 0;
        this.readOnly = (byArray[8] & 0x10) != 0;
        this.groupingIdentity = (byArray[9] & 0x40) != 0;
        this.compression = (byArray[9] & 8) != 0;
        this.encryption = (byArray[9] & 4) != 0;
        this.unSynchronisation = (byArray[9] & 2) != 0;
        this.dataLengthIndicator = (byArray[9] & 1) != 0;
        OutputCtr.println(6, "dataLengthIndicator: " + this.dataLengthIndicator);
    }

    public String getFrameID() {
        return this.frameID;
    }

    public long getSize() {
        if (this.dataChanged) {
            byte[] byArray = this.getData();
            if (byArray != null) {
                return byArray.length;
            }
            return 0L;
        }
        return this.size;
    }

    public boolean getTagAlterPreservation() {
        return this.tagAlterPreservation;
    }

    public boolean getFileAlterPreservation() {
        return this.fileAlterPreservation;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isCompressed() {
        return this.compression;
    }

    public boolean isEncrypted() {
        return this.encryption;
    }

    public boolean hasGroupingIdentity() {
        return this.groupingIdentity;
    }

    public boolean getUnsynchronisation() {
        return this.unSynchronisation;
    }

    public boolean getDataLengthIndicator() {
        return this.dataLengthIndicator;
    }

    public boolean isAltered() {
        return this.dataChanged;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ID3v2 Frame").append("\nID: ").append(this.frameID).append("\nSize: ").append(this.size).append("\nTagAlterPreservation: ").append(this.tagAlterPreservation).append("\nFileAlterPreservation: ").append(this.fileAlterPreservation).append("\nReadOnly: ").append(this.readOnly).append("\nCompression: ").append(this.compression).append("\nEncryption: ").append(this.encryption).append("\nGroupingIdentity: ").append(this.groupingIdentity).append("\n");
        return stringBuffer.toString();
    }

    public boolean isValid() {
        byte[] byArray = this.getFrameID().getBytes();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i] & 0xFF;
        }
        return n > 128;
    }

    public boolean containsData() {
        OutputCtr.println(5, this.getFrameID() + " Frame.containsData: " + (this.getSize() > 0L) + "(Size: " + this.getSize() + ")");
        return this.getSize() > 0L;
    }

    void setPosition(long l) {
        this.position = l;
    }

    long getPosition() {
        return this.position;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ID3V2Frame)) {
            return false;
        }
        ID3V2Frame iD3V2Frame = (ID3V2Frame)object;
        return this.frameID.equals(iD3V2Frame.frameID) && this.size == iD3V2Frame.size && this.tagAlterPreservation == iD3V2Frame.tagAlterPreservation && this.fileAlterPreservation == iD3V2Frame.fileAlterPreservation && this.readOnly == iD3V2Frame.readOnly && this.compression == iD3V2Frame.compression && this.encryption == iD3V2Frame.encryption && this.groupingIdentity == iD3V2Frame.groupingIdentity;
    }

    public byte[] toByteArray() {
        int n;
        int n2;
        byte[] byArray = this.getData();
        byte[] byArray2 = new byte[10];
        for (n2 = 0; n2 < 4; ++n2) {
            byArray2[n2] = (byte)this.frameID.charAt(n2);
        }
        if (byArray != null) {
            byte[] byArray3 = Helper.synchsafe(byArray.length, 4);
            for (n = 0; n < 4; ++n) {
                byArray2[n + 4] = byArray3[n];
            }
        } else {
            for (n2 = 0; n2 < 4; ++n2) {
                byArray2[n2 + 4] = 0;
            }
        }
        byArray2[8] = 0;
        byArray2[9] = 0;
        if (this.tagAlterPreservation) {
            byArray2[8] = (byte)(byArray2[8] + 64);
        }
        if (this.fileAlterPreservation) {
            byArray2[8] = (byte)(byArray2[8] + 32);
        }
        if (this.readOnly) {
            byArray2[8] = (byte)(byArray2[8] + 16);
        }
        if (this.groupingIdentity) {
            byArray2[9] = (byte)(byArray2[9] + 64);
        }
        if (this.compression) {
            byArray2[9] = (byte)(byArray2[9] + 8);
        }
        if (this.encryption) {
            byArray2[9] = (byte)(byArray2[9] + 4);
        }
        if (this.unSynchronisation) {
            byArray2[9] = (byte)(byArray2[9] + 2);
        }
        if (this.dataLengthIndicator) {
            byArray2[9] = (byte)(byArray2[9] + 1);
        }
        byte[] byArray4 = new byte[10 + (byArray == null ? 0 : byArray.length)];
        for (n = 0; n < 10; ++n) {
            byArray4[n] = byArray2[n];
        }
        if (byArray != null) {
            for (n = 0; n < byArray.length; ++n) {
                byArray4[n + 10] = byArray[n];
            }
        }
        return byArray4;
    }

    public abstract byte[] getData();

    public boolean canDisplay() {
        return false;
    }

    public boolean canEdit() {
        return false;
    }

    public Id3JPanel createJPanel(boolean bl, boolean bl2) {
        return null;
    }

    public Id3Panel createPanel(boolean bl, boolean bl2) {
        return null;
    }

    public int legalSince() {
        return -1;
    }

    public int deprecatedSince() {
        return -1;
    }
}

