/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Defines;
import de.ueberdosis.mp3info.UndersizedException;
import de.ueberdosis.mp3info.id3v2.FileFrameDataSource;
import de.ueberdosis.mp3info.id3v2.FrameFactory;
import de.ueberdosis.mp3info.id3v2.Header;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.ID3V2FrameDefaultImpl;
import de.ueberdosis.mp3info.id3v2.ID3V2Tag;
import de.ueberdosis.mp3info.id3v2.NotAnID3V2FrameException;
import de.ueberdosis.util.OutputCtr;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3V2Reader
implements Defines {
    private long headerPosition;
    private ID3V2Tag v2tag;

    public ID3V2Reader(RandomAccessFile randomAccessFile, long l) {
        this.headerPosition = l;
        this.v2tag = new ID3V2Tag();
        try {
            randomAccessFile.seek(l);
            byte[] byArray = new byte[10];
            randomAccessFile.read(byArray);
            this.v2tag.setHeader(ID3V2Reader.analyzeID3V2Header(byArray));
            l += 10L;
            while (l < this.headerPosition + 10L + this.v2tag.getHeader().getSize()) {
                randomAccessFile.seek(l);
                byArray = new byte[10];
                randomAccessFile.read(byArray);
                if (byArray[0] == 0) break;
                ID3V2Frame iD3V2Frame = ID3V2Reader.analyzeID3V2Frame(byArray, this.getHeader().getVersion(), this.getHeader().getRevision());
                iD3V2Frame.setPosition(l);
                if (iD3V2Frame.isValid()) {
                    FileFrameDataSource fileFrameDataSource = new FileFrameDataSource(iD3V2Frame, randomAccessFile);
                    this.v2tag.addFrame(FrameFactory.getFrame(iD3V2Frame, fileFrameDataSource));
                }
                if (iD3V2Frame.getSize() < 0L) {
                    OutputCtr.println(1, "** Possible error in Frame:");
                    OutputCtr.print(1, iD3V2Frame);
                    OutputCtr.println(1, "Frame size = " + iD3V2Frame.getSize());
                    break;
                }
                l += 10L + iD3V2Frame.getSize();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (UndersizedException undersizedException) {
            undersizedException.printStackTrace();
        }
        catch (NotAnID3V2FrameException notAnID3V2FrameException) {
            notAnID3V2FrameException.printStackTrace();
        }
    }

    public Header getHeader() {
        return this.v2tag.getHeader();
    }

    public ID3V2Tag getV2Tag() {
        return this.v2tag;
    }

    public static Header analyzeID3V2Header(byte[] byArray) throws UndersizedException {
        return new Header(byArray);
    }

    public static ID3V2Frame analyzeID3V2Frame(byte[] byArray) throws UndersizedException, NotAnID3V2FrameException {
        return new ID3V2FrameDefaultImpl(byArray);
    }

    public static ID3V2Frame analyzeID3V2Frame(byte[] byArray, int n, int n2) throws UndersizedException, NotAnID3V2FrameException {
        return new ID3V2FrameDefaultImpl(byArray, n, n2);
    }
}

