/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Configuration;
import de.ueberdosis.mp3info.Defines;
import de.ueberdosis.mp3info.id3v2.FrameFactory;
import de.ueberdosis.mp3info.id3v2.Header;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.util.OutputCtr;
import java.util.Enumeration;
import java.util.Vector;

public class ID3V2Tag
implements Defines {
    private long originalSize = 0L;
    private Header header = null;
    private Vector frames = new Vector();

    public void setHeader(Header header) {
        this.header = header;
        this.originalSize = this.header.getSize() + 10L + (long)(this.header.hasFooter() ? 10 : 0);
    }

    public ID3V2Tag() {
        this.header = new Header();
    }

    public ID3V2Tag(ID3V2Tag iD3V2Tag) {
        this.header = new Header(iD3V2Tag.getHeader());
        Enumeration enumeration = iD3V2Tag.getFrames().elements();
        while (enumeration.hasMoreElements()) {
            ID3V2Frame iD3V2Frame = (ID3V2Frame)enumeration.nextElement();
            if ((iD3V2Frame = FrameFactory.getFrame(iD3V2Frame)) == null) continue;
            this.frames.addElement(iD3V2Frame);
        }
    }

    public void addFrame(ID3V2Frame iD3V2Frame) {
        this.frames.addElement(iD3V2Frame);
    }

    public void removeFrame(ID3V2Frame iD3V2Frame) {
        this.frames.removeElement(iD3V2Frame);
    }

    public Header getHeader() {
        return this.header;
    }

    public Vector getFrames() {
        return this.frames;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.header).append("\nContained frames:\n\n");
        Enumeration enumeration = this.frames.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement()).append("\n\n");
        }
        return stringBuffer.toString();
    }

    public long getEffectiveSize() {
        Enumeration enumeration = this.frames.elements();
        long l = 0L;
        while (enumeration.hasMoreElements()) {
            ID3V2Frame iD3V2Frame = (ID3V2Frame)enumeration.nextElement();
            l += iD3V2Frame.getSize();
            l += 10L;
        }
        return l + 10L + (long)(this.header.hasFooter() ? 10 : 0);
    }

    public long getSize() {
        long l = this.header.getSize();
        if (l < 0L) {
            return this.getEffectiveSize();
        }
        return l;
    }

    public byte[] toByteArray() {
        int n;
        long l = this.getEffectiveSize();
        byte[] byArray = l < this.header.getSize() ? new byte[(int)this.header.getSize() + 10] : (this.header.getSize() < 8192L ? new byte[(int)this.getEffectiveSize() * 2] : new byte[(int)this.getEffectiveSize() + 16384]);
        byArray[0] = 73;
        byArray[1] = 68;
        byArray[2] = 51;
        byArray[3] = 3;
        byArray[4] = 0;
        byArray[5] = 0;
        byte[] byArray2 = Helper.synchsafe(byArray.length - 10, 4);
        for (n = 0; n < 4; ++n) {
            byArray[6 + n] = byArray2[n];
        }
        n = 10;
        Enumeration enumeration = this.frames.elements();
        while (enumeration.hasMoreElements()) {
            ID3V2Frame iD3V2Frame = (ID3V2Frame)enumeration.nextElement();
            if (!Configuration.keepAllFrames && !iD3V2Frame.containsData()) continue;
            byte[] byArray3 = iD3V2Frame.toByteArray();
            OutputCtr.println(4, "Frame " + iD3V2Frame.getFrameID() + " size: " + byArray3.length);
            System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
            n += byArray3.length;
        }
        return byArray;
    }
}

