/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Defines;
import de.ueberdosis.mp3info.UndersizedException;
import de.ueberdosis.mp3info.id3v2.Header;
import de.ueberdosis.mp3info.id3v2.ID3V2Tag;
import de.ueberdosis.util.OutputCtr;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3V2Writer
implements Defines {
    public static void writeTag(File file, ID3V2Tag iD3V2Tag) throws IOException {
        RandomAccessFile randomAccessFile;
        block8: {
            if (iD3V2Tag == null) {
                OutputCtr.println(0, "Can't write null-Tag!");
                return;
            }
            randomAccessFile = new RandomAccessFile(file, "rw");
            byte[] byArray = new byte[3];
            randomAccessFile.seek(0L);
            randomAccessFile.read(byArray);
            if (new String(byArray).equalsIgnoreCase("ID3")) {
                try {
                    randomAccessFile.seek(0L);
                    byArray = new byte[10];
                    randomAccessFile.read(byArray);
                    Header header = new Header(byArray);
                    long l = header.getSize() + 10L;
                    if (iD3V2Tag.getEffectiveSize() <= l) {
                        byArray = iD3V2Tag.toByteArray();
                        if ((long)byArray.length <= l) {
                            randomAccessFile.seek(0L);
                            randomAccessFile.write(byArray);
                        } else {
                            ID3V2Writer.copyWrite(randomAccessFile, file, iD3V2Tag, l);
                        }
                        break block8;
                    }
                    ID3V2Writer.copyWrite(randomAccessFile, file, iD3V2Tag, l);
                }
                catch (UndersizedException undersizedException) {
                    undersizedException.printStackTrace();
                }
            } else {
                ID3V2Writer.copyWrite(randomAccessFile, file, iD3V2Tag, 0L);
            }
        }
        randomAccessFile.close();
    }

    private static void copyWrite(RandomAccessFile randomAccessFile, File file, ID3V2Tag iD3V2Tag, long l) throws IOException {
        File file2 = ID3V2Writer.getParentFile(file);
        OutputCtr.println(3, "Path: " + file2);
        File file3 = ID3V2Writer.createTempFile("mp3info_", ".mp3", file2);
        RandomAccessFile randomAccessFile2 = new RandomAccessFile(file3, "rw");
        randomAccessFile2.seek(0L);
        byte[] byArray = iD3V2Tag.toByteArray();
        OutputCtr.println(2, "tagsize: " + iD3V2Tag.getEffectiveSize() + " arraysize: " + byArray.length);
        randomAccessFile2.write(byArray);
        randomAccessFile.seek(l);
        byte[] byArray2 = new byte[16384];
        int n = randomAccessFile.read(byArray2);
        while (n > -1) {
            randomAccessFile2.write(byArray2, 0, n);
            n = randomAccessFile.read(byArray2);
        }
        randomAccessFile2.close();
        randomAccessFile2 = null;
        randomAccessFile.close();
        String string = file.getPath();
        file.delete();
        file3.renameTo(new File(string));
    }

    private static File getParentFile(File file) {
        String string = file.getParent();
        if (string == null) {
            return null;
        }
        try {
            return ID3V2Writer.getCanonicalFile(new File(string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static File getCanonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    private static File createTempFile(String string, String string2, File file) throws IOException {
        String string3 = "";
        for (int i = 0; i < 1000; ++i) {
            string3 = string + i + string2;
            File file2 = new File(file, string3);
            if (file2.exists()) continue;
            return file2;
        }
        throw new IOException("Couldn't create file \"" + file + string3 + "\"!");
    }
}

