/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main;

import BasicBackup.main.MainGUI.MainGUI;
import BasicBackup.main.TextBackup.TextBackup;
import BasicBackup.main.core.Core;
import BasicBackup.main.core.ResAssignment;
import java.io.File;

public class BasicBackup {
    public static int UI_GUI = 1;
    public static int UI_TEXTBACKUP = 2;

    public static void main(String[] args) {
        int backupUI = UI_GUI;
        boolean autoBackup = false;
        Core core = new Core();
        if (core.InitCore() < 0) {
            System.exit(1);
        }
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase(ResAssignment.START_PARAM_OPEN)) {
                    if (core.getLicenseType() > Core.LICENSE_PERSONAL) {
                        if (++i >= args.length) {
                            System.exit(1);
                        }
                        core.OpenProject(args[i]);
                    }
                }
                if (args[i].equalsIgnoreCase(ResAssignment.START_PARAM_LANG)) {
                    if (++i >= args.length) {
                        System.exit(1);
                    }
                    if (args[i].equalsIgnoreCase(ResAssignment.START_PARAM_LANG_1)) {
                        core.getOptions().setLanguage(1);
                        core.getOptions().WriteOptions();
                    }
                    if (args[i].equalsIgnoreCase(ResAssignment.START_PARAM_LANG_2)) {
                        core.getOptions().setLanguage(2);
                        core.getOptions().WriteOptions();
                    }
                }
                if (args[i].equalsIgnoreCase(ResAssignment.START_PARAM_TEXTBACKUP)) {
                    backupUI = UI_TEXTBACKUP;
                }
                if (!args[i].equalsIgnoreCase(ResAssignment.START_PARAM_AUTOBACKUP)) continue;
                autoBackup = true;
            }
        }
        if (core.getLicenseType() == Core.LICENSE_PERSONAL && new File(ResAssignment.LICENSE_DEFAULT_PROJECT).exists()) {
            core.OpenProject("---");
        }
        if (backupUI == UI_GUI) {
            MainGUI mainGUI = new MainGUI(core);
            mainGUI.setVisible(true);
            try {
                Thread.sleep(ResAssignment.PARAM_WAIT_REFRESH);
            }
            catch (InterruptedException e) {
                System.out.println("Exception: " + e);
            }
            mainGUI.ArrangeWindows();
            if (autoBackup) {
                mainGUI.menu_backup_execute.doClick();
            }
        }
        if (backupUI == UI_TEXTBACKUP) {
            TextBackup myTextBackup = new TextBackup(core);
            myTextBackup.start();
        }
    }
}

