/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.MainGUI;

import BasicBackup.main.MainGUI.MainGUI;
import BasicBackup.main.core.Core;
import BasicBackup.main.core.ResAssignment;
import BasicBackup.main.project.BackupThread;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class GUIBackupThread
extends Thread {
    private boolean myMarker = false;
    private Core core = null;
    private JDialog dialog = null;
    private BackupThread backup = null;
    private MainGUI gui = null;

    public GUIBackupThread(Core theCore, MainGUI theGui, BackupThread theBackup, JDialog theDialog) {
        this.core = theCore;
        this.dialog = theDialog;
        this.backup = theBackup;
        this.gui = theGui;
    }

    public void setMarker() {
        this.myMarker = true;
    }

    public void run() {
        JLabel fileLabel = new JLabel(this.gui.getLangText(18, 1));
        JLabel byteLabel = new JLabel(this.gui.getLangText(18, 2));
        JButton abortButton = new JButton(this.gui.getLangText(11, 6));
        abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIBackupThread.this.backup.Abort();
                GUIBackupThread.this.dialog.dispose();
            }
        });
        JProgressBar fileProgress = new JProgressBar(0, 0, 100);
        fileProgress.setStringPainted(true);
        JProgressBar byteProgress = new JProgressBar(0, 0, 100);
        byteProgress.setStringPainted(true);
        this.dialog.setLayout(new GridLayout(5, 1));
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.add(fileLabel);
        this.dialog.add(fileProgress);
        this.dialog.add(byteLabel);
        this.dialog.add(byteProgress);
        this.dialog.add(abortButton);
        while (true) {
            if (this.myMarker) {
                this.backup.Abort();
                return;
            }
            if (!this.core.getMiscData().getTmpBackup_ChangeInProgress()) {
                this.dialog.dispose();
                this.gui.UpdateProjectStatusWindow();
                return;
            }
            fileLabel.setText(this.gui.getLangText(18, 1) + " " + this.core.getMiscData().getTmpBackup_FileCount() + "/" + this.core.getCopyList().getFileCount());
            fileProgress.setValue(this.core.getMiscData().getTmpBackup_FileCount() * 100 / this.core.getCopyList().getFileCount());
            byteLabel.setText(this.gui.getLangText(18, 2) + " " + this.core.getMiscData().getTmpBackup_ByteCount() + "/" + this.core.getCopyList().getByteCount());
            byteProgress.setValue((int)(this.core.getMiscData().getTmpBackup_ByteCount() / (this.core.getCopyList().getByteCount() / 100L)));
            try {
                Thread.sleep(ResAssignment.PARAM_WAIT_REFRESH);
                continue;
            }
            catch (InterruptedException e) {
                System.out.println("Exception: " + e);
                continue;
            }
            break;
        }
    }
}

