/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.MainGUI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLDialog
extends JFrame
implements HyperlinkListener {
    private JButton homeButton;
    private JTextField urlField;
    private JEditorPane htmlPane;
    private String initialURL;

    public HTMLDialog(String title, String initialURL) {
        super(title);
        this.initialURL = initialURL;
        try {
            this.htmlPane = new JEditorPane(initialURL);
            this.htmlPane.setEditable(false);
            this.htmlPane.addHyperlinkListener(this);
            JScrollPane scrollPane = new JScrollPane(this.htmlPane);
            this.getContentPane().add((Component)scrollPane, "Center");
        }
        catch (IOException ioe) {
            this.warnUser("Can't build HTML pane for " + initialURL + ": " + ioe);
        }
        Dimension screenSize = this.getToolkit().getScreenSize();
        int width = 800;
        int height = 600;
        this.setBounds(width / 8, height / 8, width, height);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        String url = event.getSource() == this.urlField ? this.urlField.getText() : this.initialURL;
        try {
            this.htmlPane.setPage(new URL(url));
            this.urlField.setText(url);
        }
        catch (IOException ioe) {
            this.warnUser("Can't follow link to " + url + ": " + ioe);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlPane.setPage(event.getURL());
            }
            catch (IOException ioe) {
                this.warnUser("Can't follow link to " + event.getURL().toExternalForm() + ": " + ioe);
            }
        }
    }

    private void warnUser(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }
}

