/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.MainGUI;

import BasicBackup.main.project.ProjectItem;
import javax.swing.tree.DefaultMutableTreeNode;

public class PTreeNode
extends DefaultMutableTreeNode {
    public static int NODE_TYPE_ROOT = 0;
    public static int NODE_TYPE_DIR = 1;
    public static int NODE_TYPE_FILE = 2;
    private ProjectItem pItem = null;

    public PTreeNode(ProjectItem nodeItem) {
        this.pItem = nodeItem;
    }

    public void BuildTree() {
        this.removeAllChildren();
        if (this.pItem.getChildCount() > 0) {
            PTreeNode myNode = null;
            for (int i = 1; i <= this.pItem.getChildCount(); ++i) {
                myNode = new PTreeNode(this.pItem.getChild(i));
                this.add(myNode);
                myNode.BuildTree();
            }
        }
    }

    public void UpdateTree() {
        this.BuildTree();
    }

    public String toString() {
        if (this.pItem.IsRoot()) {
            return "---> " + this.pItem.getProjectFileName();
        }
        if (this.pItem.IsDirectory()) {
            if (this.pItem.getContentText().indexOf(":") >= 0) {
                return this.pItem.getContentText();
            }
            String myString = "[";
            myString = this.pItem.getIncludeFiles() ? myString.concat("F") : myString.concat("-");
            myString = myString.concat("|");
            myString = this.pItem.getIncludeSubdirs() ? myString.concat("R") : myString.concat("-");
            return myString + "]: " + this.pItem.getContentText();
        }
        return "[FILE]: " + this.pItem.getContentText();
    }

    public int getNodeType() {
        if (this.pItem == null) {
            return -1;
        }
        if (this.pItem.IsRoot()) {
            return NODE_TYPE_ROOT;
        }
        if (this.pItem.IsDirectory()) {
            return NODE_TYPE_DIR;
        }
        return NODE_TYPE_FILE;
    }

    public String getInternalName() {
        return this.pItem.getContentText();
    }

    public void Delete() {
        this.pItem.Delete();
    }

    public ProjectItem getInternalItem() {
        return this.pItem;
    }
}

