/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.TextBackup;

import BasicBackup.main.core.Core;
import BasicBackup.main.core.ResAssignment;
import BasicBackup.main.project.BackupThread;
import BasicBackup.main.project.CollectorThread;
import MITTools.Lang.LangContainer;

public class TextBackup
extends Thread {
    private Core core = null;
    private LangContainer langTxtBackup = null;

    public TextBackup(Core theCore) {
        this.core = theCore;
        this.langTxtBackup = new LangContainer();
        this.langTxtBackup.InitContainer(ResAssignment.TXT_BACKUP_LANG);
    }

    private String getLangText(int section, int pos) {
        return this.langTxtBackup.GetEntry(section, pos, this.core.getOptions().getLanguage());
    }

    public void run() {
        if (this.core.getOpenProject() == null) {
            System.out.println(this.core.getTimestamp() + this.getLangText(1, 1));
            return;
        }
        System.out.println(this.core.getTimestamp() + this.getLangText(1, 2) + " " + this.core.getOpenProject().getProjectFilePath());
        System.out.println(this.core.getTimestamp() + this.getLangText(1, 3));
        CollectorThread myCollector = this.core.CollectProjectCopyData();
        try {
            Thread.sleep(ResAssignment.PARAM_WAIT_REFRESH);
        }
        catch (InterruptedException e) {
            System.out.println("Exception: " + e);
        }
        String myString = null;
        int p1 = 0;
        long p2 = 0L;
        while (this.core.getMiscData().getTmpCopyList_ChangeInProgress()) {
            myString = this.core.getLogLine();
            while (myString != null) {
                System.out.println(myString);
                myString = this.core.getLogLine();
            }
            System.out.println(this.core.getTimestamp() + this.core.getMiscData().getTmpCopyList_FileCount() + " " + this.getLangText(2, 1) + " " + this.core.getMiscData().getTmpCopyList_ByteCount() / 1024L + " " + this.getLangText(2, 2));
            try {
                Thread.sleep(2 * ResAssignment.PARAM_WAIT_REFRESH);
            }
            catch (InterruptedException e) {
                System.out.println("Exception: " + e);
            }
        }
        myString = this.core.getLogLine();
        while (myString != null) {
            System.out.println(myString);
            myString = this.core.getLogLine();
        }
        System.out.println(this.core.getTimestamp() + this.getLangText(1, 4));
        BackupThread myBackup = this.core.ExecuteBackup();
        try {
            Thread.sleep(ResAssignment.PARAM_WAIT_REFRESH);
        }
        catch (InterruptedException e) {
            System.out.println("Exception: " + e);
        }
        while (this.core.getMiscData().getTmpBackup_ChangeInProgress()) {
            myString = this.core.getLogLine();
            while (myString != null) {
                System.out.println(myString);
                myString = this.core.getLogLine();
            }
            p1 = this.core.getMiscData().getTmpBackup_FileCount() * 100 / this.core.getCopyList().getFileCount();
            p2 = this.core.getMiscData().getTmpBackup_ByteCount() * 100L / this.core.getCopyList().getByteCount();
            System.out.println(this.core.getTimestamp() + this.core.getMiscData().getTmpBackup_FileCount() + " " + this.getLangText(3, 1) + p1 + this.getLangText(3, 2) + " " + this.core.getMiscData().getTmpBackup_ByteCount() / 1024L + " " + this.getLangText(3, 3) + p2 + this.getLangText(3, 4));
            try {
                Thread.sleep(4 * ResAssignment.PARAM_WAIT_REFRESH);
            }
            catch (InterruptedException e) {
                System.out.println("Exception: " + e);
            }
        }
        myString = this.core.getLogLine();
        while (myString != null) {
            System.out.println(myString);
            myString = this.core.getLogLine();
        }
    }
}

