/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.core;

import BasicBackup.main.core.MiscDataStorage;
import BasicBackup.main.core.Options;
import BasicBackup.main.core.ResAssignment;
import BasicBackup.main.project.BackupThread;
import BasicBackup.main.project.CollectorThread;
import BasicBackup.main.project.CopyList;
import BasicBackup.main.project.Project;
import MITTools.Lang.LangContainer;
import MITTools.License.License.LicenseCodeBasic1;
import java.util.Date;
import java.util.Vector;

public class Core {
    private Options options = null;
    private MiscDataStorage myTmpDataStorage = null;
    private LicenseCodeBasic1 license = null;
    private int licenseVersion = 0;
    private Project project = null;
    private Vector logLines = null;
    private LangContainer logMessages = null;
    private CopyList internalCopyList = null;
    public static int LICENSE_PERSONAL = 0;
    public static int LICENSE_FULL = 1;

    public boolean IsLicenseExpired() {
        if (this.license.getLicenseValI1() > ResAssignment.APP_BUILD_YEAR) {
            return false;
        }
        if (this.license.getLicenseValI1() < ResAssignment.APP_BUILD_YEAR) {
            return true;
        }
        if (this.license.getLicenseValI2() > ResAssignment.APP_BUILD_MONTH) {
            return false;
        }
        if (this.license.getLicenseValI2() < ResAssignment.APP_BUILD_MONTH) {
            return true;
        }
        return this.license.getLicenseValI3() < ResAssignment.APP_BUILD_DAY;
    }

    public int InitCore() {
        this.options = new Options();
        this.myTmpDataStorage = new MiscDataStorage();
        this.license = new LicenseCodeBasic1();
        this.license.setLicenseFile(ResAssignment.LICENSE_FILE);
        this.license.setAppCode(ResAssignment.LICENSE_KEY);
        if (this.license.getLicenseFile_present()) {
            if (this.license.DecodeLicense() < 0) {
                System.out.println("invalid license file");
                return -1;
            }
            if (!this.license.getLicenseFile_decoded()) {
                System.out.println("invalid license file");
                return -1;
            }
            this.licenseVersion = this.license.getLicenseValI6();
            if (!this.license.getCheckString1().equalsIgnoreCase(ResAssignment.LICENSE_VALID_1)) {
                System.out.println("invalid license file");
                return -1;
            }
            if (this.IsLicenseExpired()) {
                System.out.println("License expired");
                System.out.println("App build: " + ResAssignment.APP_BUILD_YEAR + "-" + ResAssignment.APP_BUILD_MONTH + "-" + ResAssignment.APP_BUILD_DAY);
                System.out.println("License expired: " + this.license.getLicenseValI1() + "-" + this.license.getLicenseValI2() + "-" + this.license.getLicenseValI3());
                return -1;
            }
        } else {
            this.licenseVersion = LICENSE_PERSONAL;
        }
        this.logMessages = new LangContainer();
        this.logMessages.InitContainer(ResAssignment.LOG_TEXT_LANG);
        return 0;
    }

    public LicenseCodeBasic1 getLicense() {
        return this.license;
    }

    public int getLicenseType() {
        return this.licenseVersion;
    }

    public Options getOptions() {
        return this.options;
    }

    public MiscDataStorage getMiscData() {
        return this.myTmpDataStorage;
    }

    public Project getOpenProject() {
        return this.project;
    }

    public void setCopyList(CopyList list) {
        this.internalCopyList = list;
    }

    public CopyList getCopyList() {
        return this.internalCopyList;
    }

    public int OpenProject(String projectName) {
        this.logLines = new Vector();
        if (projectName == null) {
            this.project = new Project(this);
            this.internalCopyList = null;
            this.AddLogLine(this.getTimestamp() + this.logMessages.GetEntry(1, 1, this.getOptions().getLanguage()));
            return 1;
        }
        this.project = new Project(this);
        this.internalCopyList = null;
        int status = -1;
        if (this.getLicenseType() > LICENSE_PERSONAL) {
            status = this.project.Open(projectName);
        }
        if (this.getLicenseType() == LICENSE_PERSONAL) {
            status = this.project.Open(ResAssignment.LICENSE_DEFAULT_PROJECT);
        }
        if (status == 0) {
            this.AddLogLine(this.getTimestamp() + this.logMessages.GetEntry(1, 6, this.getOptions().getLanguage()) + " " + projectName);
        } else {
            this.AddLogLine(this.getTimestamp() + this.logMessages.GetEntry(1, 7, this.getOptions().getLanguage()) + " " + projectName);
            this.project = null;
        }
        return status;
    }

    public void CloseProject() {
        this.project = null;
    }

    public int SaveProject(String destination) {
        int status = -1;
        if (this.getLicenseType() > LICENSE_PERSONAL) {
            status = this.project.Save(destination);
        }
        if (this.getLicenseType() == LICENSE_PERSONAL) {
            status = this.project.Save(ResAssignment.LICENSE_DEFAULT_PROJECT);
        }
        if (status == 0) {
            this.AddLogLine(this.getTimestamp() + this.logMessages.GetEntry(1, 2, this.getOptions().getLanguage()) + " " + this.project.getProjectName());
        } else {
            this.AddLogLine(this.getTimestamp() + this.logMessages.GetEntry(1, 3, this.getOptions().getLanguage()));
        }
        return status;
    }

    public void AddLogLine(String line) {
        if (this.logLines == null) {
            return;
        }
        if (this.project == null) {
            return;
        }
        this.logLines.add(line);
        this.project.addLogLine(line);
    }

    public String getLogCreateText(int section, int pos) {
        return this.getTimestamp() + this.logMessages.GetEntry(section, pos, this.getOptions().getLanguage());
    }

    public String getLogText(int section, int pos) {
        return this.logMessages.GetEntry(section, pos, this.getOptions().getLanguage());
    }

    public String getTimestamp() {
        return new Date() + " : ";
    }

    public String getLogLine() {
        if (this.logLines == null) {
            return null;
        }
        if (this.logLines.size() > 0) {
            String myString = (String)this.logLines.elementAt(0);
            this.logLines.remove(0);
            return myString;
        }
        return null;
    }

    public CollectorThread CollectProjectCopyData() {
        if (this.getOpenProject() == null) {
            return null;
        }
        this.internalCopyList = null;
        CollectorThread myCollector = new CollectorThread(this, this.getOpenProject());
        myCollector.start();
        return myCollector;
    }

    public BackupThread ExecuteBackup() {
        if (this.getOpenProject() == null) {
            return null;
        }
        if (this.internalCopyList == null) {
            return null;
        }
        BackupThread myBackup = new BackupThread(this);
        myBackup.start();
        return myBackup;
    }
}

