/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.core;

import BasicBackup.main.core.ResAssignment;
import MITTools.Files.TextFiles.TextFileReader;
import MITTools.Files.TextFiles.TextFileWriter;
import java.util.Locale;

public class Options {
    private int language;

    public Options() {
        this.InitOptions();
    }

    public int InitOptions() {
        TextFileReader optionReader = new TextFileReader();
        if (optionReader.ReadFile(ResAssignment.CORE_OPTIONS_DIR + "/" + ResAssignment.CORE_OPTIONS_CONFIG) < 0) {
            System.out.println("\nCould not find config-file. Create new file from default values!\n\n");
            this.InitDefaultOptions();
            this.WriteOptions();
            return 1;
        }
        if (optionReader.GetSize() < 1) {
            return -1;
        }
        for (int i = 1; i <= optionReader.GetSize(); ++i) {
            if (!(optionReader.ReadLine(i) != null & !optionReader.ReadLine(i).equalsIgnoreCase("")) || !optionReader.GetCSVStringPartOfLine(i, 1).equalsIgnoreCase("AppLanguage")) continue;
            this.language = Integer.parseInt(optionReader.GetCSVStringPartOfLine(i, 2));
        }
        return 0;
    }

    public int InitDefaultOptions() {
        this.language = 2;
        if (Locale.getDefault().getLanguage() == "de") {
            this.language = 1;
        }
        return 0;
    }

    public int WriteOptions() {
        TextFileWriter optionWriter = new TextFileWriter(ResAssignment.CORE_OPTIONS_DIR + "/" + ResAssignment.CORE_OPTIONS_CONFIG);
        optionWriter.addLine("Configuration file for BASIC BACKUP by Tobias Meuschke IT");
        optionWriter.addLine("");
        optionWriter.addLine("This file was created and is maintained automatically.");
        optionWriter.addLine("Do not mess with it unless you are exactly sure what you are doing.");
        optionWriter.addLine("Manual changes to this file may damage your system !!!");
        optionWriter.addLine("");
        optionWriter.addLine("Dieses File wurde automatisch erstellt und wird ebenso ver\u00e4ndert.");
        optionWriter.addLine("\u00c4ndern Sie auf keinen Fall den Inhalt.");
        optionWriter.addLine("Manuelle Ver\u00e4nderungen dieses Files k\u00f6nnen zu Systemsch\u00e4den f\u00fchren.");
        optionWriter.addLine("");
        optionWriter.addLine("");
        optionWriter.addLine("");
        optionWriter.addLine("[GENERAL]");
        optionWriter.addLine("AppLanguage;" + this.language + ";x");
        optionWriter.addLine("");
        optionWriter.addLine("");
        optionWriter.addLine("");
        optionWriter.WriteFile();
        return 0;
    }

    public void setLanguage(int lang) {
        this.language = lang;
        Locale.setDefault(new Locale("en", "US"));
        if (this.language == 1) {
            Locale.setDefault(new Locale("de", "DE"));
        }
    }

    public int getLanguage() {
        return this.language;
    }

    public Locale getLanguageLocale() {
        if (this.language == 1) {
            return new Locale("de", "DE");
        }
        if (this.language == 2) {
            return new Locale("en", "US");
        }
        return Locale.getDefault();
    }
}

