/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.project;

import BasicBackup.main.core.Core;
import BasicBackup.main.core.ResAssignment;
import MITTools.Files.TextFiles.TextFileWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.GregorianCalendar;

public class BackupThread
extends Thread {
    private boolean abort = false;
    private Core core = null;
    private TextFileWriter backupLog = null;

    public BackupThread(Core theCore) {
        this.core = theCore;
    }

    public void Abort() {
        this.abort = true;
    }

    public void AbortCode() {
        this.core.getMiscData().setTmpBackup_ChangeInProgress(false);
        this.core.AddLogLine(this.core.getLogCreateText(2, 9));
    }

    public void run() {
        int errorCount = 0;
        if (this.core.getMiscData().getTmpBackup_ChangeInProgress()) {
            return;
        }
        if (this.core.getCopyList() == null) {
            return;
        }
        this.core.getMiscData().setTmpBackup_FileCount(0);
        this.core.getMiscData().setTmpBackup_ByteCount(0L);
        this.core.getMiscData().setTmpBackup_ChangeInProgress(true);
        this.backupLog = new TextFileWriter();
        GregorianCalendar myCalendar = new GregorianCalendar();
        String destBody = new String(this.core.getOpenProject().getBackupStoreLocation().getAbsolutePath() + "/" + myCalendar.get(1) + "-" + (myCalendar.get(2) + 1) + "-" + myCalendar.get(5));
        File tmpFile = new File(destBody);
        if (tmpFile.exists()) {
            int count = 1;
            while (tmpFile.exists()) {
                tmpFile = new File(destBody + "(" + count + ")");
                ++count;
            }
            destBody = destBody.concat("(" + --count + ")");
        }
        destBody = destBody.concat("/");
        File sourceFile = null;
        File destFile = null;
        if (this.core.getCopyList().getRealFileCount() > 0) {
            this.core.AddLogLine(this.core.getLogCreateText(2, 8));
            this.backupLog.addLine(this.core.getLogCreateText(2, 8));
            for (int i = 1; i <= this.core.getCopyList().getRealFileCount(); ++i) {
                if (this.abort) {
                    this.AbortCode();
                    return;
                }
                sourceFile = this.core.getCopyList().getFile(i);
                if (sourceFile == null) {
                    this.AbortCode();
                    return;
                }
                destFile = new File(destBody + sourceFile.getAbsolutePath().replace(":", ""));
                try {
                    boolean status;
                    this.backupLog.addLine(this.core.getTimestamp() + "copy " + sourceFile.getAbsolutePath() + " ---> " + destFile.getAbsolutePath() + " (" + sourceFile.length() + " bytes)");
                    if (!destFile.getParentFile().exists() && !(status = destFile.getParentFile().mkdirs())) {
                        this.core.AddLogLine(this.core.getLogCreateText(2, 10) + " " + destFile.getParentFile().getAbsolutePath());
                        this.backupLog.addLine(this.core.getLogCreateText(2, 10) + " " + destFile.getParentFile().getAbsolutePath());
                        ++errorCount;
                    }
                    FileChannel srcChannel = new FileInputStream(sourceFile).getChannel();
                    FileChannel dstChannel = new FileOutputStream(destFile).getChannel();
                    long done = 0L;
                    long act = 0L;
                    for (long rest = sourceFile.length(); rest > 0L; rest -= act) {
                        act = rest > ResAssignment.PARAM_SIZE_COPY ? ResAssignment.PARAM_SIZE_COPY : rest;
                        dstChannel.transferFrom(srcChannel, done, act);
                        this.core.getMiscData().incTmpBackup_ByteCount(act);
                        done += act;
                    }
                    srcChannel.close();
                    dstChannel.close();
                    this.core.getMiscData().incTmpBackup_FileCount(1);
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Exception: " + e);
                    this.core.AddLogLine(this.core.getLogCreateText(2, 11) + " " + sourceFile.getAbsolutePath());
                    this.core.AddLogLine(this.core.getTimestamp() + "Exception: " + e);
                    this.backupLog.addLine(this.core.getLogCreateText(2, 11) + " " + sourceFile.getAbsolutePath());
                    this.backupLog.addLine(this.core.getTimestamp() + "Exception: " + e);
                    ++errorCount;
                }
            }
        }
        this.core.AddLogLine(this.core.getLogCreateText(2, 12));
        this.core.AddLogLine(this.core.getTimestamp() + this.core.getMiscData().getTmpBackup_FileCount() + " " + this.core.getLogText(2, 4) + " (" + this.core.getMiscData().getTmpBackup_ByteCount() + " bytes) " + this.core.getLogText(2, 13));
        this.core.AddLogLine(this.core.getLogCreateText(2, 14) + " " + errorCount + " " + this.core.getLogText(2, 15));
        this.backupLog.addLine(this.core.getLogCreateText(2, 12));
        this.backupLog.addLine(this.core.getTimestamp() + this.core.getMiscData().getTmpBackup_FileCount() + " " + this.core.getLogText(2, 4) + " (" + this.core.getMiscData().getTmpBackup_ByteCount() + " bytes) " + this.core.getLogText(2, 13));
        this.backupLog.addLine(this.core.getLogCreateText(2, 14) + " " + errorCount + " " + this.core.getLogText(2, 15));
        File logDumpFile = new File(destBody + ResAssignment.PROJECT_FILENAME_LOG_PROJECT);
        File backupDumpFile = new File(destBody + ResAssignment.PROJECT_FILENAME_LOG_BACKUP);
        this.core.AddLogLine(this.core.getLogCreateText(2, 16) + " " + backupDumpFile.getAbsolutePath());
        this.backupLog.setFile(backupDumpFile);
        this.backupLog.addLine(this.core.getLogCreateText(2, 16) + " " + backupDumpFile.getAbsolutePath());
        this.backupLog.WriteFile();
        this.core.AddLogLine(this.core.getLogCreateText(2, 17) + " " + logDumpFile.getAbsolutePath());
        this.core.getOpenProject().dumpLog(logDumpFile);
        this.core.getMiscData().setTmpBackup_ChangeInProgress(false);
    }
}

