/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.project;

import BasicBackup.main.core.Core;
import BasicBackup.main.project.CopyList;
import BasicBackup.main.project.Project;

public class CollectorThread
extends Thread {
    private boolean abort = false;
    private Core core = null;
    private Project project = null;
    private CopyList myCopyList = null;

    public CollectorThread(Core theCore, Project theProject) {
        this.core = theCore;
        this.project = theProject;
    }

    public void Abort() {
        this.abort = true;
        if (this.myCopyList != null) {
            this.myCopyList.Abort();
        }
    }

    public void run() {
        if (this.core.getMiscData().getTmpCopyList_ChangeInProgress()) {
            return;
        }
        this.core.getMiscData().setTmpCopyList_ByteCount(0L);
        this.core.getMiscData().setTmpCopyList_FileCount(0);
        this.core.getMiscData().setTmpCopyList_ChangeInProgress(true);
        this.myCopyList = new CopyList();
        if (this.project.GenerateCopyList(this.myCopyList) != 0) {
            this.core.getMiscData().setTmpCopyList_ChangeInProgress(false);
            return;
        }
        this.myCopyList.setFileCount(this.core.getMiscData().getTmpCopyList_FileCount());
        this.myCopyList.setByteCount(this.core.getMiscData().getTmpCopyList_ByteCount());
        this.core.setCopyList(this.myCopyList);
        this.core.AddLogLine(this.core.getLogCreateText(2, 3));
        this.core.AddLogLine(this.core.getTimestamp() + this.myCopyList.getFileCount() + " " + this.core.getLogText(2, 4) + " (" + this.myCopyList.getByteCount() + " bytes) " + this.core.getLogText(2, 5));
        this.core.AddLogLine(this.core.getLogCreateText(2, 6) + " " + this.myCopyList.getErrorCount() + " " + this.core.getLogText(2, 7));
        this.core.getMiscData().setTmpCopyList_ChangeInProgress(false);
    }
}

