/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.project;

import BasicBackup.main.core.Core;
import BasicBackup.main.core.ResAssignment;
import BasicBackup.main.project.CopyList;
import BasicBackup.main.project.ProjectItem;
import BasicBackup.main.project.SlashSplitter;
import MITTools.Files.TextFiles.TextFileReader;
import MITTools.Files.TextFiles.TextFileWriter;
import java.io.File;
import java.util.Date;

public class Project {
    public static String UNNAMED_PROJECT = "unnamed";
    private boolean projectChanged = false;
    private int itemIdCounter = 0;
    private ProjectItem itemRoot = null;
    private String projectName = UNNAMED_PROJECT;
    private String projectFullLocation = null;
    private Core appCore = null;
    private File backupStoreLocation = null;
    private TextFileWriter logFile = null;

    public Project(Core core) {
        this.appCore = core;
        this.itemRoot = new ProjectItem(this.itemIdCounter, this.appCore, null);
        this.itemRoot.RootSetup();
        this.logFile = new TextFileWriter();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectFileName() {
        if (this.projectFullLocation == null) {
            return UNNAMED_PROJECT;
        }
        return new File(this.projectFullLocation).getName();
    }

    public String getProjectFilePath() {
        if (this.projectFullLocation == null) {
            return UNNAMED_PROJECT;
        }
        return new File(this.projectFullLocation).getAbsolutePath();
    }

    public void Change() {
        this.projectChanged = true;
    }

    public boolean isChanged() {
        return this.projectChanged;
    }

    public ProjectItem getProjectRoot() {
        return this.itemRoot;
    }

    public int getItemIdCount() {
        return this.itemIdCounter;
    }

    public int RequestItemID() {
        ++this.itemIdCounter;
        return this.itemIdCounter;
    }

    public void setBackupStoreLocation(File backupDir) {
        this.backupStoreLocation = backupDir;
    }

    public File getBackupStoreLocation() {
        return this.backupStoreLocation;
    }

    public int Save(String destination) {
        if (destination != null) {
            File tmpFile = new File(destination);
            this.projectName = tmpFile.getName().replace(".bbp", "");
            this.projectFullLocation = tmpFile.getAbsolutePath();
        }
        TextFileWriter projectWriter = new TextFileWriter(this.projectFullLocation);
        projectWriter.addLine("Project file for BASIC BACKUP by Tobias Meuschke IT");
        projectWriter.addLine("");
        projectWriter.addLine("File Version: 1.0");
        projectWriter.addLine("Basic Backup Version: " + ResAssignment.APP_VERSION + "." + ResAssignment.APP_BUILD + " " + ResAssignment.APP_SUFFIX);
        projectWriter.addLine("Last modified: " + new Date());
        projectWriter.addLine("");
        projectWriter.addLine("This file was created and is maintained automatically.");
        projectWriter.addLine("Do not mess with it unless you are exactly sure what you are doing.");
        projectWriter.addLine("Manual changes to this file may damage your system !!!");
        projectWriter.addLine("");
        projectWriter.addLine("Dieses File wurde automatisch erstellt und wird ebenso ver\u00e4ndert.");
        projectWriter.addLine("\u00c4ndern Sie auf keinen Fall den Inhalt.");
        projectWriter.addLine("Manuelle Ver\u00e4nderungen dieses Files k\u00f6nnen zu Systemsch\u00e4den f\u00fchren.");
        projectWriter.addLine("");
        projectWriter.addLine("[GENERAL DATA]");
        if (this.getBackupStoreLocation() != null) {
            projectWriter.addLine("storelocation;" + this.getBackupStoreLocation().getAbsolutePath() + ";x");
        }
        projectWriter.addLine("");
        if (this.itemRoot != null && this.itemRoot.SaveItem(projectWriter) != 0) {
            return -1;
        }
        projectWriter.addLine("");
        projectWriter.addLine("");
        int status = projectWriter.WriteFile();
        if (status == 0) {
            this.projectChanged = false;
            return 0;
        }
        this.projectChanged = false;
        return -1;
    }

    public int Open(String destination) {
        if (destination == null) {
            return -1;
        }
        File tmpFile = new File(destination);
        this.projectName = tmpFile.getName().replace(".bbp", "");
        this.projectFullLocation = tmpFile.getAbsolutePath();
        TextFileReader projectReader = new TextFileReader();
        projectReader.ReadFile(destination);
        this.itemRoot = null;
        if (projectReader.GetSize() < 1) {
            return -1;
        }
        int curLine = 1;
        String curString = null;
        curString = projectReader.ReadLine(curLine);
        while (curLine <= projectReader.GetSize()) {
            if (curString.equalsIgnoreCase("[GENERAL DATA]")) {
                curString = projectReader.ReadLine(++curLine);
                while (!projectReader.EmptyLine(curString) & curLine <= projectReader.GetSize()) {
                    if (projectReader.GetCSVStringPart(curString, 1).equalsIgnoreCase("storelocation")) {
                        File myFile = new File(projectReader.GetCSVStringPart(curString, 2));
                        if (myFile == null) {
                            return -1;
                        }
                        this.setBackupStoreLocation(myFile);
                    }
                    curString = projectReader.ReadLine(++curLine);
                }
            }
            if (curString.equalsIgnoreCase("[NODE]")) {
                curString = projectReader.ReadLine(++curLine);
                ProjectItem myItem = null;
                ProjectItem myItemParent = null;
                int myItemParentID = 0;
                int myItemID = -1;
                while (!projectReader.EmptyLine(curString) & curLine <= projectReader.GetSize()) {
                    if (projectReader.GetCSVStringPart(curString, 1).equalsIgnoreCase("id")) {
                        try {
                            myItemID = Integer.parseInt(projectReader.GetCSVStringPart(curString, 2));
                        }
                        catch (Exception e) {
                            return -1;
                        }
                        if (myItemID == 0) {
                            myItem = new ProjectItem(myItemID, this.appCore, null);
                            myItem.RootSetup();
                            this.itemRoot = myItem;
                        }
                        if (myItemID > this.itemIdCounter) {
                            this.itemIdCounter = myItemID;
                        }
                    }
                    if (projectReader.GetCSVStringPart(curString, 1).equalsIgnoreCase("parent")) {
                        try {
                            myItemParentID = Integer.parseInt(projectReader.GetCSVStringPart(curString, 2));
                        }
                        catch (Exception e) {
                            return -1;
                        }
                        if (this.itemRoot == null) {
                            return -1;
                        }
                        myItemParent = this.itemRoot.getChildItem(myItemParentID);
                        if (myItemParent == null) {
                            return -1;
                        }
                        myItem = new ProjectItem(myItemID, this.appCore, myItemParent);
                        if (myItemParent.addChild(myItem) != 0) {
                            return -1;
                        }
                    }
                    if (projectReader.GetCSVStringPart(curString, 1).equalsIgnoreCase("text")) {
                        if (myItem == null) {
                            return -1;
                        }
                        int pos1 = 3;
                        String string1 = projectReader.GetCSVStringPart(curString, 2);
                        String string2 = null;
                        if (!string1.endsWith("\"")) {
                            boolean running = true;
                            while (running) {
                                string2 = projectReader.GetCSVStringPart(curString, pos1);
                                if (string2.equalsIgnoreCase("x")) {
                                    running = false;
                                    continue;
                                }
                                string1 = string1.concat(";").concat(string2);
                                ++pos1;
                                if (!string1.endsWith("\"")) continue;
                                running = false;
                            }
                        }
                        myItem.setContentText(string1.replace("\"", ""));
                    }
                    if (projectReader.GetCSVStringPart(curString, 1).equalsIgnoreCase("isdir")) {
                        if (myItem == null) {
                            return -1;
                        }
                        if (projectReader.GetCSVStringPart(curString, 2).equalsIgnoreCase("true")) {
                            myItem.setDirMarker(true);
                        }
                        if (projectReader.GetCSVStringPart(curString, 2).equalsIgnoreCase("false")) {
                            myItem.setDirMarker(false);
                        }
                    }
                    if (projectReader.GetCSVStringPart(curString, 1).equalsIgnoreCase("inclsubdirs")) {
                        if (myItem == null) {
                            return -1;
                        }
                        if (projectReader.GetCSVStringPart(curString, 2).equalsIgnoreCase("true")) {
                            myItem.setIncludeSubdirs(true);
                        }
                        if (projectReader.GetCSVStringPart(curString, 2).equalsIgnoreCase("false")) {
                            myItem.setIncludeSubdirs(false);
                        }
                    }
                    if (projectReader.GetCSVStringPart(curString, 1).equalsIgnoreCase("inclfiles")) {
                        if (myItem == null) {
                            return -1;
                        }
                        if (projectReader.GetCSVStringPart(curString, 2).equalsIgnoreCase("true")) {
                            myItem.setIncludeFiles(true);
                        }
                        if (projectReader.GetCSVStringPart(curString, 2).equalsIgnoreCase("false")) {
                            myItem.setIncludeFiles(false);
                        }
                    }
                    curString = projectReader.ReadLine(++curLine);
                }
            }
            curString = projectReader.ReadLine(++curLine);
        }
        if (this.itemRoot == null) {
            return -1;
        }
        this.projectChanged = false;
        this.projectFullLocation = destination;
        return 0;
    }

    public int AddItem(File itemToAdd) {
        SlashSplitter split = new SlashSplitter(itemToAdd.getAbsolutePath().replace("\\", "/"));
        if (this.itemRoot != null) {
            int status;
            if (this.appCore.getLicenseType() == Core.LICENSE_PERSONAL) {
                if (this.getLeafCount() >= ResAssignment.LICENSE_MAX_ITEMS) {
                    this.appCore.AddLogLine(this.appCore.getLogCreateText(3, 1) + " " + ResAssignment.LICENSE_MAX_ITEMS + " " + this.appCore.getLogText(3, 2));
                    return -1;
                }
                if (itemToAdd.isDirectory() && this.getSpecialDirCount() >= ResAssignment.LICENSE_MAX_SPECIAL_ITEMS) {
                    this.appCore.AddLogLine(this.appCore.getLogCreateText(3, 3) + " " + ResAssignment.LICENSE_MAX_SPECIAL_ITEMS + " " + this.appCore.getLogText(3, 4));
                    return -1;
                }
            }
            if ((status = this.itemRoot.InsertItem(split, 1, itemToAdd.isDirectory())) == 0) {
                this.appCore.AddLogLine(this.appCore.getLogCreateText(1, 4) + " " + itemToAdd.getAbsolutePath());
            } else {
                this.appCore.AddLogLine(this.appCore.getLogCreateText(1, 5) + " " + itemToAdd.getAbsolutePath());
            }
            return status;
        }
        return -1;
    }

    public int GenerateCopyList(CopyList theList) {
        if (this.itemRoot == null) {
            return -1;
        }
        return this.itemRoot.GenerateCopyList(theList, "");
    }

    public void addLogLine(String line) {
        this.logFile.addLine(line);
    }

    public void dumpLog(File destination) {
        this.logFile.setFile(destination);
        this.logFile.WriteFile();
    }

    public int getLeafCount() {
        if (this.itemRoot == null) {
            return 0;
        }
        return this.itemRoot.getLeafCount();
    }

    public int getSpecialDirCount() {
        if (this.itemRoot == null) {
            return 0;
        }
        return this.itemRoot.getSpecialDirCount();
    }
}

