/*
 * Decompiled with CFR 0.152.
 */
package BasicBackup.main.project;

import BasicBackup.main.core.Core;
import BasicBackup.main.core.ResAssignment;
import BasicBackup.main.project.CopyList;
import BasicBackup.main.project.SlashSplitter;
import MITTools.Files.TextFiles.TextFileWriter;
import java.io.File;
import java.util.Vector;

public class ProjectItem {
    private String contentItemString = null;
    private Vector internalItems = null;
    private Core appCore = null;
    private ProjectItem parentItem = null;
    private boolean isRoot = false;
    private boolean isDir = true;
    private boolean includeSubdirs = false;
    private boolean includeFiles = false;
    private int itemID = -1;
    private boolean isCorrectlyInitialised = false;

    public ProjectItem(int ID, Core core, ProjectItem parent) {
        this.appCore = core;
        this.parentItem = parent;
        this.itemID = ID;
        this.internalItems = new Vector();
    }

    public boolean IsRoot() {
        return this.isRoot;
    }

    public String getProjectFileName() {
        return this.appCore.getOpenProject().getProjectFileName();
    }

    public String getContentText() {
        return this.contentItemString;
    }

    public void setContentText(String newText) {
        this.contentItemString = newText;
    }

    public int getItemID() {
        return this.itemID;
    }

    public boolean IsDirectory() {
        return this.isDir;
    }

    public void setDirMarker(boolean dirMarker) {
        this.isDir = dirMarker;
    }

    public boolean getIncludeSubdirs() {
        return this.includeSubdirs;
    }

    public void setIncludeSubdirs(boolean inclSubdirs) {
        if (!this.includeSubdirs && inclSubdirs) {
            if (this.appCore.getLicenseType() == Core.LICENSE_PERSONAL && this.appCore.getOpenProject().getSpecialDirCount() >= ResAssignment.LICENSE_MAX_SPECIAL_ITEMS && !this.includeFiles) {
                this.appCore.AddLogLine(this.appCore.getLogCreateText(3, 3) + " " + ResAssignment.LICENSE_MAX_SPECIAL_ITEMS + " " + this.appCore.getLogText(3, 4));
                return;
            }
            if (this.internalItems != null && this.internalItems.size() > 0) {
                ProjectItem myItem = null;
                for (int i = 0; i < this.internalItems.size(); ++i) {
                    myItem = (ProjectItem)this.internalItems.elementAt(i);
                    if (!myItem.IsDirectory() || !this.internalItems.remove(myItem)) continue;
                    --i;
                }
            }
        }
        this.includeSubdirs = inclSubdirs;
    }

    public boolean getIncludeFiles() {
        return this.includeFiles;
    }

    public void setIncludeFiles(boolean inclFiles) {
        if (!this.includeFiles && inclFiles) {
            if (this.appCore.getLicenseType() == Core.LICENSE_PERSONAL && this.appCore.getOpenProject().getSpecialDirCount() >= ResAssignment.LICENSE_MAX_SPECIAL_ITEMS && !this.getIncludeSubdirs()) {
                this.appCore.AddLogLine(this.appCore.getLogCreateText(3, 3) + " " + ResAssignment.LICENSE_MAX_SPECIAL_ITEMS + " " + this.appCore.getLogText(3, 4));
                return;
            }
            if (this.internalItems != null && this.internalItems.size() > 0) {
                ProjectItem myItem = null;
                for (int i = 0; i < this.internalItems.size(); ++i) {
                    myItem = (ProjectItem)this.internalItems.elementAt(i);
                    if (myItem.IsDirectory() || !this.internalItems.remove(myItem)) continue;
                    --i;
                }
            }
        }
        this.includeFiles = inclFiles;
    }

    public void RootSetup() {
        this.isCorrectlyInitialised = true;
        this.isRoot = true;
        this.isDir = true;
    }

    public int NodeSetup(String contentString) {
        this.contentItemString = contentString;
        this.isCorrectlyInitialised = true;
        return 0;
    }

    public int getChildCount() {
        if (this.internalItems == null) {
            return 0;
        }
        return this.internalItems.size();
    }

    public ProjectItem getChild(int pos) {
        if (this.internalItems == null) {
            return null;
        }
        if (pos < 1) {
            return null;
        }
        if (pos > this.internalItems.size()) {
            return null;
        }
        return (ProjectItem)this.internalItems.elementAt(pos - 1);
    }

    public int SaveItem(TextFileWriter projectWriter) {
        projectWriter.addLine("[NODE]");
        projectWriter.addLine("id;" + this.itemID + ";x");
        if (this.itemID > 0) {
            projectWriter.addLine("parent;" + this.parentItem.getItemID() + ";x");
            projectWriter.addLine("text;\"" + this.contentItemString + "\";x");
            projectWriter.addLine("isdir;" + this.isDir + ";x");
            projectWriter.addLine("inclsubdirs;" + this.includeSubdirs + ";x");
            projectWriter.addLine("inclfiles;" + this.includeFiles + ";x");
        }
        projectWriter.addLine("");
        if (this.internalItems.size() > 0) {
            for (int i = 0; i < this.internalItems.size(); ++i) {
                if (((ProjectItem)this.internalItems.elementAt(i)).SaveItem(projectWriter) == 0) continue;
                return -1;
            }
        }
        return 0;
    }

    public ProjectItem getStoredItem(String contentString) {
        if (this.internalItems == null) {
            return null;
        }
        if (this.internalItems.size() <= 0) {
            return null;
        }
        ProjectItem myItem = null;
        for (int i = 0; i < this.internalItems.size(); ++i) {
            myItem = (ProjectItem)this.internalItems.elementAt(i);
            if (!myItem.getContentText().equalsIgnoreCase(contentString)) continue;
            return myItem;
        }
        return null;
    }

    public int InsertItem(SlashSplitter split, int pos, boolean dirMarker) {
        ProjectItem targetItem = this.getStoredItem(split.getComponent(pos));
        if (targetItem == null) {
            if (this.internalItems == null) {
                return -1;
            }
            if (this.includeFiles && !dirMarker && pos >= split.getComponentCount()) {
                return -1;
            }
            if (this.includeSubdirs && pos < split.getComponentCount()) {
                return -1;
            }
            targetItem = new ProjectItem(this.appCore.getOpenProject().RequestItemID(), this.appCore, this);
            if (targetItem.NodeSetup(split.getComponent(pos)) != 0) {
                return -1;
            }
            this.internalItems.add(targetItem);
        }
        if (++pos <= split.getComponentCount()) {
            this.isDir = true;
            return targetItem.InsertItem(split, pos, dirMarker);
        }
        targetItem.setDirMarker(dirMarker);
        if (dirMarker) {
            targetItem.setIncludeFiles(true);
        } else {
            targetItem.setIncludeFiles(false);
        }
        return 0;
    }

    public int addChild(ProjectItem item) {
        if (this.internalItems == null) {
            return -1;
        }
        this.internalItems.add(item);
        return 0;
    }

    public ProjectItem getChildItem(int itemId) {
        if (itemId == this.itemID) {
            return this;
        }
        if (this.internalItems == null) {
            return null;
        }
        if (this.internalItems.size() <= 0) {
            return null;
        }
        ProjectItem myItem = null;
        for (int i = 0; i < this.internalItems.size(); ++i) {
            myItem = ((ProjectItem)this.internalItems.elementAt(i)).getChildItem(itemId);
            if (myItem == null) continue;
            return myItem;
        }
        return null;
    }

    public int GenerateCopyList(CopyList theList, String baseString) {
        if (theList.IsAborted()) {
            return -1;
        }
        if (!this.isDir) {
            File myFile = new File(baseString + this.contentItemString);
            if (!myFile.isFile()) {
                this.appCore.AddLogLine(this.appCore.getLogCreateText(2, 2) + " " + myFile.getAbsolutePath());
                theList.CountError();
            } else {
                this.appCore.getMiscData().incTmpCopyList_FileCount(1);
                this.appCore.getMiscData().incTmpCopyList_ByteCount(myFile.length());
                theList.addFile(myFile);
            }
        } else {
            this.CopyListDirOperations(theList, baseString + this.contentItemString, this.includeFiles, this.includeSubdirs);
            if (this.getChildCount() > 0) {
                for (int i = 1; i <= this.getChildCount(); ++i) {
                    if (!(this.isRoot ? this.getChild(i).GenerateCopyList(theList, baseString) < 0 : this.getChild(i).GenerateCopyList(theList, baseString + this.contentItemString + "/") < 0)) continue;
                    return -1;
                }
            }
        }
        return 0;
    }

    public void CopyListDirOperations(CopyList theList, String dirString, boolean files, boolean subDirs) {
        if (theList.IsAborted()) {
            return;
        }
        File dirFile = new File(dirString);
        if (!dirFile.isDirectory()) {
            return;
        }
        if (!files && !subDirs) {
            return;
        }
        String[] dirContent = dirFile.list();
        File myFile = null;
        for (int i = 0; i < dirContent.length; ++i) {
            if (theList.IsAborted()) {
                return;
            }
            myFile = new File(dirFile.getAbsolutePath() + "/" + dirContent[i]);
            if (myFile.isDirectory()) {
                try {
                    if (subDirs) {
                        this.CopyListDirOperations(theList, myFile.getAbsolutePath(), files, subDirs);
                    }
                }
                catch (Exception e) {
                    this.appCore.AddLogLine(this.appCore.getTimestamp() + e);
                    this.appCore.AddLogLine(this.appCore.getLogCreateText(2, 2) + " " + myFile.getAbsolutePath());
                    theList.CountError();
                }
            }
            if (!myFile.isFile()) continue;
            try {
                if (!files) continue;
                this.appCore.getMiscData().incTmpCopyList_FileCount(1);
                this.appCore.getMiscData().incTmpCopyList_ByteCount(myFile.length());
                theList.addFile(myFile);
                continue;
            }
            catch (Exception e) {
                this.appCore.AddLogLine(this.appCore.getTimestamp() + e);
                this.appCore.AddLogLine(this.appCore.getLogCreateText(2, 2) + " " + myFile.getAbsolutePath());
                theList.CountError();
            }
        }
    }

    public void Delete() {
        this.parentItem.RemoveItem(this);
    }

    public void RemoveItem(ProjectItem item) {
        if (this.internalItems == null) {
            return;
        }
        if (this.internalItems.remove(item)) {
            this.appCore.AddLogLine(this.appCore.getLogCreateText(1, 8) + " " + item.getContentText());
        }
    }

    public boolean ContainsFileChildren() {
        if (this.internalItems == null) {
            return false;
        }
        if (this.internalItems.size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.internalItems.size(); ++i) {
            if (((ProjectItem)this.internalItems.elementAt(i)).IsDirectory()) continue;
            return true;
        }
        return false;
    }

    public boolean ContainsSubDirChildren() {
        if (this.internalItems == null) {
            return false;
        }
        if (this.internalItems.size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.internalItems.size(); ++i) {
            if (!((ProjectItem)this.internalItems.elementAt(i)).IsDirectory()) continue;
            return true;
        }
        return false;
    }

    public int getLeafCount() {
        if (this.internalItems == null) {
            return 0;
        }
        if (this.internalItems.size() == 0) {
            return 1;
        }
        int count = 0;
        for (int i = 1; i <= this.internalItems.size(); ++i) {
            count += this.getChild(i).getLeafCount();
        }
        return count;
    }

    public boolean IsSpecialDir() {
        if (this.isRoot) {
            return false;
        }
        if (!this.isDir) {
            return false;
        }
        if (this.includeFiles) {
            return true;
        }
        return this.includeSubdirs;
    }

    public int getSpecialDirCount() {
        int count = 0;
        if (!this.isRoot && this.IsSpecialDir()) {
            ++count;
        }
        if (this.internalItems != null && this.internalItems.size() > 0) {
            for (int i = 1; i <= this.internalItems.size(); ++i) {
                count += this.getChild(i).getSpecialDirCount();
            }
        }
        return count;
    }
}

