/*
 * Decompiled with CFR 0.152.
 */
package MITTools.Files.TextFiles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

public class TextFileReader {
    private boolean initialized = false;
    private Vector lines = null;
    private File readerFile = null;

    public static String ErrorCode(int code) {
        if (code == -1) {
            return "Code: " + code + " - general error code";
        }
        if (code == -2) {
            return "Code: " + code + " - reader already initialized - new file not used";
        }
        if (code == -3) {
            return "Code: " + code + " - error open file";
        }
        if (code == -4) {
            return "Code: " + code + " - error finding requested semicolon - string part could not be separated";
        }
        if (code == -5) {
            return "Code: " + code + " - object not initialized";
        }
        return "Code: " + code + " - no code text found";
    }

    public TextFileReader() {
    }

    public TextFileReader(File file) {
        this.ReadFile(file);
    }

    public TextFileReader(String file) {
        this.ReadFile(new File(file));
    }

    public int ReadFile(String file) {
        return this.ReadFile(new File(file));
    }

    public int ReadFile(File file) {
        if (this.initialized) {
            return -2;
        }
        this.readerFile = file;
        this.lines = new Vector();
        String insertString = "";
        try {
            FileReader fr = new FileReader(this.readerFile);
            BufferedReader lineReader = new BufferedReader(fr);
            while (insertString != null) {
                insertString = lineReader.readLine();
                if (insertString == null) continue;
                this.lines.add(insertString);
            }
            fr.close();
        }
        catch (Exception e) {
            System.out.println("\nError open file: " + this.readerFile.getAbsolutePath());
            System.out.println("----------------------------------------");
            e.printStackTrace(System.out);
            System.out.println("----------------------------------------\n\n");
            return -3;
        }
        this.initialized = true;
        return 0;
    }

    public String GetFileName() {
        return this.readerFile.getName();
    }

    public String GetFilePath() {
        return this.readerFile.getAbsolutePath();
    }

    public String ReadLine(int lineNr) {
        if (lineNr <= this.lines.size()) {
            return (String)this.lines.elementAt(lineNr - 1);
        }
        return null;
    }

    public File GetFile() {
        return this.readerFile;
    }

    public int GetSize() {
        if (!this.initialized) {
            return -5;
        }
        return this.lines.size();
    }

    public String GetCSVStringPartOfLine(int line, int partNumber) {
        return this.GetCSVStringPart(this.ReadLine(line), partNumber);
    }

    public int GetCSV_Count(String inString) {
        if (!this.initialized) {
            return -5;
        }
        String tmp2 = ";";
        char colonChar = tmp2.charAt(0);
        int colonCount = 0;
        for (int i = 0; i < inString.length(); ++i) {
            if (inString.charAt(i) != colonChar) continue;
            ++colonCount;
        }
        return colonCount;
    }

    private int FindSemiColon(String inString, int colonNumber) {
        if (!this.initialized) {
            return -5;
        }
        String tmp2 = ";";
        char colonChar = tmp2.charAt(0);
        int colonCount = 0;
        for (int i = 0; i < inString.length(); ++i) {
            if (inString.charAt(i) != colonChar || ++colonCount != colonNumber) continue;
            return i;
        }
        return -4;
    }

    public String GetCSVStringPart(String inString, int partNumber) {
        int endPos;
        if (inString.length() == 0) {
            return null;
        }
        String emptyString = " ";
        char spaceChar = emptyString.charAt(0);
        int charCount = 0;
        for (int i = 0; i < inString.length(); ++i) {
            if (inString.charAt(i) == spaceChar) continue;
            ++charCount;
        }
        if (charCount == 0) {
            return null;
        }
        int startPos = 0;
        if (partNumber > 1) {
            startPos = this.FindSemiColon(inString, partNumber - 1);
            if (startPos < 0) {
                return null;
            }
            ++startPos;
        }
        if ((endPos = this.FindSemiColon(inString, partNumber)) < 0) {
            endPos = inString.length();
        }
        if (startPos >= endPos) {
            return null;
        }
        return inString.substring(startPos, endPos);
    }

    public boolean EmptyLine(String line) {
        if (line == null) {
            return true;
        }
        if (line.equals("")) {
            return true;
        }
        String tmp = " ";
        char spaceChar = tmp.charAt(0);
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == spaceChar) continue;
            return false;
        }
        return true;
    }
}

