/*
 * Decompiled with CFR 0.152.
 */
package MITTools.Files.TextFiles;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;

public class TextFileWriter {
    private Vector lines = null;
    private File writerFile = null;

    public static String ErrorCode(int code) {
        if (code == -1) {
            return "Code: " + code + " - general error code";
        }
        if (code == -2) {
            return "Code: " + code + " - requested line not found";
        }
        if (code == -3) {
            return "Code: " + code + " - no data - file is empty (not written)";
        }
        if (code == -4) {
            return "Code: " + code + " - error while writing file";
        }
        if (code == -5) {
            return "Code: " + code + " - no file to write specified";
        }
        return "Code: " + code + " - no code text found";
    }

    public TextFileWriter() {
        this.Init();
    }

    public TextFileWriter(File file) {
        this.writerFile = file;
        this.Init();
    }

    public TextFileWriter(String file) {
        this.writerFile = new File(file);
        this.Init();
    }

    private void Init() {
        this.lines = new Vector();
    }

    public int addLine(String inString) {
        this.lines.add(inString + "\n");
        return 0;
    }

    public int setLine(String inString, int line) {
        if (this.lines.size() < line) {
            return -2;
        }
        this.lines.set(line - 1, inString);
        return 0;
    }

    public String getLine(int line) {
        if (this.lines.size() < line) {
            return null;
        }
        return (String)this.lines.get(line - 1);
    }

    public int RemoveLine(int line) {
        if (this.lines.size() < line) {
            return -2;
        }
        this.lines.remove(line - 1);
        return 0;
    }

    public int setFile(File file) {
        this.writerFile = file;
        return 0;
    }

    public int setFile(String file) {
        this.writerFile = new File(file);
        return 0;
    }

    public int WriteFile() {
        if (this.writerFile == null) {
            return -5;
        }
        if (this.lines.size() >= 1) {
            try {
                FileWriter fw = new FileWriter(this.writerFile);
                BufferedWriter lineWriter = new BufferedWriter(fw);
                for (int i = 0; i < this.lines.size(); ++i) {
                    lineWriter.write((String)this.lines.get(i));
                }
                lineWriter.close();
                fw.close();
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return -4;
            }
        }
        return -3;
    }
}

