/*
 * Decompiled with CFR 0.152.
 */
package MITTools.Lang;

import MITTools.Files.TextFiles.TextFileReader;
import java.io.File;
import java.util.Vector;

public class LangContainer {
    private boolean initialized = false;
    private int languageNumbers = 6;
    private Vector langVector = null;

    public static String ErrorCode(int code) {
        if (code == -1) {
            return "Code: " + code + " - general error code";
        }
        if (code == -2) {
            return "Code: " + code + " - container already initialized - new file not used";
        }
        if (code == -3) {
            return "Code: " + code + " - error reading input-file. init aborted";
        }
        if (code == -4) {
            return "Code: " + code + " - requested section not found";
        }
        if (code == -5) {
            return "Code: " + code + " - object not initialized";
        }
        return "Code: " + code + " - no code text found";
    }

    public LangContainer() {
    }

    public LangContainer(File file) {
        this.InitContainer(file);
    }

    public LangContainer(String file) {
        this.InitContainer(new File(file));
    }

    public int InitContainer(String file) {
        return this.InitContainer(new File(file));
    }

    public int InitContainer(File file) {
        if (this.initialized) {
            return -2;
        }
        TextFileReader languageFile = new TextFileReader();
        if (languageFile.ReadFile(file) < 0) {
            return -3;
        }
        int lines = languageFile.GetSize();
        String lineContent = null;
        this.langVector = new Vector();
        Vector<String> tmpVector = null;
        Vector sectionVector = null;
        for (int curLine = 1; curLine <= lines; ++curLine) {
            lineContent = languageFile.ReadLine(curLine);
            if (lineContent.equalsIgnoreCase("[OPTIONS]")) {
                lineContent = languageFile.ReadLine(++curLine);
                while (!languageFile.EmptyLine(lineContent) & curLine <= lines) {
                    if (languageFile.GetCSVStringPart(lineContent, 1).equalsIgnoreCase("languages")) {
                        int langChange = this.languageNumbers;
                        try {
                            langChange = Integer.parseInt(languageFile.GetCSVStringPart(lineContent, 2));
                        }
                        catch (Exception e) {
                            System.out.println("Error reading new number of languages (languages tag in Section [OPTIONS]");
                            System.out.println("----------------------------------------");
                            System.out.println(e);
                            System.out.println("----------------------------------------\n\n");
                        }
                        if (langChange > 0) {
                            this.languageNumbers = langChange;
                        }
                    }
                    lineContent = languageFile.ReadLine(++curLine);
                }
            }
            if (!lineContent.equalsIgnoreCase("[LANG-SECTION]")) continue;
            lineContent = languageFile.ReadLine(++curLine);
            sectionVector = new Vector();
            while (!languageFile.EmptyLine(lineContent) & curLine <= lines) {
                tmpVector = new Vector<String>();
                for (int i = 0; i <= this.languageNumbers; ++i) {
                    tmpVector.addElement(languageFile.GetCSVStringPart(lineContent, i + 1));
                }
                sectionVector.addElement(tmpVector);
                lineContent = languageFile.ReadLine(++curLine);
            }
            this.langVector.addElement(sectionVector);
            lineContent = languageFile.ReadLine(++curLine);
        }
        this.initialized = true;
        return 0;
    }

    public int GetNumberOfLanguages() {
        if (!this.initialized) {
            return -5;
        }
        return this.languageNumbers;
    }

    public String GetEntry(int section, int row, int language, String notFoundString) {
        String tmp = this.GetEntry(section, row, language);
        if (tmp == null) {
            return notFoundString;
        }
        return tmp;
    }

    public int GetSectionCount() {
        if (!this.initialized) {
            return -5;
        }
        return this.langVector.size();
    }

    public int GetRowCount(int section) {
        if (!this.initialized) {
            return -5;
        }
        if (section > this.langVector.size()) {
            return -4;
        }
        return ((Vector)this.langVector.elementAt(section - 1)).size();
    }

    public String GetEntry(int section, int row, int language) {
        if (section > this.langVector.size()) {
            return null;
        }
        Vector sectionVector = (Vector)this.langVector.elementAt(section - 1);
        if (row > sectionVector.size()) {
            return null;
        }
        Vector rowVector = (Vector)sectionVector.elementAt(row - 1);
        if (language > rowVector.size() + 1) {
            return null;
        }
        return (String)rowVector.elementAt(language);
    }
}

