/*
 * Decompiled with CFR 0.152.
 */
package jd.gui;

import java.awt.Point;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import jd.config.SubConfiguration;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.userio.NoUserIO;
import jd.nutils.JDFlags;
import jd.utils.locale.JDL;

public abstract class UserIO {
    public static final int NO_JAC = 1;
    public static final int NO_USER_INTERACTION = 2;
    public static final int NO_COUNTDOWN = 4;
    public static final int NO_OK_OPTION = 8;
    public static final int NO_CANCEL_OPTION = 16;
    public static final int DONT_SHOW_AGAIN = 32;
    public static final int STYLE_LARGE = 64;
    public static final int STYLE_HTML = 128;
    public static final int NO_ICON = 256;
    public static final int DONT_SHOW_AGAIN_IGNORES_CANCEL = 512;
    public static final int DONT_SHOW_AGAIN_IGNORES_OK = 1024;
    public static final int RETURN_OK = 2;
    public static final int RETURN_CANCEL = 4;
    public static final int RETURN_DONT_SHOW_AGAIN = 8;
    public static final int RETURN_SKIPPED_BY_DONT_SHOW = 16;
    public static final int RETURN_COUNTDOWN_TIMEOUT = 32;
    public static final int ICON_INFO = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_ERROR = 2;
    public static final int ICON_QUESTION = 3;
    protected static UserIO INSTANCE = null;
    private static int COUNTDOWN_TIME = -1;

    public static UserIO getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NoUserIO();
        }
        return INSTANCE;
    }

    public static void setInstance(UserIO instance) {
        INSTANCE = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestCaptchaDialog(int flag, String host, String methodname, File captchafile, String suggestion, String explain) {
        UserIO userIO = INSTANCE;
        synchronized (userIO) {
            return this.showCaptchaDialog(flag, host, methodname, captchafile, suggestion, explain);
        }
    }

    protected abstract String showCaptchaDialog(int var1, String var2, String var3, File var4, String var5, String var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point requestClickPositionDialog(File imagefile, String title, String explain) {
        UserIO userIO = INSTANCE;
        synchronized (userIO) {
            return this.showClickPositionDialog(imagefile, title, explain);
        }
    }

    protected abstract Point showClickPositionDialog(File var1, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestHelpDialog(int flag, String title, String message, String helpMessage, String url) {
        UserIO userIO = INSTANCE;
        synchronized (userIO) {
            return this.showHelpDialog(flag, title, message, helpMessage, url);
        }
    }

    protected abstract int showHelpDialog(int var1, String var2, String var3, String var4, String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestConfirmDialog(int flag, String title, String message, ImageIcon icon, String okOption, String cancelOption) {
        UserIO userIO = INSTANCE;
        synchronized (userIO) {
            if (icon == null) {
                icon = this.getDefaultIcon(String.valueOf(title) + message);
            }
            return this.showConfirmDialog(flag, title, message, icon, okOption, cancelOption);
        }
    }

    protected abstract int showConfirmDialog(int var1, String var2, String var3, ImageIcon var4, String var5, String var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestInputDialog(int flag, String title, String message, String defaultMessage, ImageIcon icon, String okOption, String cancelOption) {
        UserIO userIO = INSTANCE;
        synchronized (userIO) {
            return this.showInputDialog(flag, title, message, defaultMessage, icon, okOption, cancelOption);
        }
    }

    protected abstract String showInputDialog(int var1, String var2, String var3, String var4, ImageIcon var5, String var6, String var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String requestTextAreaDialog(String title, String message, String def) {
        UserIO userIO = INSTANCE;
        synchronized (userIO) {
            return this.showTextAreaDialog(title, message, def);
        }
    }

    protected abstract String showTextAreaDialog(String var1, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] requestTwoTextFieldDialog(String title, String messageOne, String defOne, String messageTwo, String defTwo) {
        UserIO userIO = INSTANCE;
        synchronized (userIO) {
            return this.showTwoTextFieldDialog(title, messageOne, defOne, messageTwo, defTwo);
        }
    }

    protected abstract String[] showTwoTextFieldDialog(String var1, String var2, String var3, String var4, String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] requestFileChooser(String id, String title, Integer fileSelectionMode, FileFilter fileFilter, Boolean multiSelection) {
        UserIO userIO = INSTANCE;
        synchronized (userIO) {
            return this.showFileChooser(id, title, fileSelectionMode, fileFilter, multiSelection);
        }
    }

    protected abstract File[] showFileChooser(String var1, String var2, Integer var3, FileFilter var4, Boolean var5);

    public void requestMessageDialog(String message) {
        this.requestMessageDialog(0, JDL.L((String)"gui.dialogs.message.title", (String)"Message"), message);
    }

    public void requestMessageDialog(int flag, String message) {
        this.requestMessageDialog(flag, JDL.L((String)"gui.dialogs.message.title", (String)"Message"), message);
    }

    public void requestMessageDialog(String title, String message) {
        this.requestMessageDialog(0, title, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestMessageDialog(int flag, String title, String message) {
        UserIO userIO = INSTANCE;
        synchronized (userIO) {
            this.showConfirmDialog(0x10 | flag, title, message, this.getIcon(0), null, null);
        }
    }

    private ImageIcon getDefaultIcon(String text) {
        if (text.contains("?")) {
            return this.getIcon(3);
        }
        if (text.matches(JDL.L((String)"userio.errorregex", (String)".*(error|failed).*"))) {
            return this.getIcon(2);
        }
        if (text.contains("!")) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    public abstract ImageIcon getIcon(int var1);

    public static int getCountdownTime() {
        if (COUNTDOWN_TIME > 0) {
            return COUNTDOWN_TIME;
        }
        SubConfiguration cfg = GUIUtils.getConfig();
        return Math.max(2, cfg.getIntegerProperty("PARAM_INPUTTIMEOUT", 20));
    }

    public static void setCountdownTime(int time) {
        COUNTDOWN_TIME = time <= 0 ? -1 : time;
    }

    public String requestInputDialog(String message) {
        return this.requestInputDialog(0, message, null);
    }

    public int requestConfirmDialog(int flag, String question) {
        return this.requestConfirmDialog(flag, JDL.L((String)"jd.gui.userio.defaulttitle.confirm", (String)"Please confirm!"), question, this.getDefaultIcon(question), null, null);
    }

    public int requestConfirmDialog(int flag, String title, String question) {
        return this.requestConfirmDialog(flag, title, question, this.getDefaultIcon(String.valueOf(title) + question), null, null);
    }

    public String requestInputDialog(int flag, String question, String defaultvalue) {
        return this.requestInputDialog(flag, JDL.L((String)"jd.gui.userio.defaulttitle.input", (String)"Please enter!"), question, defaultvalue, this.getDefaultIcon(question), null, null);
    }

    public abstract int requestComboDialog(int var1, String var2, String var3, Object[] var4, int var5, ImageIcon var6, String var7, String var8, ListCellRenderer var9);

    public static boolean isOK(int answer) {
        return JDFlags.hasSomeFlags((int)answer, (int[])new int[]{2});
    }
}

