/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing;

import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jd.config.ConfigGroup;
import jd.controlling.JDLogger;
import jd.gui.swing.components.JDUnderlinedText;
import jd.gui.swing.components.linkbutton.JLink;
import jd.utils.JDTheme;
import net.miginfocom.swing.MigLayout;

public class Factory {
    public static JPanel createHeader(ConfigGroup group) {
        return Factory.createHeader(group.getName(), group.getIcon());
    }

    public static JPanel createHeader(String name, ImageIcon icon) {
        JPanel ret = new JPanel((LayoutManager)new MigLayout("ins 0", "[]10[grow,fill]3[]"));
        try {
            JLink label = new JLink("<html><u><b>" + name + "</b></u></html>", (Icon)icon, new URL("http://wiki.jdownloader.org/quickhelp/" + name.replace(" ", "-")));
            ret.add(label);
            label.setIconTextGap(8);
            label.setBorder(null);
        }
        catch (MalformedURLException e) {
            JDLogger.exception((Throwable)e);
        }
        ret.add(new JSeparator());
        ret.add(new JLabel(JDTheme.II((String)"gui.images.config.tip", (int)16, (int)16)));
        ret.setOpaque(false);
        ret.setBackground(null);
        return ret;
    }

    public static JButton createButton(String string, Icon i) {
        return Factory.createButton(string, i, null);
    }

    public static JButton createButton(String string, Icon i, ActionListener listener) {
        JButton bt = i != null ? new JButton(string, i) : new JButton(string);
        bt.setContentAreaFilled(false);
        bt.setCursor(Cursor.getPredefinedCursor(12));
        bt.setFocusPainted(false);
        bt.setBorderPainted(false);
        bt.setHorizontalAlignment(2);
        bt.setIconTextGap(5);
        if (listener != null) {
            bt.addActionListener(listener);
        }
        bt.addMouseListener(new JDUnderlinedText(bt));
        return bt;
    }
}

