/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing;

import javax.swing.SwingUtilities;
import jd.controlling.JDLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GuiRunnable<T>
implements Runnable {
    private static final long serialVersionUID = 7777074589566807490L;
    private T returnValue;
    private Object lock = new Object();
    private boolean started = false;
    private boolean done = false;

    public boolean isStarted() {
        return this.started;
    }

    private void setStarted(boolean started) {
        this.started = started;
    }

    public T getReturnValue() {
        this.waitForEDT();
        return this.returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEDT() {
        if (this.done) {
            return;
        }
        if (!this.isStarted()) {
            this.start();
        }
        if (!SwingUtilities.isEventDispatchThread() && this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    if (this.lock != null) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.returnValue = this.runSave();
        }
        catch (Exception e) {
            JDLogger.exception((Throwable)e);
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
            this.lock = null;
        }
    }

    public abstract T runSave();

    public void start() {
        this.setStarted(true);
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }
}

