/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jd.controlling.JDLogger;
import jd.gui.swing.components.WebBrowserPane;
import jd.gui.swing.components.WebToolBar;
import jd.gui.swing.dialog.AbstractDialog;
import net.miginfocom.swing.MigLayout;

public class DnDWebBrowser
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private URL url;
    private WebBrowserPane browserPane;
    private WebToolBar toolBar;

    public DnDWebBrowser(URL url) {
        super(284, "Java WebBrowser", null, null, null);
        this.url = url;
        this.init();
    }

    protected void packed() {
        this.goTo(this.url);
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
    }

    public JComponent contentInit() {
        this.browserPane = new WebBrowserPane();
        this.toolBar = new WebToolBar(this.browserPane);
        this.browserPane.setDropTarget(new DropTarget(this.browserPane, 1, new DropTargetHandler()));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow,fill]"));
        panel.add(this.toolBar);
        panel.add((Component)new JScrollPane(this.browserPane), "spany");
        return panel;
    }

    public void goTo(URL url) {
        try {
            this.browserPane.setPage(url);
            this.toolBar.urlTextField.setText(url.toString());
        }
        catch (IOException e) {
            JDLogger.exception((Throwable)e);
        }
    }

    private class DropTargetHandler
    implements DropTargetListener {
        private DropTargetHandler() {
        }

        public void dragEnter(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent event) {
        }

        public void dragOver(DropTargetDragEvent event) {
        }

        public void drop(DropTargetDropEvent event) {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(1);
                try {
                    List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : fileList) {
                        DnDWebBrowser.this.browserPane.goToURL(file.toURI().toURL());
                    }
                    event.dropComplete(true);
                }
                catch (UnsupportedFlavorException flavorException) {
                    JDLogger.exception((Throwable)flavorException);
                    event.dropComplete(false);
                }
                catch (IOException ioException) {
                    JDLogger.exception((Throwable)ioException);
                    event.dropComplete(false);
                }
            } else {
                event.rejectDrop();
            }
        }

        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }
}

