/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import jd.gui.swing.GuiRunnable;
import jd.utils.JDUtilities;

public class JDFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 3315263822025280362L;
    private String fcID;
    public static int ImagesOnly = 3;

    public JDFileChooser() {
        this((String)null);
    }

    public JDFileChooser(String id) {
        this.fcID = id;
        this.setCurrentDirectory(JDUtilities.getCurrentWorkingDirectory((String)this.fcID));
    }

    public File getSelectedFile() {
        File ret = super.getSelectedFile();
        if (ret == null) {
            return null;
        }
        if (ret.isDirectory()) {
            JDUtilities.setCurrentWorkingDirectory((File)ret, (String)this.fcID);
        } else {
            JDUtilities.setCurrentWorkingDirectory((File)ret.getParentFile(), (String)this.fcID);
        }
        return ret;
    }

    public File[] getSelectedFiles() {
        File[] ret = super.getSelectedFiles();
        if (ret == null || ret.length == 0) {
            return ret;
        }
        if (ret[0].isDirectory()) {
            JDUtilities.setCurrentWorkingDirectory((File)ret[0], (String)this.fcID);
        } else {
            JDUtilities.setCurrentWorkingDirectory((File)ret[0].getParentFile(), (String)this.fcID);
        }
        return ret;
    }

    public void setFileSelectionMode(int mode) {
        if (mode == ImagesOnly) {
            this.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String nt = f.getName().toLowerCase();
                    return nt.endsWith(".jpg") || nt.endsWith(".png") || nt.endsWith(".gif") || nt.endsWith(".jpeg") || nt.endsWith(".bmp");
                }

                public String getDescription() {
                    return null;
                }
            });
            mode = 0;
        }
        super.setFileSelectionMode(mode);
    }

    public static File getFile() {
        return JDFileChooser.getFile(0);
    }

    public static File getFile(final int mode) {
        return (File)new GuiRunnable<File>(){

            @Override
            public File runSave() {
                JDFileChooser fc = new JDFileChooser();
                fc.setVisible(true);
                fc.setFileSelectionMode(mode);
                fc.showOpenDialog(null);
                File ret = fc.getSelectedFile();
                return ret;
            }
        }.getReturnValue();
    }
}

