/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import jd.gui.swing.components.ProgressEntry;

public class MultiProgressBar
extends JPanel {
    private static final long serialVersionUID = -7489358722203326526L;
    private ArrayList<ProgressEntry> entries = new ArrayList();
    private long maximum;
    private long value;

    public MultiProgressBar() {
        this.setBackground(this.getBackground().darker());
        LineBorder b = new LineBorder(this.getBackground().brighter(), 1, true);
        this.setBorder(b);
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 30);
    }

    private int scale(long point, double faktor) {
        return (int)Math.ceil((double)point / faktor);
    }

    private double getFaktor() {
        return (double)this.maximum / (double)Math.max(1, this.getWidth());
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = (int)((double)this.getHeight() * 0.8);
        Color col1 = new Color(8181282);
        Color col2 = new Color(0x339933);
        double faktor = this.getFaktor();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f));
        int i = 0;
        while (i < this.entries.size()) {
            ProgressEntry e = this.entries.get(i);
            Color col = new Color(50, 255 - 205 / (this.entries.size() + 1) * i, 50);
            long pvalue = e.getValue() >= 0L ? e.getValue() : e.getMaximum();
            Rectangle rec = new Rectangle(this.scale(e.getPosition(), faktor), 0, this.scale(pvalue, faktor), height);
            if (e.getValue() < 0L) {
                ((Graphics2D)g).setPaint(Color.RED);
            } else {
                ((Graphics2D)g).setPaint(new GradientPaint(width / 2, 0.0f, col, width / 2, height, col2.darker()));
            }
            g2.fill(rec);
            ((Graphics2D)g).setPaint(Color.black);
            g2.drawLine(this.scale(e.getPosition(), faktor), 0, this.scale(e.getPosition(), faktor), height);
            ++i;
        }
        col1 = col1.brighter();
        col2 = col2.brighter();
        ((Graphics2D)g).setPaint(this.getBackground().darker().darker());
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawLine(0, height, width, height);
        Rectangle rec = new Rectangle(0, height + 2, this.scale(this.value, faktor), this.getHeight() - height);
        ((Graphics2D)g).setPaint(new GradientPaint(width / 2, 0.0f, col1, width / 2, height, col2.darker()));
        g2.fill(rec);
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(long ... values) {
        ArrayList<ProgressEntry> arrayList = this.entries;
        synchronized (arrayList) {
            int i = 0;
            while (i < values.length) {
                if (this.entries.size() <= i) {
                    this.entries.add(new ProgressEntry(0L));
                }
                this.entries.get(i).setValue(values[i]);
                ++i;
            }
        }
        this.update();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximums(long ... max) {
        if (max == null) {
            this.entries = new ArrayList();
            return;
        }
        ArrayList<ProgressEntry> arrayList = this.entries;
        synchronized (arrayList) {
            int i = 0;
            while (i < max.length) {
                if (this.entries.size() <= i) {
                    this.entries.add(new ProgressEntry(max[i]));
                } else {
                    this.entries.get(i).setMaximum(max[i]);
                }
                ++i;
            }
        }
        this.update();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        long max = 0L;
        long totalvalue = 0L;
        ArrayList<ProgressEntry> arrayList = this.entries;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.entries.size()) {
                ProgressEntry e = this.entries.get(i);
                e.setPosition(max);
                max += e.getMaximum();
                totalvalue += e.getValue();
                ++i;
            }
            this.maximum = max;
            this.value = totalvalue;
        }
    }
}

