/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components.pieapi;

import jd.gui.swing.components.pieapi.ChartAPI;
import jd.gui.swing.components.pieapi.ChartAPIEntity;

public class PieChartAPI
extends ChartAPI {
    private static final long serialVersionUID = 7576517180813229367L;

    public PieChartAPI(String caption, int width, int height) {
        super(caption, width, height);
    }

    public String createDataString() {
        StringBuilder data = new StringBuilder();
        for (ChartAPIEntity tmp : super.getHashMap().values()) {
            if (data.length() > 0) {
                data.append(',');
            }
            data.append(this.getRelativeValue(tmp.getData()));
        }
        return data.toString();
    }

    public String createColorString() {
        StringBuilder data = new StringBuilder();
        for (ChartAPIEntity tmp : super.getHashMap().values()) {
            if (tmp.getColor() == null) continue;
            if (data.length() > 0) {
                data.append(',');
            }
            data.append(String.format("%02X%02X%02X", tmp.getColor().getRed(), tmp.getColor().getGreen(), tmp.getColor().getBlue()));
        }
        return data.toString();
    }

    public String getUrl() {
        return "http://chart.apis.google.com/chart?cht=p3&chd=t:" + this.createDataString() + "&chco=" + this.createColorString() + "&chs=" + this.getWidth() + "x" + this.getHeight() + "&chl=" + this.createCaptionString() + "&chf=bg,s,00000000";
    }

    public void fetchImage() {
        super.downloadImage(this.getUrl());
    }
}

