/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.components.table;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jd.config.SubConfiguration;
import jd.gui.swing.components.JExtCheckBoxMenuItem;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.components.table.JDTableColumn;
import jd.gui.swing.components.table.JDTableModel;
import jd.gui.swing.components.table.SortMenuItem;
import jd.gui.swing.jdgui.interfaces.JDMouseAdapter;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTable
extends JXTable {
    private static final long serialVersionUID = -6631229711568284941L;
    private static final String JDL_PREFIX = "jd.gui.swing.components.table.JDTable.";
    private JDTableModel model;
    private SubConfiguration tableconfig;
    private SortMenuItem defaultSortMenuItem;
    public static final int ROWHEIGHT = 19;

    public JDTable(JDTableModel model) {
        super((TableModel)model);
        this.model = model;
        model.setJDTable(this);
        this.tableconfig = model.getConfig();
        this.createColumns();
        this.setSortable(false);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        UIManager.put("Table.focusCellHighlightBorder", null);
        this.defaultSortMenuItem = new SortMenuItem();
        this.getTableHeader().addMouseListener(new JDMouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    int col = JDTable.this.realColumnAtPoint(e.getPoint());
                    if (JDTable.this.getJDTableModel().getJDTableColumn(col).isSortable(null)) {
                        JDTable.this.getJDTableModel().getJDTableColumn(col).doSort(null);
                    }
                } else if (e.getButton() == 3) {
                    JDTable.this.columControlMenu().show(JDTable.this.getTableHeader(), e.getX(), e.getY());
                }
            }
        });
        this.getTableHeader().setReorderingAllowed(true);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(2);
        this.setSelectionMode(2);
        this.setAutoscrolls(true);
        this.setRowHeight(19);
        this.installColumnControlButton();
        this.getTableHeader().setPreferredSize(new Dimension(this.getColumnModel().getTotalColumnWidth(), 19));
        if (JDUtilities.getJavaVersion() >= 1.6) {
            this.setFillsViewportHeight(true);
        }
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getFromIndex() == e.getToIndex()) {
                    return;
                }
                TableColumnModel tcm = JDTable.this.getColumnModel();
                int i = 0;
                while (i < tcm.getColumnCount()) {
                    JDTable.this.tableconfig.setProperty("POS_COL_" + i, (Object)JDTable.this.getJDTableModel().getJDTableColumn(tcm.getColumn(i).getModelIndex()).getID());
                    ++i;
                }
                JDTable.this.tableconfig.save();
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    private void installColumnControlButton() {
        JButton button = new JButton(((JButton)this.getColumnControl()).getIcon());
        button.setToolTipText(JDL.L((String)"jd.gui.swing.components.table.JDTable.columnControl", (String)"Change Columns"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JButton source = (JButton)event.getSource();
                int x = source.getLocation().x;
                int y = source.getLocation().y;
                JDTable.this.columControlMenu().show(JDTable.this.getTableHeader(), x, y);
            }
        });
        this.setColumnControl(button);
        this.setColumnControlVisible(true);
    }

    public JPopupMenu columControlMenu() {
        JPopupMenu popup = new JPopupMenu();
        JCheckBoxMenuItem[] mis = new JCheckBoxMenuItem[this.getJDTableModel().getColumnCount()];
        int i = 0;
        while (i < this.getJDTableModel().getColumnCount()) {
            final int j = i;
            final JExtCheckBoxMenuItem mi = new JExtCheckBoxMenuItem(this.getJDTableModel().getColumnName(i));
            mi.setHideOnClick(false);
            mis[i] = mi;
            if (i == 0) {
                mi.setEnabled(false);
            }
            mi.setSelected(this.getJDTableModel().isVisible(i));
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDTable.this.getJDTableModel().setVisible(j, mi.isSelected());
                    JDTable.this.createColumns();
                    JDTable.this.revalidate();
                    JDTable.this.repaint();
                }
            });
            popup.add(mi);
            ++i;
        }
        return popup;
    }

    public ArrayList<JDRowHighlighter> getJDRowHighlighter() {
        return this.model.getJDRowHighlighter();
    }

    public void addJDRowHighlighter(JDRowHighlighter high) {
        this.model.addJDRowHighlighter(high);
    }

    public JDTableModel getJDTableModel() {
        return this.model;
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        return this.model.getJDTableColumn(this.convertColumnIndexToModel(col));
    }

    public TableCellEditor getCellEditor(int row, int col) {
        return this.model.getJDTableColumn(this.convertColumnIndexToModel(col));
    }

    private void createColumns() {
        this.setAutoCreateColumnsFromModel(false);
        TableColumnModel tcm = this.getColumnModel();
        while (tcm.getColumnCount() > 0) {
            tcm.removeColumn(tcm.getColumn(0));
        }
        LinkedHashMap<String, TableColumn> columns = new LinkedHashMap<String, TableColumn>();
        int i = 0;
        while (i < this.getModel().getColumnCount()) {
            final int j = i;
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("width")) {
                        JDTable.this.tableconfig.setProperty("WIDTH_COL_" + JDTable.this.model.getJDTableColumn(j).getID(), evt.getNewValue());
                        JDTable.this.tableconfig.save();
                        JDTable.this.model.getJDTableColumn(j).setCurWidth(Integer.parseInt(evt.getNewValue().toString()));
                    }
                }
            });
            if (this.model.getJDTableColumn(j).getMaxWidth() >= 0) {
                tableColumn.setMaxWidth(this.model.getJDTableColumn(j).getMaxWidth());
            }
            int w = this.tableconfig.getIntegerProperty("WIDTH_COL_" + this.model.getJDTableColumn(j).getID(), tableColumn.getWidth());
            tableColumn.setPreferredWidth(w);
            this.model.getJDTableColumn(j).setCurWidth(w);
            if (this.model.isVisible(i)) {
                columns.put(this.model.getJDTableColumn(j).getID(), tableColumn);
            }
            ++i;
        }
        int index = 0;
        while (!columns.isEmpty()) {
            if (index < this.getModel().getColumnCount()) {
                TableColumn item;
                String id = this.tableconfig.getStringProperty("POS_COL_" + index, null);
                ++index;
                if (id == null || (item = (TableColumn)columns.remove(id)) == null) continue;
                this.addColumn(item);
                continue;
            }
            for (TableColumn ritem : columns.values()) {
                this.addColumn(ritem);
            }
        }
    }

    public int realColumnAtPoint(Point point) {
        int x = this.columnAtPoint(point);
        return this.convertColumnIndexToModel(x);
    }

    public void addSortItem(JPopupMenu menu, int colindex, Object obj, String desc) {
        if (menu == null) {
            return;
        }
        JDTableColumn col = this.model.getJDTableColumn(colindex);
        if (col.isSortable(obj)) {
            this.defaultSortMenuItem.set(col, obj, desc);
            menu.add(this.defaultSortMenuItem);
        }
    }

    public Point getPointinCell(Point x) {
        int row = this.rowAtPoint(x);
        if (row == -1) {
            return null;
        }
        Rectangle cellPosition = this.getCellRect(row, this.columnAtPoint(x), true);
        Point p = new Point();
        p.setLocation(x.getX() - cellPosition.getX(), x.getY() - cellPosition.getY());
        return p;
    }
}

