/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jd.config.SubConfiguration;
import jd.controlling.CaptchaController;
import jd.gui.swing.SwingGui;
import jd.gui.swing.dialog.JCountdownDialog;
import jd.nutils.Screen;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingworker.SwingWorker;

public class CaptchaDialog
extends JCountdownDialog
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = -2046990134131595481L;
    private JButton btnBAD;
    private JButton btnOK;
    private String captchaText = null;
    private boolean abort = false;
    private JTextField textField;
    private int flag;
    private String method;
    private File imagefile;
    private String defaultValue;
    private String explain;
    private transient SwingWorker<Object, Object> jacWorker;
    private String host;

    public CaptchaDialog(int flag, String host, String methodname, File captchafile, String suggestion, String explain) {
        super(SwingGui.getInstance().getMainFrame());
        this.flag = flag;
        this.host = host;
        this.method = methodname;
        this.imagefile = captchafile;
        this.defaultValue = suggestion;
        this.explain = explain;
        this.init();
    }

    public void init() {
        this.setModal(true);
        this.setLayout((LayoutManager)new MigLayout("ins 5,wrap 1", "[fill,grow]"));
        ImageIcon imageIcon = null;
        imageIcon = this.imagefile != null && this.imagefile.exists() ? new ImageIcon(this.imagefile.getAbsolutePath()) : JDTheme.II((String)"gui.images.config.ocr");
        this.textField = new JTextField(10);
        this.textField.addKeyListener(this);
        this.textField.setText(this.defaultValue);
        this.btnOK = new JButton(JDL.L((String)"gui.btn_ok", (String)"OK"));
        this.btnOK.addActionListener(this);
        this.btnBAD = new JButton(JDL.L((String)"gui.btn_cancel", (String)"Cancel"));
        this.btnBAD.addActionListener(this);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.setDefaultCloseOperation(0);
        if (this.explain != null) {
            JTextField tf = new JTextField();
            this.add((Component)tf, "");
            tf.setBorder(null);
            tf.setBackground(null);
            tf.setOpaque(false);
            tf.setText(this.explain);
            tf.setEditable(false);
        }
        this.add((Component)new JLabel(imageIcon), "alignx center");
        this.add(this.textField);
        this.add((Component)this.countDownLabel, "split 3,growx");
        this.add((Component)this.btnOK, "alignx right");
        this.add((Component)this.btnBAD, "alignx right");
        this.setMinimumSize(new Dimension(300, -1));
        this.pack();
        this.setTitle(String.valueOf(this.host != null ? String.valueOf(this.host) + ": " : "") + JDL.L((String)"gui.captchaWindow.askForInput", (String)"Please enter..."));
        this.setResizable(false);
        if (SwingGui.getInstance() == null || SwingGui.getInstance().getMainFrame().getExtendedState() == 1 || !SwingGui.getInstance().getMainFrame().isVisible() || !SwingGui.getInstance().getMainFrame().isActive()) {
            this.setLocation(Screen.getDockBottomRight((Component)this));
        } else {
            this.setLocation(Screen.getCenterOfComponent((Component)SwingGui.getInstance().getMainFrame(), (Component)this));
        }
        this.toFront();
        this.setAlwaysOnTop(true);
        this.requestFocus();
        this.textField.requestFocusInWindow();
        this.textField.selectAll();
        this.countdown(Math.max(2, SubConfiguration.getConfig((String)"JAC").getIntegerProperty("JAC_SHOW_TIMEOUT", 20)));
        if ((this.flag & 1) == 0) {
            this.startJAC();
        }
        this.setVisible(true);
        this.toFront();
    }

    private void startJAC() {
        final String title = this.getTitle();
        this.setTitle(String.valueOf(title) + " [JAntiCaptcha]");
        this.jacWorker = new SwingWorker<Object, Object>(){
            private String code;

            protected Object doInBackground() throws Exception {
                CaptchaController cc = new CaptchaController(CaptchaDialog.this.host, CaptchaDialog.this.method, CaptchaDialog.this.imagefile, null, null);
                this.code = cc.getCode(CaptchaDialog.this.flag | 2);
                return null;
            }

            public void done() {
                CaptchaDialog.this.setTitle(title);
                if (!this.isCancelled() && this.code != null) {
                    CaptchaDialog.this.textField.setText(this.code);
                }
            }
        };
        this.jacWorker.execute();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOK) {
            this.captchaText = this.textField.getText();
        } else if (e.getSource() == this.btnBAD) {
            this.abort = true;
            this.captchaText = null;
        }
        this.dispose();
        this.keyPressed(null);
    }

    public String getCaptchaText() {
        if (this.abort) {
            return null;
        }
        return this.captchaText;
    }

    public void keyPressed(KeyEvent e) {
        this.interrupt();
        if (this.jacWorker != null) {
            this.jacWorker.cancel(true);
            this.jacWorker = null;
            this.setTitle(String.valueOf(this.host != null ? String.valueOf(this.host) + ": " : "") + JDL.L((String)"gui.captchaWindow.askForInput", (String)"Please enter..."));
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void onCountdown() {
        this.captchaText = this.textField.getText();
        this.dispose();
    }
}

