/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.interfaces.JDMouseAdapter;
import jd.nutils.Formatter;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCountdownDialog
extends JDialog {
    private static final long serialVersionUID = 8114522313158766965L;
    protected Thread countdownThread;
    protected int countdown;
    protected JLabel countDownLabel;

    public JCountdownDialog(JFrame currentgui) {
        super(currentgui);
        this.initCountdown();
    }

    protected void initCountdown() {
        this.countDownLabel = new JLabel("no countdown");
        this.countDownLabel.setIcon(JDTheme.II((String)"gui.images.cancel", (int)16, (int)16));
        this.countDownLabel.setToolTipText(JDL.L((String)"gui.dialog.countdown.tooltip", (String)"This dialog closes after a certain time. Click here to stop the countdown"));
        this.countDownLabel.addMouseListener(new JDMouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JCountdownDialog.this.interrupt();
                JCountdownDialog.this.countDownLabel.removeMouseListener(this);
            }
        });
        this.setTitle(JDL.L((String)"gui.captchaWindow.askForInput", (String)"Please enter..."));
    }

    public void interrupt() {
        if (this.countdownThread != null) {
            this.countdownThread.interrupt();
            this.countdownThread = null;
            this.countDownLabel.setEnabled(false);
        }
    }

    protected abstract void onCountdown();

    protected void countdown(int time) {
        this.countdown = time;
        this.countdownThread = new Thread(){

            public void run() {
                while (!JCountdownDialog.this.isVisible()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                int c = JCountdownDialog.this.countdown;
                while (--c >= 0) {
                    if (!JCountdownDialog.this.isVisible()) {
                        return;
                    }
                    if (JCountdownDialog.this.countdownThread == null) {
                        return;
                    }
                    final String left = Formatter.formatSeconds((long)c);
                    new GuiRunnable<Object>(){

                        @Override
                        public Object runSave() {
                            (this).JCountdownDialog.this.countDownLabel.setText(left);
                            return null;
                        }
                    }.start();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    if (JCountdownDialog.this.countdown < 0) {
                        return;
                    }
                    if (JCountdownDialog.this.isVisible()) continue;
                    return;
                }
                if (JCountdownDialog.this.countdown < 0) {
                    return;
                }
                if (!this.isInterrupted()) {
                    JCountdownDialog.this.onCountdown();
                }
            }
        };
        this.countdownThread.start();
    }

    @Override
    public void setIconImage(Image image) {
        if (JDUtilities.getJavaVersion() >= 1.6) {
            super.setIconImage(image);
        }
    }

    @Override
    public void setIconImages(List<? extends Image> icons) {
        if (JDUtilities.getJavaVersion() >= 1.6) {
            super.setIconImages(icons);
        }
    }
}

