/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import jd.OptionalPluginWrapper;
import jd.config.ConfigContainer;
import jd.controlling.ClipboardHandler;
import jd.controlling.DownloadController;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.LinkCheck;
import jd.controlling.LinkGrabberController;
import jd.controlling.LinkGrabberDistributeEvent;
import jd.event.ControlEvent;
import jd.gui.UserIF;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.Balloon;
import jd.gui.swing.components.JDCollapser;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.TabProgress;
import jd.gui.swing.jdgui.components.JDStatusBar;
import jd.gui.swing.jdgui.components.toolbar.MainToolBar;
import jd.gui.swing.jdgui.components.toolbar.ToolBar;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.menu.AboutMenu;
import jd.gui.swing.jdgui.menu.AddLinksMenu;
import jd.gui.swing.jdgui.menu.AddonsMenu;
import jd.gui.swing.jdgui.menu.CleanupMenu;
import jd.gui.swing.jdgui.menu.JStartMenu;
import jd.gui.swing.jdgui.menu.PremiumMenu;
import jd.gui.swing.jdgui.menu.SaveMenu;
import jd.gui.swing.jdgui.menu.actions.ExitAction;
import jd.gui.swing.jdgui.menu.actions.RestartAction;
import jd.gui.swing.jdgui.menu.actions.RestoreAction;
import jd.gui.swing.jdgui.settings.panels.addons.ConfigPanelAddons;
import jd.gui.swing.jdgui.settings.panels.premium.Premium;
import jd.gui.swing.jdgui.views.ConfigurationView;
import jd.gui.swing.jdgui.views.DownloadView;
import jd.gui.swing.jdgui.views.LinkgrabberView;
import jd.gui.swing.jdgui.views.TabbedPanelView;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberPanel;
import jd.gui.swing.jdgui.views.sidebars.configuration.AddonConfig;
import jd.gui.swing.jdgui.views.sidebars.configuration.ConfigSidebar;
import jd.nutils.JDFlags;
import jd.nutils.JDImage;
import jd.nutils.OSDetector;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDGui
extends SwingGui
implements LinkGrabberDistributeEvent {
    private static final long serialVersionUID = 1048792964102830601L;
    private static JDGui INSTANCE;
    private JMenuBar menuBar;
    private JDStatusBar statusBar;
    private MainTabbedPane mainTabbedPane;
    private TabProgress multiProgressBar;
    private DownloadView downloadView;
    private LinkgrabberView linkgrabberView;
    private ConfigurationView configurationView;
    private MainToolBar toolBar;
    private JPanel waitingPane;
    private boolean exitRequested = false;

    private JDGui() {
        super("");
        ClipboardHandler.getClipboard().setTempDisabled(true);
        this.mainFrame.setName("MAINFRAME");
        this.initDefaults();
        this.initComponents();
        this.setWindowIcon();
        this.setWindowTitle(JDUtilities.getJDTitle());
        this.layoutComponents();
        this.mainFrame.pack();
        this.initLocationAndDimension();
        this.mainFrame.setVisible(true);
        if (this.mainFrame.getRootPane().getUI().toString().contains("SyntheticaRootPaneUI")) {
            ((SyntheticaRootPaneUI)this.mainFrame.getRootPane().getUI()).setMaximizedBounds((Frame)this.mainFrame);
        }
        ClipboardHandler.getClipboard().setTempDisabled(false);
        LinkGrabberController.getInstance().setDistributer((LinkGrabberDistributeEvent)this);
    }

    @Override
    public void displayMiniWarning(String shortWarn, String longWarn) {
        Balloon.show(shortWarn, JDTheme.II((String)"gui.images.warning", (int)32, (int)32), longWarn);
    }

    private void initLocationAndDimension() {
        Dimension dim = GUIUtils.getLastDimension(this.mainFrame, null);
        if (dim == null) {
            dim = new Dimension(800, 600);
        }
        this.mainFrame.setPreferredSize(dim);
        this.mainFrame.setSize(dim);
        this.mainFrame.setMinimumSize(new Dimension(400, 100));
        this.mainFrame.setLocation(GUIUtils.getLastLocation(null, null, this.mainFrame));
        this.mainFrame.setExtendedState(GUIUtils.getConfig().getIntegerProperty("MAXIMIZED_STATE_OF_" + this.mainFrame.getName(), 0));
        if (this.mainFrame.getRootPane().getUI().toString().contains("SyntheticaRootPaneUI")) {
            ((SyntheticaRootPaneUI)this.mainFrame.getRootPane().getUI()).setMaximizedBounds((Frame)this.mainFrame);
        }
    }

    private void initComponents() {
        this.menuBar = this.createMenuBar();
        this.statusBar = new JDStatusBar();
        this.waitingPane = new JPanel();
        this.waitingPane.setOpaque(false);
        this.mainTabbedPane = MainTabbedPane.getInstance();
        this.multiProgressBar = new TabProgress();
        this.toolBar = MainToolBar.getInstance();
        this.toolBar.registerAccelerators(this);
        this.downloadView = DownloadView.getInstance();
        this.linkgrabberView = LinkgrabberView.getInstance();
        this.configurationView = new ConfigurationView();
        this.mainTabbedPane.addTab(this.downloadView);
        this.mainTabbedPane.addTab(this.linkgrabberView);
        this.mainTabbedPane.addTab(this.configurationView);
        this.mainTabbedPane.setSelectedComponent(this.downloadView);
        this.toolBar.setList(((ArrayList)GUIUtils.getConfig().getGenericProperty("TOOLBAR", ToolBar.DEFAULT_LIST)).toArray(new String[0]));
    }

    private void layoutComponents() {
        JPanel contentPane = new JPanel();
        this.mainFrame.setContentPane(contentPane);
        MigLayout mainLayout = new MigLayout("ins 0 0 0 0,wrap 1", "[grow,fill]", "[grow,fill]0[shrink]");
        contentPane.setLayout((LayoutManager)mainLayout);
        this.mainFrame.setJMenuBar(this.menuBar);
        this.mainFrame.add((Component)this.toolBar, "dock NORTH");
        contentPane.add(this.mainTabbedPane);
        contentPane.add((Component)this.multiProgressBar, "hidemode 3");
        contentPane.add((Component)this.statusBar, "dock SOUTH");
    }

    private void initDefaults() {
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(this);
        ToolTipManager.sharedInstance().setReshowDelay(0);
    }

    public void setWindowTitle(final String msg) {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                JDGui.this.mainFrame.setTitle(msg);
                return null;
            }
        }.start();
    }

    private void setWindowIcon() {
        if (JDUtilities.getJavaVersion() >= 1.6) {
            ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
            list.add(JDImage.getImage((String)"logo/logo_14_14"));
            list.add(JDImage.getImage((String)"logo/logo_15_15"));
            list.add(JDImage.getImage((String)"logo/logo_16_16"));
            list.add(JDImage.getImage((String)"logo/logo_17_17"));
            list.add(JDImage.getImage((String)"logo/logo_18_18"));
            list.add(JDImage.getImage((String)"logo/logo_19_19"));
            list.add(JDImage.getImage((String)"logo/logo_20_20"));
            list.add(JDImage.getImage((String)"logo/jd_logo_64_64"));
            this.mainFrame.setIconImages(list);
        } else {
            this.mainFrame.setIconImage(JDImage.getImage((String)"logo/logo_17_17"));
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar ret = new JMenuBar();
        JMenu file = new JMenu(JDL.L((String)"jd.gui.skins.simple.simplegui.menubar.filemenu", (String)"File"));
        file.add(new SaveMenu());
        file.addSeparator();
        file.add(new RestoreAction());
        file.add(new RestartAction());
        file.add(new ExitAction());
        JMenu edit = new JMenu(JDL.L((String)"jd.gui.skins.simple.simplegui.menubar.linksmenu", (String)"Links"));
        edit.add(new AddLinksMenu());
        edit.add(new CleanupMenu());
        ret.add(file);
        ret.add(edit);
        JStartMenu m = PremiumMenu.getInstance();
        ret.add(m);
        m.setIcon(null);
        m = AddonsMenu.getInstance();
        ret.add(m);
        m.setIcon(null);
        m = new AboutMenu();
        ret.add(m);
        m.setIcon(null);
        return ret;
    }

    public static JDGui getInstance() {
        if (INSTANCE == null) {
            INSTANCE = (JDGui)new GuiRunnable<JDGui>(){

                @Override
                public JDGui runSave() {
                    return new JDGui(null);
                }
            }.getReturnValue();
        }
        return INSTANCE;
    }

    @Override
    public void setFrameStatus(int id) {
        switch (id) {
            case 1: {
                this.mainFrame.setState(6);
                break;
            }
            case 0: {
                this.mainFrame.setState(1);
                break;
            }
            case 3: {
                this.mainFrame.setState(0);
                this.mainFrame.setVisible(true);
                break;
            }
            case 4: {
                this.mainFrame.setState(0);
                this.mainFrame.setFocusableWindowState(false);
                this.mainFrame.setVisible(true);
                this.mainFrame.toFront();
                this.mainFrame.setFocusableWindowState(true);
            }
        }
    }

    public void controlEvent(ControlEvent event) {
        switch (event.getID()) {
            case 30: {
                JDLogger.getLogger().info("Init complete");
                new GuiRunnable<Object>(){

                    @Override
                    public Object runSave() {
                        JDGui.this.mainFrame.setEnabled(true);
                        return null;
                    }
                }.start();
                if (!GUIUtils.getConfig().getBooleanProperty("START_DOWNLOADS_AFTER_START", false).booleanValue() || JDUtilities.getConfiguration().getBooleanProperty("WEBUPDATE_AUTO_RESTART", false).booleanValue()) break;
                JDController.getInstance().autostartDownloadsonStartup();
                break;
            }
            case 26: {
                this.exitRequested = true;
                final String id = JDController.requestDelayExit((String)"JDGUI");
                new GuiRunnable<Object>(){

                    @Override
                    public Object runSave() {
                        JDGui.this.mainTabbedPane.onClose();
                        GUIUtils.saveLastLocation(JDGui.this.getMainFrame(), null);
                        GUIUtils.saveLastDimension(JDGui.this.getMainFrame(), null);
                        GUIUtils.getConfig().save();
                        JDController.releaseDelayExit((String)id);
                        JDGui.this.getMainFrame().setVisible(false);
                        JDGui.this.getMainFrame().dispose();
                        return null;
                    }
                }.start();
                break;
            }
            case 1: {
                for (DownloadLink link : DownloadController.getInstance().getAllDownloadLinks()) {
                    if (!link.getLinkStatus().hasStatus(1)) continue;
                    JDLogger.getLogger().info("Downloads stopped");
                    return;
                }
                JDLogger.getLogger().info("All downloads finished");
                break;
            }
            case 13: {
                Balloon.showIfHidden(JDL.L((String)"ballon.download.title", (String)"Download"), JDTheme.II((String)"gui.images.next", (int)32, (int)32), JDL.L((String)"ballon.download.finished.started", (String)"Download started"));
                break;
            }
            case 6: {
                Balloon.showIfHidden(JDL.L((String)"ballon.download.title", (String)"Download"), JDTheme.II((String)"gui.images.stop", (int)32, (int)32), JDL.L((String)"ballon.download.finished.stopped", (String)"Download stopped"));
            }
        }
    }

    public boolean isExitRequested() {
        return this.exitRequested;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getComponent() == this.getMainFrame()) {
            OptionalPluginWrapper addon = JDUtilities.getOptionalPlugin((String)"trayicon");
            if (addon != null && addon.isEnabled() && ((Boolean)addon.getPlugin().interact("enabled", null)).booleanValue()) {
                UserIO.getInstance().requestConfirmDialog(52, JDL.L((String)"sys.warning.noclose", (String)"JDownloader will be minimized to tray!"));
                return;
            }
            if (OSDetector.isMac()) {
                new GuiRunnable<Object>(){

                    @Override
                    public Object runSave() {
                        JDGui.this.getMainFrame().setVisible(false);
                        return null;
                    }
                }.start();
                return;
            }
            this.closeWindow();
        }
    }

    @Override
    public void closeWindow() {
        if (JDFlags.hasSomeFlags((int)UserIO.getInstance().requestConfirmDialog(548, JDL.L((String)"sys.ask.rlyclose", (String)"Wollen Sie jDownloader wirklich schlie\u00dfen?")), (int[])new int[]{2})) {
            JDUtilities.getController().exit();
        }
    }

    @Override
    public void setWaiting(boolean b) {
        this.internalSetWaiting(b);
    }

    protected void internalSetWaiting(final boolean b) {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                JDGui.this.getMainFrame().setGlassPane(JDGui.this.waitingPane);
                JDGui.this.waitingPane.setCursor(Cursor.getPredefinedCursor(3));
                JDGui.this.getMainFrame().getGlassPane().setVisible(b);
                return null;
            }
        }.waitForEDT();
    }

    @Override
    public void setContent(SwitchPanel tabbedPanel) {
        View view = tabbedPanel instanceof View ? (View)tabbedPanel : new TabbedPanelView(tabbedPanel);
        if (!this.mainTabbedPane.contains(view)) {
            this.mainTabbedPane.addTab(view);
        }
        this.mainTabbedPane.setSelectedComponent(view);
    }

    public MainTabbedPane getMainTabbedPane() {
        return this.mainTabbedPane;
    }

    @Override
    public void requestPanel(final UserIF.Panels panel, final Object param) {
        new GuiRunnable<Object>(){

            @Override
            public Object runSave() {
                switch (panel) {
                    case DOWNLOADLIST: {
                        JDGui.this.mainTabbedPane.setSelectedComponent(JDGui.this.downloadView);
                        break;
                    }
                    case LINKGRABBER: {
                        JDGui.this.mainTabbedPane.setSelectedComponent(JDGui.this.linkgrabberView);
                        break;
                    }
                    case PREMIUMCONFIG: {
                        ((ConfigSidebar)JDGui.this.configurationView.getSidebar()).setSelectedTreeEntry(Premium.class);
                        JDGui.this.mainTabbedPane.setSelectedComponent(JDGui.this.configurationView);
                        if (param == null || !(param instanceof Account)) break;
                        Premium p = (Premium)JDGui.this.configurationView.getContent();
                        p.setSelectedAccount((Account)param);
                        break;
                    }
                    case ADDON_MANAGER: {
                        ((ConfigSidebar)JDGui.this.configurationView.getSidebar()).setSelectedTreeEntry(ConfigPanelAddons.class);
                        JDGui.this.mainTabbedPane.setSelectedComponent(JDGui.this.configurationView);
                        break;
                    }
                    case CONFIGPANEL: {
                        if (!(param instanceof ConfigContainer)) break;
                        if (((ConfigContainer)param).getEntries().size() == 0) {
                            return null;
                        }
                        JDGui.this.showConfigPanel((ConfigContainer)param);
                        break;
                    }
                    default: {
                        JDGui.this.mainTabbedPane.setSelectedComponent(JDGui.this.downloadView);
                    }
                }
                return null;
            }
        }.start();
    }

    protected void showConfigPanel(ConfigContainer container) {
        String name = "";
        if (container.getTitle() != null) {
            name = container.getTitle();
        }
        if (name == null && container.getGroup() != null && container.getGroup().getName() != null) {
            name = container.getGroup().getName();
        }
        ImageIcon icon = null;
        if (container.getIcon() != null) {
            icon = container.getIcon();
        }
        if (icon == null && container.getGroup() != null && container.getGroup().getIcon() != null) {
            icon = container.getGroup().getIcon();
        }
        AddonConfig p = AddonConfig.getInstance(container, name, "_2");
        JDCollapser col = new JDCollapser(){
            private static final long serialVersionUID = 1L;

            public void onClosed() {
                JDGui.this.mainTabbedPane.getSelectedView().setInfoPanel(null);
            }

            protected void onHide() {
            }

            protected void onShow() {
            }
        };
        col.getContent().add(p.getPanel());
        col.setInfos(name, icon);
        this.mainTabbedPane.getSelectedView().setInfoPanel(col);
    }

    @Override
    public void disposeView(SwitchPanel view) {
        if (view instanceof View) {
            view = this.mainTabbedPane.getComponentEquals((View)view);
            this.mainTabbedPane.remove((View)view);
        }
    }

    public void addLinks(final ArrayList<DownloadLink> links, boolean hidegrabber, final boolean autostart) {
        if (links.size() == 0) {
            return;
        }
        if (hidegrabber || autostart) {
            new Thread(){

                public void run() {
                    ArrayList<FilePackage> fps = new ArrayList<FilePackage>();
                    FilePackage fp = FilePackage.getInstance();
                    fp.setName("Added " + System.currentTimeMillis());
                    for (DownloadLink link : links) {
                        if (link.getFilePackage() == FilePackage.getDefaultFilePackage()) {
                            fp.add(link);
                            if (fps.contains(fp)) continue;
                            fps.add(fp);
                            continue;
                        }
                        if (fps.contains(link.getFilePackage())) continue;
                        fps.add(link.getFilePackage());
                    }
                    LinkCheck.getLinkChecker().checkLinksandWait(links);
                    if (GUIUtils.getConfig().getBooleanProperty("PARAM_INSERT_NEW_LINKS_AT2", false).booleanValue()) {
                        DownloadController.getInstance().addAllAt(fps, 0);
                    } else {
                        DownloadController.getInstance().addAll(fps);
                    }
                    if (autostart) {
                        DownloadWatchDog.getInstance().startDownloads();
                    }
                }
            }.start();
        } else {
            LinkGrabberPanel.getLinkGrabber().addLinks(links);
            this.requestPanel(UserIF.Panels.LINKGRABBER, null);
        }
    }

    public static /* bridge */ /* synthetic */ SwingGui getInstance() {
        return JDGui.getInstance();
    }

    /* synthetic */ JDGui(JDGui jDGui) {
        this();
    }
}

