/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.swing.jdgui.components.premiumbar.PremiumStatus;
import jd.nutils.Formatter;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class JDStatusBar
extends JPanel
implements ChangeListener,
ControlListener {
    private static final long serialVersionUID = 3676496738341246846L;
    private SubConfiguration dlConfig = SubConfiguration.getConfig((String)"DOWNLOAD");
    private JDSpinner spMaxChunks;
    private JDSpinner spMaxDls;
    private JDSpinner spMaxSpeed;

    public JDStatusBar() {
        this.initGUI();
    }

    private void initGUI() {
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.getBackground().darker()));
        this.setLayout((LayoutManager)new MigLayout("ins 0 0 0 0", "[fill,grow,left][shrink,right][shrink,right][shrink,right][shrink,right][shrink,right]", "[23px!]"));
        JDUtilities.getController().addControlListener((ControlListener)this);
        this.spMaxSpeed = new JDSpinner(JDL.L((String)"gui.statusbar.speed", (String)"Max. Speed"));
        this.spMaxSpeed.getSpinner().setModel(new SpinnerNumberModel(this.dlConfig.getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0), 0, Integer.MAX_VALUE, 50));
        this.spMaxSpeed.setToolTipText(JDL.L((String)"gui.tooltip.statusbar.speedlimiter", (String)"Geschwindigkeitsbegrenzung festlegen (KB/s) [0:unendlich]"));
        this.colorizeSpinnerSpeed();
        this.spMaxDls = new JDSpinner(JDL.L((String)"gui.statusbar.sim_ownloads", (String)"Max. Dls."));
        this.spMaxDls.getSpinner().setModel(new SpinnerNumberModel(this.dlConfig.getIntegerProperty("DOWNLOAD_MAX_SIMULTAN", 2), 1, 20, 1));
        this.spMaxDls.setToolTipText(JDL.L((String)"gui.tooltip.statusbar.simultan_downloads", (String)"Max. gleichzeitige Downloads"));
        this.spMaxChunks = new JDSpinner(JDL.L((String)"gui.statusbar.maxChunks", (String)"Max. Con."));
        this.spMaxChunks.getSpinner().setModel(new SpinnerNumberModel(this.dlConfig.getIntegerProperty("DOWNLOAD_MAX_CHUNKS", 2), 1, 20, 1));
        this.spMaxChunks.setToolTipText(JDL.L((String)"gui.tooltip.statusbar.max_chunks", (String)"Max. Connections/File"));
        this.add((Component)new PremiumStatus(), "gaptop 1,aligny top");
        this.add(this.spMaxChunks);
        this.add(this.spMaxDls);
        this.add(this.spMaxSpeed);
    }

    private void colorizeSpinnerSpeed() {
        if (this.spMaxSpeed.getValue() > 0) {
            this.spMaxSpeed.setColor(JDTheme.C((String)"gui.color.statusbar.maxspeedhighlight", (String)"ff0c03"));
        } else {
            this.spMaxSpeed.setColor(null);
        }
    }

    public void controlEvent(ControlEvent event) {
        if (event.getID() == 27) {
            final Property p = (Property)event.getSource();
            if (event.getParameter().equals("DOWNLOAD_MAX_SPEED_V2")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JDStatusBar.this.setSpinnerSpeed(p.getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0));
                    }
                });
            } else if (event.getParameter().equals("DOWNLOAD_MAX_SIMULTAN")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JDStatusBar.this.spMaxDls.setValue(p.getIntegerProperty("DOWNLOAD_MAX_SIMULTAN", 2));
                    }
                });
            } else if (event.getParameter().equals("DOWNLOAD_MAX_CHUNKS")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JDStatusBar.this.spMaxChunks.setValue(p.getIntegerProperty("DOWNLOAD_MAX_CHUNKS", 1));
                    }
                });
            }
        }
    }

    public void setSpeed(int speed) {
        if (speed <= 0) {
            this.spMaxSpeed.setText(JDL.L((String)"gui.statusbar.speed", (String)"Max. Speed"));
        } else {
            this.spMaxSpeed.setText("(" + Formatter.formatReadable((long)speed) + "/s)");
        }
    }

    public void setSpinnerSpeed(Integer speed) {
        this.spMaxSpeed.setValue(speed);
        this.colorizeSpinnerSpeed();
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.spMaxSpeed.getSpinner()) {
            this.dlConfig.setProperty("DOWNLOAD_MAX_SPEED_V2", (Object)this.spMaxSpeed.getValue());
            this.dlConfig.save();
        } else if (e.getSource() == this.spMaxDls.getSpinner()) {
            this.dlConfig.setProperty("DOWNLOAD_MAX_SIMULTAN", (Object)this.spMaxDls.getValue());
            this.dlConfig.save();
        } else if (e.getSource() == this.spMaxChunks.getSpinner()) {
            this.dlConfig.setProperty("DOWNLOAD_MAX_CHUNKS", (Object)this.spMaxChunks.getValue());
            this.dlConfig.save();
        }
    }

    private class JDSpinner
    extends JPanel {
        private static final long serialVersionUID = 8892482065686899916L;
        private JLabel lbl;
        private JSpinner spn;

        public JDSpinner(String label) {
            super((LayoutManager)new MigLayout("ins 0", "[][grow,fill]"));
            this.lbl = new JLabel(label){
                private static final long serialVersionUID = 8794670984465489135L;

                public Point getToolTipLocation(MouseEvent e) {
                    return new Point(0, -25);
                }
            };
            this.spn = new JSpinner();
            this.spn.addChangeListener(JDStatusBar.this);
            this.add(this.lbl);
            this.add((Component)this.spn, "w 70!, h 20!");
        }

        public JSpinner getSpinner() {
            return this.spn;
        }

        public void setText(String s) {
            this.lbl.setText(s);
        }

        public void setValue(Integer i) {
            this.spn.setValue(i);
        }

        public Integer getValue() {
            return (Integer)this.spn.getValue();
        }

        public void setColor(Color c) {
            this.lbl.setForeground(c);
            ((JSpinner.DefaultEditor)this.spn.getEditor()).getTextField().setForeground(c);
        }

        public void setToolTipText(String s) {
            this.lbl.setToolTipText(s);
        }
    }
}

