/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.toolbar;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jd.controlling.JDLogger;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.ShortCuts;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.actions.ActionController;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.utils.JDUtilities;
import net.miginfocom.swing.MigLayout;

public class ToolBar
extends JToolBar {
    private static final long serialVersionUID = 7533137014274040205L;
    private static final Object UPDATELOCK = new Object();
    public static final ArrayList<String> DEFAULT_LIST = new ArrayList();
    private String[] current = null;
    private JRootPane rootpane;

    static {
        DEFAULT_LIST.add("toolbar.control.start");
        DEFAULT_LIST.add("toolbar.control.pause");
        DEFAULT_LIST.add("toolbar.control.stop");
        DEFAULT_LIST.add("toolbar.separator");
        DEFAULT_LIST.add("action.downloadview.movetotop");
        DEFAULT_LIST.add("action.downloadview.moveup");
        DEFAULT_LIST.add("action.downloadview.movedown");
        DEFAULT_LIST.add("action.downloadview.movetobottom");
        DEFAULT_LIST.add("toolbar.separator");
        DEFAULT_LIST.add("toolbar.quickconfig.clipboardoberserver");
        DEFAULT_LIST.add("toolbar.quickconfig.reconnecttoggle");
        DEFAULT_LIST.add("toolbar.control.stopmark");
        DEFAULT_LIST.add("toolbar.separator");
        DEFAULT_LIST.add("toolbar.interaction.reconnect");
        DEFAULT_LIST.add("toolbar.interaction.update");
    }

    public ToolBar() {
        super(0);
        this.setRollover(true);
        this.setFloatable(false);
        ActionController.initActions();
        this.current = DEFAULT_LIST.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setList(String[] newlist) {
        if (newlist == this.current) {
            return;
        }
        Object object = UPDATELOCK;
        synchronized (object) {
            this.current = newlist == null || newlist.length == 0 ? DEFAULT_LIST.toArray(new String[0]) : newlist;
            this.updateToolbar();
        }
    }

    public String[] getList() {
        return this.current;
    }

    private String getColConstraints(String[] list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            sb.append("[]2");
            ++i;
        }
        sb.append("[grow,fill]");
        return sb.toString();
    }

    public void registerAccelerators(SwingGui jdGui) {
        this.rootpane = jdGui.getMainFrame().getRootPane();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initToolbar(String[] list) {
        if (list == null) {
            return;
        }
        String[] stringArray = list;
        synchronized (list) {
            SwingGui.checkEDT();
            this.setLayout((LayoutManager)new MigLayout("ins 0, gap 0", this.getColConstraints(list)));
            boolean lastseperator = false;
            int i = 0;
            while (i < list.length) {
                String key = list[i];
                ToolBarAction action = ActionController.getToolBarAction(key);
                if (action == null) {
                    JDLogger.warning((Object)("The Action " + key + " is not available"));
                } else {
                    action.init();
                    AbstractButton ab = null;
                    switch (action.getType()) {
                        case NORMAL: {
                            ab = this.add(action);
                            lastseperator = false;
                            break;
                        }
                        case SEPARATOR: {
                            if (lastseperator) break;
                            this.add((Component)new JSeparator(1), "height 32,gapleft 10,gapright 10");
                            lastseperator = true;
                            break;
                        }
                        case TOGGLE: {
                            ab = new JToggleButton(action);
                            this.add(ab);
                            if (JDUtilities.getJavaVersion() < 1.6) {
                                final AbstractButton button = ab;
                                ab.setSelected(action.isSelected());
                                action.addPropertyChangeListener(new PropertyChangeListener(){

                                    public void propertyChange(final PropertyChangeEvent evt) {
                                        if (evt.getPropertyName() == "SwingSelectedKey") {
                                            new GuiRunnable<Object>(){

                                                @Override
                                                public Object runSave() {
                                                    button.setSelected((Boolean)evt.getNewValue());
                                                    return null;
                                                }
                                            }.start();
                                        } else if (evt.getPropertyName() == "SwingLargeIconKey") {
                                            new GuiRunnable<Object>(){

                                                @Override
                                                public Object runSave() {
                                                    button.setIcon((Icon)evt.getNewValue());
                                                    return null;
                                                }
                                            }.start();
                                        }
                                    }
                                });
                            }
                            if (action.getValue("SmallIcon") != null || action.getValue("SwingLargeIconKey") != null) {
                                ab.setText("");
                            }
                            lastseperator = false;
                        }
                    }
                    if (ab != null) {
                        if (JDUtilities.getJavaVersion() < 1.6 && action.getValue("SwingLargeIconKey") != null) {
                            ab.setIcon((Icon)action.getValue("SwingLargeIconKey"));
                        }
                        KeyStroke ks = (KeyStroke)action.getValue("AcceleratorKey");
                        this.rootpane.getInputMap(1).put(ks, action);
                        this.rootpane.getInputMap(2).put(ks, action);
                        this.rootpane.getActionMap().put(action, action);
                        if (action.getValue("AcceleratorKey") != null) {
                            ab.setToolTipText(String.valueOf(action.getTooltipText()) + " [" + ShortCuts.getAcceleratorString((KeyStroke)action.getValue("AcceleratorKey")) + "]");
                        } else if (action.getValue("MnemonicKey") != null) {
                            ab.setToolTipText(String.valueOf(action.getTooltipText()) + " [Alt+" + new String(new byte[]{((Integer)action.getValue("MnemonicKey")).byteValue()}) + "]");
                        } else {
                            ab.setToolTipText(action.getTooltipText());
                        }
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateToolbar() {
        Object object = UPDATELOCK;
        synchronized (object) {
            new GuiRunnable<Object>(){

                @Override
                public Object runSave() {
                    ToolBar.this.setVisible(false);
                    ToolBar.this.removeAll();
                    ToolBar.this.initToolbar(ToolBar.this.current);
                    ToolBar.this.setVisible(true);
                    ToolBar.this.revalidate();
                    return null;
                }
            }.waitForEDT();
        }
    }
}

